/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.xslf.usermodel;

/**
 *
 *
 * @author Yegor Kozlov
 */
public class LineCap {
    /**
     *  Rounded ends
     */
    public static final LineCap ROUND = new LineCap(0);
    /**
     * Square protrudes by half line width
     */
    public static final LineCap SQUARE = new LineCap(1);

    /**
     *  Line ends at end point
     */
    public static final LineCap FLAT = new LineCap(2);

	private int _ordinal;

	public LineCap(int ordinal) {
		this._ordinal = ordinal;
	}

	public int ordinal() {
		return this._ordinal;
	}

	public static LineCap[] values() {
		return new LineCap[] { ROUND, SQUARE, FLAT };
	}

}