package PositLogPlugin::Alias;

# --------------------------------------------------------
# Alias.pm:
#      module for creating alias
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

use strict;
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use PositLogConfig;
use PositLogSprites;

my $sourceID = "";
my $pageid = "";

sub getType{
    return "alias";
}

sub clearCache{
    return "No cache.";
}


sub getSprites
  {
    my ($pageid_, $sourceID_, $loginid, $loginpass, $args) = @_;

    $pageid = $pageid_;
    $sourceID = $sourceID_;
    my @argsArray = split(/,/, $args);
    my $sourcepageid = $argsArray[0];
    my $substanceID = $argsArray[1];
    my @spritesArray;

    my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
    my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
    my $loginerror = "";
    my $validUser = 0;
    my $adminUser = 0;

    # Check admin -> Check valid user -> show error
    if ($adminnameAuth ne "" && $adminnameAuth->{$loginid}) {
				my $cryptpass = $adminnameAuth->{$loginid}{"password"};
				my $salt="lc";
				my $cryptpass2 = crypt($loginpass, $salt);
				if ($cryptpass eq $cryptpass2) {
						$validUser = 1;
						$adminUser = 1;
				} else {
						$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
						$validUser = 0;
						$adminUser = 0;
				}
    } elsif ($useridAuth ne "" && $useridAuth->{$loginid}) {
				my $cryptpass = $useridAuth->{$loginid}{"password"};
				my $salt="ry";
				my $cryptpass2 = crypt($loginpass, $salt);
				if ($cryptpass eq $cryptpass2) {
						$validUser = 1;
						$adminUser = 0;
				} else {
						$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
						$validUser = 0;
						$adminUser = 0;
				}
    } else {
				if ($loginid eq "" && $loginpass eq "") {
						$loginerror = "";
				} else {
						$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
				}
				$validUser = 0;
				$adminUser = 0;
    }

    my $canRead = 0;
    my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $sourcepageid . "/permission.cgi")};
    if ($@) {
				warn $@; print "Cannot read permission.cgi."; return \@spritesArray;
    }

    if ($adminUser) {
				$canRead = 1;
    } elsif (scalar($permissionHash->{"read_page"}{"public"}) == 1) {
				$canRead = 1;
    } else {
				# check user list
				if (scalar($permissionHash->{"read_page"}{$loginid}) == 1) {
						$canRead = 1;
				} else {
						# check user group list
						foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}}) {
								my $usergroupnameenc = $usergroupname;
								$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
								$usergroupnameenc =~ tr/ /+/;
								
								my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
								if ($UserList eq "") {
										print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0);
								}
								;
								if (scalar($UserList->{$loginid}) == 1) {
										$canRead = 1;
								}
						}
				}
    }

    if (!$canRead) {
				return \@spritesArray;
    }


    # get sprites
    my $spritesHashOrg = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
    if ($@) {
				warn $@; print "Cannot read the sprite list.\n"; return \@spritesArray;
    }

    my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $sourcepageid . "/sprites.dat")};
    if ($@) {
				warn $@; print "Cannot read the sprite list.\n"; return \@spritesArray;
    }

    my $newContents = "";

		my $spritesObj = PositLogSprites->new();
		$spritesObj->{pageid} = $sourcepageid;
		$spritesObj->{classname} = "sprite";
		$spritesObj->{pageSpritesHash} = $spritesHash;


		# save sprite
#		$spritesHashOrg->{$sourceID}{"type"} = "dynamic";
#		$spritesHashOrg->{$sourceID}{"plugin_source"} = $sourceID;

		my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $sourcepageid . "/static/" . $substanceID.".spr")} or "";
		if (!eval{Storable::lock_nstore $spriteContents, $PositLogConfig::datapath . $pageid . "/static/" . $sourceID.".spr"}) {
				print "Cannot write .spr.";
		}

#		my $treeBody = PositLogSprites::getContents($spritesObj, $substanceID, $sourceID, "Alias");
		push(@spritesArray, {"modified_time" => $spritesHash->{$substanceID}{"modified_time"}, "id" => $sourceID, "body" => $$spriteContents});


		$spritesHashOrg->{$sourceID}{"created_time"} = $spritesHash->{$substanceID}{"created_time"};
		$spritesHashOrg->{$sourceID}{"modified_time"} = $spritesHash->{$substanceID}{"modified_time"};

    if (!eval{Storable::lock_nstore $spritesHashOrg, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){
				print "Cannot write the sprite list."; exit(0);
    }
		
    return \@spritesArray;
}


1;

