#!/usr/local/bin/perl

# --------------------------------------------------------
#
# createPage.cgi:
#      cgi for creating new PositLog page
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8');  # HTTP header

my $pageid = $CGI->param("pageid"); # id of current page
my $newpagetitle = $CGI->param("newpagetitle"); # title of new page

my $newleft = $CGI->param("left");
my $newtop = $CGI->param("top");


# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

# authentication
my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
  my $cryptpass = $adminnameAuth->{$loginid}{"password"};
  my $salt="lc";
  my $cryptpass2 = crypt($loginpass, $salt);
  if($cryptpass eq $cryptpass2)
    {
      $validUser = 1;
      $adminUser = 1;
      $publicUser = 0;
    }
  else
    {
      print "Permission denied.";
      exit(0);
    }
}
elsif($usernameAuth ne "" && $usernameAuth->{$loginid})
{
  my $cryptpass = $usernameAuth->{$loginid}{"password"};
  my $salt="ry";
  my $cryptpass2 = crypt($loginpass, $salt);
  if($cryptpass eq $cryptpass2)
    {
      $adminUser = 0;
      $validUser = 1;
      $publicUser = 0;
    }
  else
    {
      print "Permission denied.";
      exit(0);
    }
}
else
{
  $adminUser = 0;
  $validUser = 0;
  $publicUser = 1;
}

my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
if($permissionHash eq ""){ print "Cannot read permission.cgi."; exit(0); }

my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($configHash eq ""){ print "Cannot read config.dat."; exit(0); }

my $newpageid = "";
my $oldpagetitle = "";

if($adminUser || scalar($permissionHash->{"create_page"}{$loginid}) == 1)
{

  # Get current page list
  opendir( DATADIR, $PositLogConfig::datapath );
  my @PageList = readdir( DATADIR );
  closedir( DATADIR );

  # generate new pageID

  my @alpha = ('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  do
    {
      my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
      ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
      my $createtime = sprintf("%02d%02d%02d", $year+1900-2000, $mon+1, $mday);
      my $rand = int (rand(52));
      my $rand2 = int (rand(52));
      $newpageid = $createtime . $alpha[$rand] . $alpha[$rand2];
    }
  while((grep {$_ eq $newpageid} @PageList) != 0);


  if(!mkdir($PositLogConfig::datapath . $newpageid, 0755))
    {
      print "Cannot create a page directory '" . $newpageid . " '.";
      exit(0);
    }

  if(!mkdir($PositLogConfig::datapath . $newpageid ."/static", 0755))
    {
      print "Cannot create a static sprite directory in '" . $newpageid . " '.";
      exit(0);
    }

  if(!mkdir($PositLogConfig::datapath . $newpageid ."/dynamic", 0755))
    {
      print "Cannot create a dynamic sprite directory in '" . $newpageid . " '.";
      exit(0);
    }

  if(!eval{Storable::lock_nstore $permissionHash, $PositLogConfig::datapath . $newpageid . "/permission.cgi"}){ print "Cannot write the permission file."; exit(0); }


  # overwrite new properties on config.dat
  my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
  my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
  $configHash->{"created_time"} = $time;
  $configHash->{"modified_time"} = $time;

  $oldpagetitle = $configHash->{"page_title"};
  $configHash->{"page_title"} = $newpagetitle;
  $configHash->{"author_id"} = $loginid;
  
  if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $newpageid . "/config.dat"}){ print "Cannot write the page configuration."; exit(0);}

}
else
{
  print "Permission denied.";
  exit(0);
}

# generate link to the new page on the old page
my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){ print "Cannot read sprites.dat."; exit(0); }

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $createtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
my $rand = int (rand(99999999));
my $newSpriteID = "sprite_" . $createtime . "_" . $rand;
my $newContents = "<div style='padding:5px; border:1px solid #a0a0a0;text-align:center'><a href='" . $PositLogConfig::cgipath . "positlog.cgi?load=". $newpageid . "'>" . $newpagetitle . "</a></div>";
Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $pageid . "/static/" . $newSpriteID.".spr";

$spritesHash->{$newSpriteID}{"author_id"} =	$configHash->{"author_id"};

#$spritesHash->{$newSpriteID}{"style"} = "left: 20px; top:20px; width: 120px; z-index: 500000; border-left:0px none #000000; border-top:0px none #000000; border-right:0px none #000000; border-bottom:0px none #000000;";
$spritesHash->{$newSpriteID}{"style"} = "left:" .  $newleft . "px; top:" . $newtop .  "px; width: 120px;  z-index:500000;  border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000;";

$spritesHash->{$newSpriteID}{"public_password"} = "";
if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"})
{
  print "Cannot write sprites.dat.";
  exit(0);
}


# generate link to the old page on the new page
($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
$createtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
$rand = int (rand(99999999));
$newSpriteID = "sprite_" . $createtime . "_" . $rand;
$newContents = "<div style='padding:5px; border:1px solid #a0a0a0;text-align:center'><a href='" . $PositLogConfig::cgipath . "positlog.cgi?load=". $pageid . "'>" . $oldpagetitle . "</a></div>";
Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $newpageid . "/static/" . $newSpriteID.".spr";

my %spritesHash2;

$spritesHash2{$newSpriteID}{"author_id"} =	$configHash->{"author_id"};

$spritesHash2{$newSpriteID}{"style"} = "left: 20px; top:20px; width: 120px; z-index: 500000; border-left:0px none #000000; border-top:0px none #000000; border-right:0px none #000000; border-bottom:0px none #000000;";
$spritesHash2{$newSpriteID}{"public_password"} = "";

if(!eval{Storable::lock_nstore \%spritesHash2, $PositLogConfig::datapath . $newpageid . "/sprites.dat"})
{
  print "Cannot write sprites.dat.";
  exit(0);
}


print "succeed,$newpageid";
