/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.BrokenLog;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class BrokenLogActions {
    private static final String[] SHOW_BROKEN_LOG_HEADER = new String[]{"SERVERID", "DATETIME", "CLIENT", "MSG", "STATUS", "QUERY "};

    public static void show(GSCdata gsc) {
        BrokenLog[] brokenLogs;
        try {
            brokenLogs = gsc.getBrokenLogs();
        }
        catch (Exception e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.brokenlog.show"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.brokenlog.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_BROKEN_LOG_HEADER);
        if (brokenLogs != null) {
            for (int i = 0; i < brokenLogs.length; ++i) {
                BrokenLog brokenLog = brokenLogs[i];
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Integer(brokenLog.getServerId()));
                row.add(brokenLog.getTimestamp());
                row.add(brokenLog.getClient());
                row.add(brokenLog.getMessage());
                row.add(brokenLog.getState());
                row.add(brokenLog.getQuery());
                table2StringUtil.addRow(row);
            }
        }
        table2StringUtil.print();
    }

    public static void clear(GSCdata gsc) {
        try {
            gsc.clearBrokenLogs();
        }
        catch (Exception e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.brokenlog.clear"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.brokenlog.clear"));
    }
}

