/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class GscActions {
    private static String[] SHOW_GSC_HEADER = new String[]{"DBNAME", "HOST", "PORT", "SERVERID"};

    public static void make(String hostname, String portno, String gscname, String username, String userpass) {
        try {
            GSCdata.initialize((String)hostname, (String)portno, (String)gscname, (String)username, (String)userpass);
            Logger.println((String)MessagesCommandLine.getString("cui.message.gsc.make", new Object[]{gscname}));
        }
        catch (ForestToolException e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.make", new Object[]{gscname}));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
        }
    }

    public static void create(CommandParser cp, GSCdata gsc) {
        int id = -1;
        try {
            id = Integer.parseInt((String)cp.getServer().get(0));
        }
        catch (NumberFormatException e) {
            Logger.error((String)"invalid argument.");
            return;
        }
        boolean force = cp.isForce();
        Instance instance = gsc.getInstance(id);
        if (instance == null) {
            Logger.error((String)("Cannot get instance[" + id + "]."));
            return;
        }
        String gscName = gsc.getGscName();
        int serverid = instance.getId();
        if (instance == null) {
            Logger.error((String)"invalid argument.");
            return;
        }
        if (!gsc.copy(instance, force)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.create", new Object[]{gscName, new Integer(serverid)}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.gsc.create", new Object[]{gscName, new Integer(serverid)}));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        int id = 0;
        try {
            id = Integer.parseInt((String)cp.getServer().get(0));
        }
        catch (NumberFormatException e) {
            Logger.error((String)"invalid argument.");
            return;
        }
        Instance instance = gsc.getInstance(id);
        if (instance == null) {
            Logger.error((String)"invalid argument.");
            return;
        }
        if (!gsc.drop(instance)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.drop", new Object[]{gsc.getGscName(), new Integer(instance.getId())}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.gsc.drop", new Object[]{gsc.getGscName(), new Integer(instance.getId())}));
    }

    public static void check(GSCdata gsc) {
        String gscNmae = gsc.getGscName();
        int[] ids = gsc.getGscInstances();
        for (int i = 0; i < ids.length; ++i) {
            Instance ins = gsc.getInstance(ids[i]);
            if (gsc.equals(ins)) continue;
            Logger.warning((String)("GSC consistency was broken on " + ins.toString()));
        }
        if (!gsc.validate(3)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.check"));
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.gsc.check"));
    }

    public static void show(GSCdata gsc) {
        int[] ids = gsc.getGscInstances();
        if (ids == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.show"));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.gsc.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_GSC_HEADER);
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            Instance instance = gsc.getInstance(id);
            if (instance == null) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.show"));
                return;
            }
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(gsc.getGscName());
            row.add(instance.getHostName());
            row.add(instance.getPortNumber());
            row.add(new Integer(instance.getId()));
            table2StringUtil.addRow(row);
        }
        table2StringUtil.print();
    }
}

