/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;

public class CommandHistory {
    private int m_maxHistory;
    static final FieldPosition pos = new FieldPosition(0);
    static final String SEPARATOR = " : ";
    protected LinkedList m_commandHis = new LinkedList();

    public CommandHistory(int max) {
        this.m_maxHistory = max;
    }

    public static void main(String[] args) {
        CommandHistory his = new CommandHistory(10);
        his.add("1damda;");
        his.add("2damdadda;");
        his.add("3dadadamda;");
        his.add("4dvzvzxamda;");
        his.add("5damda;");
        his.add("6damdadda;");
        his.add("7dadadamda;");
        his.add("8dvzvzxamda;");
        his.add("9damda;");
        his.add("10damdadda;");
        his.add("11dadadamda;");
        his.add("12dvzvzxa\nmda;");
        his.add("13damda;");
        his.add("14damdadda;");
        his.add("15dadadamda;");
        his.add("16dvzvzxamda;");
        his.add("17damda;");
        his.add("18damdadda;");
        his.add("19dadadamda;");
        his.add("20dvzvzxamda;");
        his.printHistory();
        System.out.println(his.get(1));
        his.printHistory();
    }

    public void add(String Command) {
        this.m_commandHis.addLast(Command);
        if (this.m_commandHis.size() > this.m_maxHistory) {
            this.m_commandHis.removeFirst();
        }
    }

    public String get(int index) {
        if (index > this.m_commandHis.size() - 1 || index < 0) {
            return "";
        }
        String command = (String)this.m_commandHis.remove(index);
        this.add(command);
        return command;
    }

    public String[] getHistory() {
        return this.m_commandHis.toArray(new String[0]);
    }

    public void printHistory() {
        for (int i = 0; i < this.m_commandHis.size(); ++i) {
            String command = (String)this.m_commandHis.get(i);
            System.out.println(CommandHistory.parse(i, 3) + SEPARATOR + CommandHistory.replaceLF(command, 3));
        }
    }

    public static String parse(int val, int offset) {
        StringBuffer buf = NumberFormat.getNumberInstance().format(val, new StringBuffer(), pos);
        StringBuffer disp = new StringBuffer();
        for (int i = 0; i < offset - pos.getEndIndex(); ++i) {
            disp.append(' ');
        }
        disp.append(buf.toString());
        return disp.toString();
    }

    public static String replaceLF(String command, int offset) {
        char[] fill = new char[offset + SEPARATOR.length()];
        Arrays.fill(fill, ' ');
        String LF_OFFSET = new String("\n" + String.valueOf(fill));
        return command.replaceAll("\n", LF_OFFSET);
    }
}

