/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.ConfigAction;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class ConfigActions {
    private static final String CFGNAME_OPTION_NAME = "cfgname";
    private static final String DESCRIPTION_OPTION_NAME = "descript";
    private static final String REFRESH_OPTION_NAME = "refresh";
    private static final String RETRYCOUNT_OPTION_NAME = "retry";
    private static final String DETECTTIMEOUT_OPTION_NAME = "timeout";
    private static final String DISTRIBUTION_OPTION_NAME = "dist";
    private static final String PARTMODE_OPTION_NAME = "pmode";
    private static final String SYNCMODE_OPTION_NAME = "smode";
    private static final String PARTMODE_PART = "0";
    private static final String PARTMODE_NOPART = "1";
    private static final String SYNCMODE_SYNC = "1";
    private static final String SYNCMODE_NOSYNC = "0";

    public void create(CommandParser cp, GSCdata gsc) {
        String cfgName = (String)cp.getConfigName().get(0);
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigId(cfgName);
        if (gsc == null) {
            return;
        }
        ConfigAction addConfig = new ConfigAction(gsc);
        try {
            if (addConfig.add(configInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.config.create", new Object[]{cfgName}));
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println(MessagesCommandLine.getString("cui.error.config.create", new Object[]{cfgName}));
    }

    public void drop(CommandParser cp, GSCdata gsc) {
        String id = (String)cp.getConfigName().get(0);
        if (id.equals("FOREST_DEFAULT_CONFIG")) {
            System.err.println(MessagesCommandLine.getString("errors.gsc.config.del.default"));
            return;
        }
        if (id != "") {
            ConfigAction configAction = new ConfigAction(gsc);
            try {
                if (configAction.del(id)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.config.drop", new Object[]{id}));
                    return;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.config.drop", new Object[]{id}));
    }

    public void set(CommandParser cp, GSCdata gsc) {
        String id = (String)cp.getConfigName().get(0);
        ConfigAction configAction = new ConfigAction(gsc);
        ConfigInfo configInfo = null;
        try {
            configInfo = configAction.get(id);
        }
        catch (Exception e1) {
            System.out.println(MessagesCommandLine.getString("cui.error.config.set", new Object[]{id}));
            e1.printStackTrace();
            return;
        }
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.compareToIgnoreCase(CFGNAME_OPTION_NAME) == 0) {
                String cfgName = (String)paramValues.get(i);
                configInfo.setConfigId(cfgName);
                continue;
            }
            if (paramName.compareToIgnoreCase(DESCRIPTION_OPTION_NAME) == 0) {
                String descript = (String)paramValues.get(i);
                configInfo.setDescription(descript);
                continue;
            }
            if (paramName.compareToIgnoreCase(REFRESH_OPTION_NAME) == 0) {
                long refresh = Long.parseLong((String)paramValues.get(i));
                configInfo.setCacheReflesh(refresh);
                continue;
            }
            if (paramName.compareToIgnoreCase(RETRYCOUNT_OPTION_NAME) == 0) {
                long retry = Long.parseLong((String)paramValues.get(i));
                configInfo.setRetryCount(retry);
                continue;
            }
            if (paramName.compareToIgnoreCase(DETECTTIMEOUT_OPTION_NAME) == 0) {
                long timeout = Long.parseLong((String)paramValues.get(i));
                configInfo.setDefectTimeout(timeout);
                continue;
            }
            if (paramName.compareToIgnoreCase(DISTRIBUTION_OPTION_NAME) == 0) {
                int dist = Integer.parseInt((String)paramValues.get(i));
                configInfo.setDistributedCon(dist);
                continue;
            }
            if (paramName.compareToIgnoreCase(PARTMODE_OPTION_NAME) == 0) {
                String pmode = (String)paramValues.get(i);
                boolean isNoPart = false;
                if (pmode.equals("1")) {
                    isNoPart = true;
                }
                configInfo.setPertitionMode(isNoPart);
                continue;
            }
            if (paramName.compareToIgnoreCase(SYNCMODE_OPTION_NAME) == 0) {
                String smode = (String)paramValues.get(i);
                boolean isSync = false;
                if (smode.equals("1")) {
                    isSync = true;
                }
                configInfo.setSyncMode(isSync);
                continue;
            }
            System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        try {
            if (configAction.mod(id, configInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.config.set", new Object[]{id}));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(MessagesCommandLine.getString("cui.error.config.set", new Object[]{id}));
    }

    public void replicate(CommandParser cp, GSCdata gsc) {
        String srcCfgName = (String)cp.getConfigName().get(0);
        String destCfgName = (String)cp.getConfigName().get(1);
        ConfigAction configAction = new ConfigAction(gsc);
        ConfigInfo configInfo = null;
        try {
            configInfo = configAction.get(srcCfgName);
        }
        catch (Exception e1) {
            System.out.println(MessagesCommandLine.getString("cui.error.config.copy", new Object[]{srcCfgName, destCfgName}));
            e1.printStackTrace();
            return;
        }
        configInfo.setConfigId(destCfgName);
        if (gsc == null) {
            return;
        }
        ConfigAction addConfig = new ConfigAction(gsc);
        try {
            if (addConfig.add(configInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.config.copy", new Object[]{srcCfgName, destCfgName}));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(MessagesCommandLine.getString("cui.error.config.copy", new Object[]{srcCfgName, destCfgName}));
    }

    public void show(GSCdata gsc) {
        ArrayList configList = null;
        ConfigAction configAction = new ConfigAction(gsc);
        try {
            configList = configAction.getList();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.config.show"));
            e.printStackTrace();
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.config.show"));
        Iterator it = configList.iterator();
        System.out.println(" CONFIG \t| DESCRIPTION \t| CACHE_REFRESH \t| RETRY_COUNT \t| DETECT_TIMEOUT \t| DISTRIBUTED_CONNECTION \t| PARTITION_MODE \t| SYNCRONIZE_MODE");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            ConfigInfo configInfo = (ConfigInfo)it.next();
            try {
                ConfigInfo configInfoDtl = configAction.get(configInfo.getConfigId());
                System.out.print(configInfoDtl.getConfigId() + "\t| ");
                System.out.print(configInfoDtl.getDescription() + "\t| ");
                System.out.print(configInfoDtl.getCacheReflesh() + "\t| ");
                System.out.print(configInfoDtl.getRetryCount() + "\t| ");
                System.out.print(configInfoDtl.getDefectTimeout() + "\t| ");
                System.out.print(this.convertDist(configInfoDtl.getDistributedCon()) + "\t| ");
                System.out.print(this.convertMode(configInfoDtl.isPertitionMode()) + "\t| ");
                System.out.println(this.convertMode(configInfoDtl.isSyncMode()));
            }
            catch (Exception e) {
                System.out.println(MessagesCommandLine.getString("cui.error.config.show"));
                e.printStackTrace();
                return;
            }
        }
    }

    private String convertDist(int dist) {
        String ret = "";
        if (dist == 0) {
            ret = MessagesCommandLine.getString("form.config.distribution.roundrobin");
        } else if (dist == 1) {
            ret = MessagesCommandLine.getString("form.config.distribution.fix");
        }
        return ret;
    }

    private String convertMode(boolean status) {
        String ret = "";
        if (status) {
            ret = MessagesCommandLine.getString("yes");
        } else if (!status) {
            ret = MessagesCommandLine.getString("no");
        }
        return ret;
    }
}

