/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.DbAction;
import org.postgresforest.tool.action.DbInstanceAction;
import org.postgresforest.tool.action.ExecDdl;
import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class DbActions {
    public void create(CommandParser cp, GSCdata gsc) {
        AddDbInfo addDbInfo;
        String dbName = (String)cp.getDB().get(0);
        String option = "";
        Iterator it = cp.getOption().iterator();
        while (it.hasNext()) {
            option = option + (String)it.next();
        }
        ArrayList chkServerList = cp.getServer();
        String serverListStr = "";
        int chksize = chkServerList.size();
        for (int i = 0; i < chksize - 1; ++i) {
            serverListStr = serverListStr + (String)chkServerList.get(i) + ",";
        }
        serverListStr = serverListStr + chkServerList.get(chksize - 1);
        DbInstanceAction dbInstance = new DbInstanceAction(gsc);
        try {
            addDbInfo = dbInstance.getAddDbInfo();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.db.create", new Object[]{dbName, serverListStr}));
            System.err.println(e);
            return;
        }
        ArrayList serverList = addDbInfo.getServer();
        Iterator it2 = serverList.iterator();
        while (it2.hasNext()) {
            ServerInfo srvInfo = (ServerInfo)it2.next();
            srvInfo.setChkFlag(false);
            int id = srvInfo.getId();
            Iterator it3 = chkServerList.iterator();
            while (it3.hasNext()) {
                int chkServerId = Integer.parseInt((String)it3.next());
                if (id != chkServerId) continue;
                srvInfo.setChkFlag(true);
            }
        }
        addDbInfo.setDb(dbName);
        addDbInfo.setOption(option);
        addDbInfo.setMakeMode(0);
        addDbInfo.setServer(serverList);
        DbAction addDb = new DbAction(gsc);
        if (addDb.add(addDbInfo)) {
            System.out.println(MessagesCommandLine.getString("cui.message.db.create", new Object[]{dbName, serverListStr}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.db.create", new Object[]{dbName, serverListStr}));
    }

    public void drop(CommandParser cp, GSCdata gsc) {
        String dbName = (String)cp.getDB().get(0);
        if (dbName != "") {
            ArrayList dbLinkList = this.getDbLinkList(gsc);
            ArrayList dbServer = null;
            Iterator iter = dbLinkList.iterator();
            while (iter.hasNext()) {
                DbLinkInfo dbInfo = (DbLinkInfo)iter.next();
                if (dbName.compareTo(dbInfo.getName()) != 0) continue;
                dbServer = dbInfo.getServer();
                break;
            }
            iter = dbServer.iterator();
            while (iter.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)iter.next();
                serverInfo.setChkFlag(true);
            }
            DbAction dbAction = new DbAction(gsc);
            try {
                if (dbAction.del(dbLinkList)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.db.drop", new Object[]{dbName}));
                    return;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.db.drop", new Object[]{dbName}));
    }

    public void restore(CommandParser cp, GSCdata gsc) {
        AddDbInfo addDbInfo;
        String dbName = (String)cp.getDB().get(0);
        ArrayList chkServerList = cp.getServer();
        String serverListStr = "";
        int chksize = chkServerList.size();
        for (int i = 0; i < chksize - 1; ++i) {
            serverListStr = serverListStr + (String)chkServerList.get(i) + ",";
        }
        serverListStr = serverListStr + chkServerList.get(chksize - 1);
        DbInstanceAction dbInstance = new DbInstanceAction(gsc);
        try {
            addDbInfo = dbInstance.getAddDbInfo();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.db.restore", new Object[]{dbName, serverListStr}));
            System.err.println(e);
            return;
        }
        ArrayList dumpFileList = cp.getDumpFile();
        String option = "";
        Iterator it = cp.getOption().iterator();
        while (it.hasNext()) {
            option = option + (String)it.next();
        }
        ArrayList serverList = addDbInfo.getServer();
        Iterator it4 = serverList.iterator();
        while (it4.hasNext()) {
            ServerDumpDataInfo srvInfo = (ServerDumpDataInfo)it4.next();
            int id = srvInfo.getId();
            srvInfo.setChkFlag(false);
            Iterator it2 = chkServerList.iterator();
            Iterator it3 = dumpFileList.iterator();
            while (it2.hasNext()) {
                int chkServerId = Integer.parseInt((String)it2.next());
                String dumpFile = (String)it3.next();
                if (id != chkServerId) continue;
                srvInfo.setChkFlag(true);
                srvInfo.setDumpData(dumpFile);
            }
        }
        addDbInfo.setDb(dbName);
        addDbInfo.setOption(option);
        addDbInfo.setMakeMode(2);
        addDbInfo.setServer(serverList);
        this.validateDumpFile(addDbInfo);
        DbAction addDb = new DbAction(gsc);
        if (addDb.add(addDbInfo)) {
            System.out.println(MessagesCommandLine.getString("cui.message.db.restore", new Object[]{dbName, serverListStr}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.db.restore", new Object[]{dbName, serverListStr}));
    }

    public void show(GSCdata gsc) {
        ArrayList dbList = this.getDbLinkList(gsc);
        System.out.println(MessagesCommandLine.getString("cui.message.db.show"));
        Iterator it = dbList.iterator();
        System.out.println(" DBNAME \t| SERVERID \t| HOST \t| PORT ");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            DbLinkInfo dbLinkInfo = (DbLinkInfo)it.next();
            Iterator it2 = dbLinkInfo.getServer().iterator();
            while (it2.hasNext()) {
                ServerInfo srvInfo = (ServerInfo)it2.next();
                System.out.print(dbLinkInfo.getName() + "\t| ");
                System.out.print(srvInfo.getId() + "\t| ");
                System.out.print(srvInfo.getHost() + "\t| ");
                System.out.println(srvInfo.getPort());
            }
        }
    }

    public void createDbInstance(CommandParser cp, GSCdata gsc) {
        int chkServerId;
        AddDbInfo addDbInfo;
        String dbName = (String)cp.getDB().get(0);
        ArrayList dumpFileList = cp.getDumpFile();
        String option = "";
        Iterator it = cp.getOption().iterator();
        while (it.hasNext()) {
            option = option + (String)it.next();
        }
        ArrayList dbList = this.getDbLinkList(gsc);
        Iterator itdb = dbList.iterator();
        boolean isDbExist = false;
        while (itdb.hasNext()) {
            DbLinkInfo dbLinkInfo = (DbLinkInfo)itdb.next();
            if (!dbName.equals(dbLinkInfo.getName())) continue;
            isDbExist = true;
        }
        if (!isDbExist) {
            System.out.println(MessagesCommandLine.getString("cui.error.db.open.nosuchdb", new Object[]{dbName}));
            return;
        }
        ArrayList chkServerList = cp.getServer();
        String serverListStr = "";
        int chksize = chkServerList.size();
        for (int i = 0; i < chksize - 1; ++i) {
            serverListStr = serverListStr + (String)chkServerList.get(i) + ",";
        }
        serverListStr = serverListStr + chkServerList.get(chksize - 1);
        DbInstanceAction dbInstance = new DbInstanceAction(gsc);
        try {
            addDbInfo = dbInstance.getAddDbInfo();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.db.instance.add", new Object[]{dbName, serverListStr}));
            System.err.println(e);
            return;
        }
        ArrayList existServerList = this.getExistServerList(gsc, dbName);
        ArrayList serverList = addDbInfo.getServer();
        Iterator iter2 = existServerList.iterator();
        block5: while (iter2.hasNext()) {
            ServerInfo existServerInfo = (ServerInfo)iter2.next();
            Iterator iter = serverList.iterator();
            while (iter.hasNext()) {
                ServerInfo severInfo = (ServerInfo)iter.next();
                if (severInfo.getId() != existServerInfo.getId()) continue;
                serverList.remove(severInfo);
                continue block5;
            }
        }
        Iterator it4 = serverList.iterator();
        while (it4.hasNext()) {
            ServerDumpDataInfo srvInfo = (ServerDumpDataInfo)it4.next();
            int id = srvInfo.getId();
            srvInfo.setChkFlag(false);
            Iterator it2 = chkServerList.iterator();
            Iterator it3 = dumpFileList.iterator();
            while (it2.hasNext()) {
                chkServerId = Integer.parseInt((String)it2.next());
                String dumpFile = (String)it3.next();
                if (id != chkServerId) continue;
                srvInfo.setChkFlag(true);
                srvInfo.setDumpData(dumpFile);
            }
        }
        String existServerListStr = "";
        int servsize = serverList.size();
        for (int i = 0; i < servsize - 1; ++i) {
            existServerListStr = existServerListStr + Integer.toString(((ServerDumpDataInfo)serverList.get(i)).getId()) + ",";
        }
        if (servsize == 0) {
            System.out.println(MessagesCommandLine.getString("cui.error.db.instance.invalid.noaddinstance", new Object[]{dbName}));
            return;
        }
        existServerListStr = existServerListStr + Integer.toString(((ServerDumpDataInfo)serverList.get(servsize - 1)).getId());
        Iterator it5 = chkServerList.iterator();
        while (it5.hasNext()) {
            boolean existFlag = false;
            chkServerId = Integer.parseInt((String)it5.next());
            Iterator it6 = serverList.iterator();
            while (it6.hasNext()) {
                ServerDumpDataInfo srvInfo = (ServerDumpDataInfo)it6.next();
                int id = srvInfo.getId();
                if (id != chkServerId) continue;
                existFlag = true;
            }
            if (existFlag) continue;
            System.out.println(MessagesCommandLine.getString("cui.error.db.instance.invalid", new Object[]{existServerListStr}));
            return;
        }
        this.validateDumpFile(addDbInfo);
        addDbInfo.setDb(dbName);
        addDbInfo.setOption(option);
        addDbInfo.setMakeMode(1);
        addDbInfo.setServer(serverList);
        DbAction addDb = new DbAction(gsc);
        if (addDb.add(addDbInfo)) {
            System.out.println(MessagesCommandLine.getString("cui.message.db.instance.add", new Object[]{dbName, serverListStr}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.db.instance.add", new Object[]{dbName, serverListStr}));
    }

    public void dropDbInstance(CommandParser cp, GSCdata gsc) {
        String dbName = (String)cp.getDB().get(0);
        int selectId = Integer.parseInt((String)cp.getServer().get(0));
        if (dbName != "" && selectId >= 0) {
            ArrayList dbLinkList = this.getDbLinkList(gsc);
            ArrayList dbServer = null;
            Iterator iter = dbLinkList.iterator();
            while (iter.hasNext()) {
                DbLinkInfo dbInfo = (DbLinkInfo)iter.next();
                if (dbName.compareTo(dbInfo.getName()) != 0) continue;
                dbServer = dbInfo.getServer();
                break;
            }
            iter = dbServer.iterator();
            while (iter.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)iter.next();
                if (serverInfo.getId() != selectId) continue;
                serverInfo.setChkFlag(true);
                break;
            }
            DbAction dbAction = new DbAction(gsc);
            try {
                if (dbAction.del(dbLinkList)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.db.instance.delete", new Object[]{dbName, Integer.toString(selectId)}));
                    return;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.db.instance.delete", new Object[]{dbName, Integer.toString(selectId)}));
    }

    public void executeDdl(GSCdata gsc, String command, String selectDb) {
        String dbName = null;
        if (selectDb == null) {
            System.err.print(MessagesCommandLine.getString("cui.message.db.notopen", new Object[]{dbName}));
            return;
        }
        dbName = selectDb;
        ExecDdl execDdl = new ExecDdl(gsc, dbName);
        try {
            if (execDdl.executeMain(command)) {
                System.out.println(MessagesCommandLine.getString("cui.message.db.ddl.execute", new Object[]{dbName}));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(MessagesCommandLine.getString("cui.error.db.ddl.execute", new Object[]{dbName}));
    }

    public boolean open(CommandParser cp, GSCdata gsc) {
        boolean ret = false;
        String dbName = (String)cp.getDB().get(0);
        ArrayList dbList = this.getDbLinkList(gsc);
        Iterator it = dbList.iterator();
        while (it.hasNext()) {
            DbLinkInfo dbLinkInfo = (DbLinkInfo)it.next();
            if (dbName.compareToIgnoreCase(dbLinkInfo.getName()) != 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private ArrayList getDbLinkList(GSCdata gsc) {
        ArrayList dbList = null;
        DbInstanceAction dbInstance = new DbInstanceAction(gsc);
        try {
            dbList = dbInstance.getDbLinkList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbList;
    }

    private ArrayList getExistServerList(GSCdata gsc, String dbName) {
        ArrayList serverList = null;
        ArrayList servDbList = this.getDbLinkList(gsc);
        Iterator it = servDbList.iterator();
        while (it.hasNext()) {
            DbLinkInfo dbLinkInfo = (DbLinkInfo)it.next();
            if (!dbName.equals(dbLinkInfo.getName())) continue;
            serverList = dbLinkInfo.getServer();
        }
        return serverList;
    }

    private boolean validateDumpFile(AddDbInfo m_addDb) {
        boolean isValid = false;
        ArrayList serverList = m_addDb.getServer();
        Iterator iter = serverList.iterator();
        while (iter.hasNext()) {
            ServerDumpDataInfo serverInfo = (ServerDumpDataInfo)iter.next();
            String dumpdata = serverInfo.getDumpData();
            boolean isChkServer = serverInfo.isChkFlag();
            if (!isChkServer || dumpdata != null && !dumpdata.equals("")) continue;
            System.out.println(MessagesCommandLine.getString("errors.dump.input"));
            return isValid;
        }
        isValid = true;
        return isValid;
    }
}

