/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.UserMngAction;
import org.postgresforest.tool.bean.UserInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class UserActions {
    private static final String PASS_OPTION_NAME = "pass";
    private static final String DBAUTH_OPTION_NAME = "dbauth";
    private static final String USRAUTH_OPTION_NAME = "usrauth";
    private static final String PASS_ENCRYPTED = "ENCRYPTED";
    private static final String PASS_UNENCRYPTED = "UNENCRYPTED";
    private static final String DBAUTH_CREATEDB = "CREATEDB";
    private static final String DBAUTH_NOCREATEDB = "NOCREATEDB";
    private static final String USRAUTH_CREATEUSR = "CREATEUSER";
    private static final String USRAUTH_NOCREATEUSR = "NOCREATEUSER";
    private static final String PARAM_OFF = "0";
    private static final String PARAM_ON = "1";

    public void create(CommandParser cp, GSCdata gsc) {
        String user = (String)cp.getUser().get(0);
        String password = (String)cp.getPass().get(0);
        String passwordOption = PASS_ENCRYPTED;
        String createDbOption = DBAUTH_CREATEDB;
        String createUserOption = USRAUTH_CREATEUSR;
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String parmValue;
            String paramName = (String)paramNames.get(i);
            if (paramName.compareToIgnoreCase(PASS_OPTION_NAME) == 0) {
                parmValue = (String)paramValues.get(i);
                if (parmValue.equals(PARAM_OFF)) {
                    passwordOption = PASS_UNENCRYPTED;
                    continue;
                }
                if (parmValue.equals(PARAM_ON)) {
                    passwordOption = PASS_ENCRYPTED;
                    continue;
                }
                System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
                return;
            }
            if (paramName.compareToIgnoreCase(DBAUTH_OPTION_NAME) == 0) {
                parmValue = (String)paramValues.get(i);
                if (parmValue.equals(PARAM_OFF)) {
                    createDbOption = DBAUTH_NOCREATEDB;
                    continue;
                }
                if (parmValue.equals(PARAM_ON)) {
                    createDbOption = DBAUTH_CREATEDB;
                    continue;
                }
                System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
                return;
            }
            if (paramName.compareToIgnoreCase(USRAUTH_OPTION_NAME) == 0) {
                parmValue = (String)paramValues.get(i);
                if (parmValue.equals(PARAM_OFF)) {
                    createUserOption = USRAUTH_NOCREATEUSR;
                    continue;
                }
                if (parmValue.equals(PARAM_ON)) {
                    createUserOption = USRAUTH_CREATEUSR;
                    continue;
                }
                System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
                return;
            }
            System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        UserMngAction addUser = new UserMngAction(gsc);
        try {
            boolean result = false;
            result = addUser.addUser(user, password, passwordOption, createDbOption, createUserOption);
            if (result) {
                System.out.println(MessagesCommandLine.getString("cui.message.user.create", new Object[]{user}));
                return;
            }
        }
        catch (Exception e1) {
            System.err.println(e1);
        }
        System.out.println(MessagesCommandLine.getString("cui.error.user.create", new Object[]{user}));
    }

    public void drop(CommandParser cp, GSCdata gsc) {
        String user = (String)cp.getUser().get(0);
        if (user != "") {
            UserMngAction userMng = new UserMngAction(gsc);
            try {
                if (userMng.delUser(user)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.user.drop", new Object[]{user}));
                    return;
                }
            }
            catch (Exception e1) {
                System.err.println(e1);
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.user.drop, new Object[] {user}"));
    }

    public void show(GSCdata gsc) {
        ArrayList list = null;
        UserMngAction userMng = new UserMngAction(gsc);
        try {
            list = userMng.getUserList();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.user.show"));
            e.printStackTrace();
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.user.show"));
        Iterator it = list.iterator();
        System.out.println(" USERNAME\t| ATTRIBUTE");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            UserInfo usrInfo = (UserInfo)it.next();
            System.out.print(usrInfo.getName() + "\t| ");
            System.out.println(usrInfo.getAttribute());
        }
    }
}

