/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.ResultSet;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.NotImplementedException;

public class Config {
    private GSCdata gsc = null;
    public static final String DEFAULT_CONFIG_NAME = "FOREST_DEFAULT_CONFIG";
    public static final int PARTMODE_PART = 0;
    public static final int PARTMODE_NOPART = 1;
    public static final int SYNCMODE_SYNC = 1;
    public static final int SYNCMODE_NOSYNC = 0;
    public static final int CONN_RR = 0;
    public static final int CONN_FIXED = 1;
    private String configId = "FOREST_DEFAULT_CONFIG";
    private String description = "Default Configuration";
    private int cacheRefresh = 30;
    private int retryCount = 3;
    private int defectTimeout = 30;
    private int distributedConnection = 1;
    private int partitionMode = 0;
    private int synchronizeMode = 1;

    public Config(GSCdata gsc, String configId) {
        this.gsc = gsc;
        this.configId = configId;
        try {
            String sql = "SELECT description,cache_reflesh,retry_count,defect_timeout,distributed_connection,pertition_mode,syncronize_mode,update_date FROM forest_config WHERE configid='" + configId + "'";
            ResultSet rs = gsc.executeQueryGSC(sql);
            if (rs.next()) {
                int j = 1;
                this.description = rs.getString(j++);
                this.cacheRefresh = rs.getInt(j++);
                this.retryCount = rs.getInt(j++);
                this.defectTimeout = rs.getInt(j++);
                this.distributedConnection = rs.getInt(j++);
                this.partitionMode = rs.getInt(j++);
                this.synchronizeMode = rs.getInt(j++);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public Config(GSCdata gsc, String configId, String desc, int cache_refresh, int retry_count, int defect_timeout, int distributed_connection, int partition_mode, int sync_mode) {
        this.gsc = gsc;
        this.configId = configId;
        this.description = desc;
        this.cacheRefresh = cache_refresh;
        this.retryCount = retry_count;
        this.defectTimeout = defect_timeout;
        this.distributedConnection = distributed_connection;
        this.partitionMode = partition_mode;
        this.synchronizeMode = sync_mode;
    }

    public String getId() {
        return this.configId;
    }

    public boolean setId(String configId) {
        String oldconfig = this.configId;
        this.configId = configId;
        return this.updateGSC("configid", configId, oldconfig);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean setDescription(String desc) {
        this.description = desc;
        return this.updateGSC("description", desc);
    }

    public int getCacheRefresh() {
        return this.cacheRefresh;
    }

    public boolean setCacheRefresh(int refresh) {
        this.cacheRefresh = refresh;
        return this.updateGSC("cache_reflesh", refresh);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean setRetryCount(int retry) {
        this.retryCount = retry;
        return this.updateGSC("retry_count", retry);
    }

    public int getDefectTimeout() {
        return this.defectTimeout;
    }

    public boolean setDefectTimeout(int timeout) {
        this.defectTimeout = timeout;
        return this.updateGSC("defect_timeout", timeout);
    }

    public int getDistributedConnection() {
        return this.distributedConnection;
    }

    public boolean setDistributedConnection(int dist) {
        this.distributedConnection = dist;
        return this.updateGSC("distributed_connection", dist);
    }

    public int getPartitionMode() {
        return this.partitionMode;
    }

    public boolean setPartitionMode(int mode) {
        this.partitionMode = mode;
        return this.updateGSC("pertition_mode", mode);
    }

    public int getSynchronizeMode() {
        return this.synchronizeMode;
    }

    public boolean setSynchronizeMode(int mode) {
        this.synchronizeMode = mode;
        return this.updateGSC("syncronize_mode", mode);
    }

    public Config clone2() throws NotImplementedException {
        throw new NotImplementedException();
    }

    public boolean equals(Config cmp) throws NotImplementedException {
        throw new NotImplementedException();
    }

    private boolean updateGSC(String param, int value) {
        return this.updateGSC(param, "" + value);
    }

    private boolean updateGSC(String param, String value) {
        return this.updateGSC(param, value, this.configId);
    }

    private boolean updateGSC(String param, String value, String configId) {
        try {
            this.gsc.executeUpdateGSC("UPDATE forest_config SET " + param + "='" + value + "',update_date=now() WHERE configid='" + configId + "'");
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        return true;
    }
}

