/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresforest.tool.ArrayUtil;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.PartitionUtils;
import org.postgresforest.tool.lib.SqlTokenizer;
import org.postgresforest.tool.lib.Table;

public class Database {
    private GSCdata gsc = null;
    private int[] instanceIds = null;
    private String dbName = null;

    public Database(GSCdata gsc, int[] instanceIds, String dbName) {
        this.gsc = gsc;
        this.instanceIds = instanceIds;
        this.dbName = dbName;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public int[] getDatabaseNumbers() {
        ResultSet rs = null;
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            rs = this.gsc.executeQueryGSC("SELECT dbno FROM forest_servdb WHERE dbname='" + this.dbName + "'");
            while (rs.next()) {
                a.add(new Integer(rs.getInt("dbno")));
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return ArrayUtil.array2intarray(a);
    }

    public Table createTable(String tableDef) throws ForestToolException {
        Instance ins = null;
        Connection con = null;
        String tableName = Database.parseTableName(tableDef);
        for (int i = 0; i < this.instanceIds.length; ++i) {
            ins = this.gsc.getInstance(this.instanceIds[i]);
            con = ins.getDatabaseConnection(this.dbName, this.gsc.getUser(), this.gsc.getPassword());
            try {
                Statement stmt = con.createStatement();
                int rc = stmt.executeUpdate(tableDef);
                stmt.close();
                con.close();
                continue;
            }
            catch (Exception e) {
                throw new ForestToolException(e);
            }
        }
        String sql = "INSERT INTO forest_tablepart(dbname,table_name,part_count,part_type,hash_name,status)  VALUES ('" + this.dbName + "','" + tableName + "', 1, 0,null,0);";
        int[] dbno = this.getDatabaseNumbers();
        for (int i = 0; i < dbno.length; ++i) {
            sql = sql + "INSERT INTO forest_tablepartdtl(dbno,dbname,table_name,part_no,priority) VALUES (" + "" + dbno[i] + "," + "'" + this.dbName + "'," + "'" + tableName + "'," + "0," + "0);";
        }
        this.gsc.executeUpdateGSC(sql);
        return this.getTable(tableName);
    }

    private boolean _dropView(int[] instanceIds, String viewName) {
        return this._dropObject(instanceIds, viewName, "VIEW");
    }

    private boolean _dropTable(int[] instanceIds, String tableName) {
        return this._dropObject(instanceIds, tableName, "TABLE");
    }

    private boolean _dropObject(int[] instanceIds, String tableName, String obj) {
        for (int i = 0; i < instanceIds.length; ++i) {
            Instance ins = this.gsc.getInstance(instanceIds[i]);
            try {
                Connection con = ins.getDatabaseConnection(this.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                con.createStatement().executeUpdate("DROP " + obj + " " + tableName);
                con.close();
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean dropTable(Table table) {
        return this.dropTable(table.getName());
    }

    public boolean dropTable(String tableName) {
        Table t = this.getTable(tableName);
        boolean rc = false;
        try {
            int[] instanceIds;
            if (t.getTableType() == 0) {
                instanceIds = t.getInstanceIds(0);
                rc = this._dropTable(instanceIds, tableName);
            } else {
                instanceIds = t.getInstanceIds();
                rc = this._dropView(instanceIds, tableName);
                for (int part = 0; part < t.getPartCount(); ++part) {
                    instanceIds = t.getInstanceIds(part);
                    String partName = PartitionUtils.buildPartitionName(tableName, part);
                    rc = this._dropTable(instanceIds, partName);
                }
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            rc = false;
        }
        if (!rc) {
            return false;
        }
        rc = false;
        try {
            String sql = "";
            if (t.getTableType() != 0) {
                sql = sql + "DELETE FROM forest_partatr WHERE dbname='" + this.dbName + "' AND table_name='" + tableName + "';";
            }
            sql = sql + "DELETE FROM forest_tablepartdtl WHERE dbname='" + this.dbName + "' AND table_name='" + tableName + "';";
            if (this.gsc.executeUpdateGSC(sql = sql + "DELETE FROM forest_tablepart WHERE dbname='" + this.dbName + "' AND table_name='" + tableName + "';") > 0) {
                rc = true;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return rc;
    }

    public int[] getInstanceIds() {
        return this.instanceIds;
    }

    public String[] getTableNames() throws ForestToolException {
        String sql = "SELECT table_name FROM forest_tablepart WHERE dbname='" + this.dbName + "' ORDER BY table_name";
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(rs.getString("table_name"));
            }
            rs.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public Table getTable(String tableName) {
        return new Table(this, tableName);
    }

    public static String parseTableName(String tableDef) {
        String token;
        SqlTokenizer t = new SqlTokenizer(tableDef);
        String tableName = null;
        while (t.hasMoreToken() && !(token = t.nextToken()).equals("(")) {
            if (t.ttype != 2) continue;
            tableName = token;
        }
        tableName = tableName.replaceAll("\"", "");
        tableName = tableName.replaceAll("public.", "");
        return tableName;
    }

    public static String[] parseColumnNames(String tableDef) {
        SqlTokenizer t = new SqlTokenizer(tableDef);
        String[] columnNames = null;
        ArrayList<String> a = new ArrayList<String>();
        while (t.hasMoreToken() && !t.nextToken().equals("(")) {
        }
        boolean comming = true;
        int nesting = 1;
        while (t.hasMoreToken()) {
            String token = t.nextToken();
            if (token.equals(",")) {
                comming = true;
            }
            if (comming && t.ttype == 2) {
                a.add(token);
                comming = false;
            }
            if (token.equals("(")) {
                ++nesting;
            }
            if (token.equals(")")) {
                --nesting;
            }
            if (nesting != 0) continue;
            break;
        }
        columnNames = new String[a.size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = (String)a.get(i);
        }
        return columnNames;
    }

    protected GSCdata getGSCdata() {
        return this.gsc;
    }

    public boolean validate(int flags) {
        Logger.debug("Validating database " + this.getDatabaseName() + "....");
        boolean rc = true;
        int[] ids = this.getInstanceIds();
        for (int i = 0; i < ids.length; ++i) {
            Instance instance = this.gsc.getInstance(ids[i]);
            try {
                Connection con = instance.getDatabaseConnection(this.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                con.close();
                continue;
            }
            catch (Exception e) {
                Logger.error(instance.toString() + ": " + e.getMessage());
                Logger.trace(e);
                rc = false;
            }
        }
        try {
            String[] tableNames = this.getTableNames();
            for (int j = 0; j < tableNames.length; ++j) {
                Table t = this.getTable(tableNames[j]);
                rc = t.validate(flags) && rc;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return rc;
    }

    public boolean addInstance(Instance instance, boolean force) {
        int dbno = -1;
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = null;
            rs = this.gsc.executeQueryGSC("SELECT max(dbno) FROM forest_servdb WHERE dbname='" + this.getDatabaseName() + "'");
            if (rs.next()) {
                dbno = rs.getInt(1);
            }
            rs.close();
            if (dbno < 0) {
                Logger.error("Cannot register " + instance.toString() + " as a new instance.");
                return false;
            }
            String sql = "SELECT table_name FROM forest_tablepart  WHERE dbname='" + this.getDatabaseName() + "' " + "   AND part_type=" + 0;
            rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(rs.getString(1));
            }
            rs.close();
            String newSql = "INSERT INTO forest_servdb (dbno,dbname,serverid) VALUES (" + (dbno + 1) + ",'" + this.getDatabaseName() + "'," + instance.getId() + ");\n";
            for (int i = 0; i < a.size(); ++i) {
                String t = (String)a.get(i);
                newSql = newSql + "INSERT INTO forest_tablepartdtl (dbno,dbname,table_name,part_no,priority) VALUES (" + (dbno + 1) + ",'" + this.getDatabaseName() + "','" + t + "',0,0);\n";
            }
            Logger.debug(newSql);
            int rc = this.gsc.executeUpdateGSC(newSql);
            if (rc == 0) {
                Logger.error("GSC has not been updated while adding an instance.");
                return false;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return true;
    }
}

