/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresforest.tool.ArrayUtil;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.PartitionUtils;
import org.postgresforest.tool.lib.TableUtils;

public class Table {
    private Database database = null;
    private String tableName = null;
    private GSCdata gsc = null;
    public static final int TYPE_REPLICATED = 0;
    public static final int TYPE_PARTITION_1 = 1;
    public static final int TYPE_PARTITION_2 = 2;

    public Table(Database database, String tableName) {
        this.database = database;
        this.tableName = tableName;
        this.gsc = database.getGSCdata();
    }

    public boolean part(String[] partKeys, int partCount, String hashName) throws ForestToolException {
        Connection con;
        int i;
        int i2;
        int i3;
        String def = null;
        String[] tmp = null;
        if (this.getTableType() == 1 || this.getTableType() == 2) {
            throw new ForestToolException("Table `" + this.tableName + "' is a partitioned table.");
        }
        if (this.getPrimaryKeys().length <= 0) {
            throw new ForestToolException("Table `" + this.tableName + "' does not have primary key(s).");
        }
        def = PartitionUtils.buildPartitionDefs(partCount, this.tableName, partKeys, hashName);
        def = def + "ALTER TABLE " + this.tableName + " RENAME TO _" + this.tableName + ";\n";
        tmp = PartitionUtils.buildConstraintDefs(partCount, this.tableName, this.getConstraintDefs());
        for (i3 = 0; i3 < tmp.length; ++i3) {
            def = def + tmp[i3] + "\n";
        }
        def = def + PartitionUtils.buildUnionAllViewDef(partCount, this.tableName);
        def = def + PartitionUtils.buildUpdateRuleDef(partCount, this.tableName, this.getPrimaryKeys(), this.getColumnNames());
        def = def + PartitionUtils.buildDeleteRuleDef(partCount, this.tableName, this.getPrimaryKeys());
        tmp = PartitionUtils.buildIndexDefs(partCount, this.tableName, this.getIndexDefs());
        for (i3 = 0; i3 < tmp.length; ++i3) {
            def = def + tmp[i3] + "\n";
        }
        Logger.debug(def);
        String gscSql = null;
        hashName = hashName == null ? "null" : "'" + hashName + "'";
        gscSql = "UPDATE forest_tablepart SET part_count=" + partCount + ",part_type=1,hash_name=" + hashName + " WHERE dbname='" + this.database.getDatabaseName() + "' " + "   AND table_name='" + this.tableName + "';";
        int[] dbno = this.database.getDatabaseNumbers();
        for (i2 = 0; i2 < dbno.length; ++i2) {
            int pri = i2;
            gscSql = gscSql + "DELETE FROM forest_tablepartdtl WHERE dbno=" + dbno[i2] + " AND " + "  dbname='" + this.database.getDatabaseName() + "' AND " + "  table_name='" + this.tableName + "' AND " + "  part_no=0;";
            for (int j = 0; j < partCount; ++j) {
                gscSql = gscSql + "INSERT INTO forest_tablepartdtl(dbno,dbname,table_name,part_no,priority) VALUES (" + "" + dbno[i2] + "," + "'" + this.database.getDatabaseName() + "'," + "'" + this.tableName + "'," + "" + j + "," + "" + pri + ");";
                if (++pri < dbno.length) continue;
                pri = 0;
            }
        }
        for (i2 = 0; i2 < partKeys.length; ++i2) {
            gscSql = gscSql + "INSERT INTO forest_partatr(dbname,table_name,column_name,column_no,column_type) VALUES (" + "'" + this.database.getDatabaseName() + "'," + "'" + this.tableName + "'," + "'" + partKeys[i2] + "'," + "" + this.getColumnNumber(partKeys[i2]) + "," + "'" + this.getColumnType(partKeys[i2]) + "');";
        }
        try {
            this.gsc.executeUpdateGSC(gscSql);
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        int[] instanceIds = this.getInstanceIds();
        for (i = 0; i < instanceIds.length; ++i) {
            Instance ins = this.gsc.getInstance(instanceIds[i]);
            con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            Logger.debug(ins.toString() + " : Attempting to part table " + this.tableName);
            try {
                con.setAutoCommit(false);
                con.createStatement().executeUpdate(def);
                con.commit();
                con.close();
                continue;
            }
            catch (Exception e) {
                throw new ForestToolException(e);
            }
        }
        instanceIds = this.getInstanceIds();
        for (i = 0; i < instanceIds.length; ++i) {
            Instance ins = this.gsc.getInstance(instanceIds[i]);
            con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            Logger.debug(ins.toString() + " : Attempting to part table " + this.tableName);
            try {
                con.setAutoCommit(false);
                con.createStatement().executeUpdate("DROP TABLE _" + this.tableName);
                con.commit();
                con.close();
                continue;
            }
            catch (Exception e) {
                throw new ForestToolException(e);
            }
        }
        return true;
    }

    public boolean unpart() throws ForestToolException {
        int i;
        String partName;
        int i2;
        if (this.getTableType() != 1) {
            throw new ForestToolException("This table is not a partition(1) table.");
        }
        int partCount = this.getPartCount();
        String gscSql = null;
        gscSql = "UPDATE forest_tablepart SET part_count=1,part_type=0,hash_name=null  WHERE dbname='" + this.database.getDatabaseName() + "' " + "   AND table_name='" + this.tableName + "';";
        int[] dbno = this.database.getDatabaseNumbers();
        for (int i3 = 0; i3 < dbno.length; ++i3) {
            for (int j = 0; j < partCount; ++j) {
                gscSql = gscSql + "DELETE FROM forest_tablepartdtl WHERE dbno=" + dbno[i3] + " AND " + "  dbname='" + this.database.getDatabaseName() + "' AND " + "  table_name='" + this.tableName + "' AND " + "  part_no=" + j + ";";
            }
            gscSql = gscSql + "INSERT INTO forest_tablepartdtl(dbno,dbname,table_name,part_no,priority) VALUES (" + "" + dbno[i3] + "," + "'" + this.database.getDatabaseName() + "'," + "'" + this.tableName + "'," + "0,0);";
        }
        gscSql = gscSql + "DELETE FROM forest_partatr " + " WHERE dbname='" + this.database.getDatabaseName() + "' " + "   AND table_name='" + this.tableName + "';";
        String def = "DROP VIEW " + this.tableName + ";\n";
        def = def + "CREATE TABLE " + this.tableName + " AS ";
        for (i2 = 0; i2 < partCount; ++i2) {
            partName = PartitionUtils.buildPartitionName(this.tableName, i2);
            if (i2 > 0) {
                def = def + " UNION ALL ";
            }
            def = def + "SELECT * FROM " + partName + " ";
        }
        def = def + ";";
        for (i2 = 0; i2 < partCount; ++i2) {
            partName = PartitionUtils.buildPartitionName(this.tableName, i2);
            def = def + "DROP TABLE " + partName + ";";
        }
        String partName2 = PartitionUtils.buildPartitionName(this.tableName, 0);
        String constDefs = "";
        String[] pkeys = this.getPrimaryKeys();
        Connection con = null;
        int[] instances = this.getInstanceIds();
        con = this.gsc.getInstance(instances[0]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
        String[] tmp = TableUtils.getIndexDefs(con, TableUtils.getSchemaName(partName2), TableUtils.getTableName(partName2), this.tableName);
        for (i = 0; i < tmp.length; ++i) {
            constDefs = constDefs + tmp[i];
        }
        tmp = TableUtils.getConstraintDefs(con, TableUtils.getSchemaName(partName2), TableUtils.getTableName(partName2), this.tableName);
        for (i = 0; i < tmp.length; ++i) {
            constDefs = constDefs + tmp[i];
        }
        Logger.debug("unpart: constraint, " + constDefs);
        def = def + constDefs;
        int[] instanceIds = this.getInstanceIds();
        for (int i4 = 0; i4 < instanceIds.length; ++i4) {
            Instance ins = this.gsc.getInstance(instanceIds[i4]);
            con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            Logger.debug(ins.toString() + " : Attempting to unpart table " + this.tableName);
            try {
                con.setAutoCommit(false);
                con.createStatement().executeUpdate(def);
                con.commit();
                con.close();
                continue;
            }
            catch (Exception e) {
                throw new ForestToolException(e);
            }
        }
        try {
            this.gsc.executeUpdateGSC(gscSql);
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        Logger.debug(def);
        return true;
    }

    public int[] getInstanceIds() throws ForestToolException {
        String sql = "SELECT s.serverid FROM forest_tablepart t, forest_servdb s  WHERE t.dbname=s.dbname AND t.table_name='" + this.tableName + "'";
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(new Integer(rs.getInt(1)));
            }
            rs.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2intarray(a);
    }

    public int[] getInstanceIds(int partId) {
        String sql = "SELECT s.serverid FROM forest_server s, forest_servdb d, forest_tablepartdtl t  WHERE s.serverid=d.serverid AND d.dbno=t.dbno AND t.table_name='" + this.tableName + "' " + "   AND part_no=" + partId + " AND d.dbname='" + this.database.getDatabaseName() + "'";
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(new Integer(rs.getInt(1)));
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
        return ArrayUtil.array2intarray(a);
    }

    public boolean copyPart(int partId, int srcId, int destId) {
        return false;
    }

    public boolean dropPart(int partId, int srcId) {
        String sql = "SELECT part_no FROM forest_servdb s, forest_tablepartdtl d  WHERE s.serverid=" + srcId + " AND d.dbno=s.dbno " + "   AND d.table_name='" + this.tableName + "' " + "   AND d.dbname='" + this.database.getDatabaseName() + "' AND d.part_no<>" + partId;
        int[] partNum = null;
        try {
            ArrayList<Integer> a = new ArrayList<Integer>();
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(new Integer(rs.getInt(1)));
            }
            partNum = ArrayUtil.array2intarray(a);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        try {
            Instance ins = this.gsc.getInstance(srcId);
            Connection con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            String def = "DROP VIEW " + this.tableName + ";\n";
            def = def + PartitionUtils.buildUnionAllViewDef(partNum, this.tableName);
            def = def + PartitionUtils.buildUpdateRuleDef(partNum, this.tableName, this.getPartitionKeys(), this.getColumnNames());
            def = def + PartitionUtils.buildDeleteRuleDef(partNum, this.tableName, this.getPartitionKeys());
            def = def + "DROP TABLE " + PartitionUtils.buildPartitionName(this.tableName, partId) + ";\n";
            Logger.debug(ins.toString() + " : Attempting to drop a partition on " + this.tableName);
            Logger.debug(def);
            con.setAutoCommit(false);
            con.createStatement().executeUpdate(def);
            con.commit();
            con.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        sql = "DELETE FROM forest_tablepartdtl  WHERE dbname='" + this.database.getDatabaseName() + "' " + "   AND table_name='" + this.tableName + "' " + "   AND part_no=" + partId + " " + "   AND dbno = ( SELECT dbno FROM forest_servdb " + " WHERE serverid=" + srcId + " " + " AND dbname='" + this.database.getDatabaseName() + "' );\n";
        sql = sql + "UPDATE forest_tablepart SET part_type=2 " + " WHERE dbname='" + this.database.getDatabaseName() + "' " + "   AND table_name='" + this.tableName + "';\n";
        try {
            int rc = this.gsc.executeUpdateGSC(sql);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return true;
    }

    public String[] getColumnNames() throws ForestToolException {
        String nspname = TableUtils.getSchemaName(this.tableName);
        String relname = TableUtils.getTableName(this.tableName);
        String sql = "SELECT attname from pg_class c, pg_attribute a, pg_namespace n  where n.nspname='" + nspname + "' " + "   and n.oid=c.relnamespace " + "   and c.relname='" + relname + "' " + "   and a.attrelid=c.oid " + "   and attnum>0 order by attnum";
        ArrayList<String> a = new ArrayList<String>();
        int[] instances = this.database.getInstanceIds();
        try {
            Connection con = null;
            con = this.gsc.getInstance(instances[0]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                a.add(rs.getString("attname"));
            }
            rs.close();
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    private String getColumnNumber(String colname) throws ForestToolException {
        return this.getColumnInfo(colname)[0];
    }

    public String getColumnType(String colname) throws ForestToolException {
        return this.getColumnInfo(colname)[1];
    }

    public String[] getColumnInfo(String colname) throws ForestToolException {
        String[] colinfo = new String[2];
        String nspname = TableUtils.getSchemaName(this.tableName);
        String relname = TableUtils.getTableName(this.tableName);
        String sql = "SELECT a.attnum as n, pg_catalog.format_type(a.atttypid, a.atttypmod) as t   FROM pg_namespace n, pg_attribute a, pg_class r  WHERE n.nspname='" + nspname + "' " + "   AND n.oid=r.relnamespace " + "   AND r.relname='" + relname + "' " + "   AND a.attrelid=r.oid " + "   AND a.attname='" + colname + "'";
        int[] instances = this.database.getInstanceIds();
        try {
            Connection con = null;
            con = this.gsc.getInstance(instances[0]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                colinfo[0] = rs.getString("n");
                colinfo[1] = rs.getString("t");
                Logger.debug("getColumnInfo: " + colinfo[0] + "," + colinfo[1]);
            }
            rs.close();
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        if (colinfo[1].equals("integer")) {
            colinfo[1] = "int4";
        } else if (colinfo[1].equals("smallint")) {
            colinfo[1] = "int2";
        } else if (colinfo[1].startsWith("character varying")) {
            colinfo[1] = "varchar";
        } else if (colinfo[1].startsWith("character")) {
            colinfo[1] = "bpchar";
        } else if (colinfo[1].equals("time without time zone")) {
            colinfo[1] = "time";
        } else if (colinfo[1].equals("timestamp without time zone")) {
            colinfo[1] = "timestamp";
        } else if (colinfo[1].equals("time with time zone")) {
            colinfo[1] = "timetz";
        } else if (colinfo[1].equals("timestamp with time zone")) {
            colinfo[1] = "timestamptz";
        }
        return colinfo;
    }

    public String[] getPrimaryKeys() throws ForestToolException {
        String nspname = null;
        String relname = null;
        Logger.debug("getPrimaryKeys: part_count=" + this.getPartCount());
        if (this.getPartCount() > 1) {
            nspname = TableUtils.getSchemaName(PartitionUtils.buildPartitionName(this.tableName, 0));
            relname = TableUtils.getTableName(PartitionUtils.buildPartitionName(this.tableName, 0));
        } else {
            nspname = TableUtils.getSchemaName(this.tableName);
            relname = TableUtils.getTableName(this.tableName);
        }
        String sql = "SELECT a.attname as pkey  FROM pg_attribute a, pg_index ii, pg_namespace n, pg_class r  WHERE n.nspname='" + nspname + "' " + "   AND r.relname='" + relname + "' " + "   AND n.oid=r.relnamespace " + "   AND a.attrelid=r.oid " + "   AND ii.indisprimary=true " + "   AND ii.indrelid=r.oid " + "   AND a.attnum = ANY(ii.indkey)";
        Logger.debug("getPrimaryKeys: " + sql);
        ArrayList<String> a = new ArrayList<String>();
        int[] instances = this.database.getInstanceIds();
        try {
            Connection con = null;
            con = this.gsc.getInstance(instances[0]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                a.add(rs.getString("pkey"));
            }
            rs.close();
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public boolean createIndex(String indexDef) {
        boolean rc = true;
        if (this.getTableType() == 0) {
            int[] instanceIds = null;
            try {
                instanceIds = this.getInstanceIds();
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
                Logger.trace(e);
                rc = false;
            }
            for (int i = 0; i < instanceIds.length; ++i) {
                Connection con = null;
                try {
                    con = this.gsc.getInstance(instanceIds[i]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                    con.createStatement().executeUpdate(indexDef);
                    con.close();
                    continue;
                }
                catch (Exception e) {
                    Logger.error(e.getMessage());
                    Logger.trace(e);
                    rc = false;
                }
            }
        } else {
            String[] indexDefs = new String[]{indexDef};
            String[] partIndexDefs = PartitionUtils.buildIndexDefs(this.getPartCount(), this.tableName, indexDefs);
            for (int p = 0; p < this.getPartCount(); ++p) {
                int[] instanceIds = null;
                try {
                    instanceIds = this.getInstanceIds(p);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage());
                    Logger.trace(e);
                    rc = false;
                }
                for (int i = 0; i < instanceIds.length; ++i) {
                    Connection con = null;
                    try {
                        con = this.gsc.getInstance(instanceIds[i]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                        con.createStatement().executeUpdate(partIndexDefs[p]);
                        con.close();
                        continue;
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        Logger.trace(e);
                        rc = false;
                    }
                }
            }
        }
        return rc;
    }

    private int[] getPartitionNums(int instanceId) {
        String sql = "SELECT part_no FROM forest_servdb s, forest_tablepartdtl d  WHERE s.dbno=d.dbno AND s.dbname=d.dbname    AND s.serverid=" + instanceId + " " + "   AND d.table_name='" + this.tableName + "' ORDER BY part_no";
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(new Integer(rs.getInt(1)));
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return null;
        }
        return ArrayUtil.array2intarray(a);
    }

    public boolean alter(String alterSql) {
        String newName = null;
        if (this.getPartCount() > 1) {
            int[] instanceIds = null;
            try {
                instanceIds = this.getInstanceIds();
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
                Logger.trace(e);
                return false;
            }
            for (int i = 0; i < instanceIds.length; ++i) {
                Instance ins = this.gsc.getInstance(instanceIds[i]);
                try {
                    Connection con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                    String[] alters = PartitionUtils.rewriteAlter(this.tableName, this.getPartCount(), this.getPartitionNums(instanceIds[i]), alterSql);
                    if (alters[0].startsWith("-- rename to ")) {
                        newName = alters[0].substring(13, alters[0].length() - 1);
                        Logger.debug("RENAME TO " + newName);
                    }
                    for (int j = 0; j < alters.length; ++j) {
                        int rc = con.createStatement().executeUpdate(alters[j]);
                    }
                    con.close();
                    continue;
                }
                catch (Exception e) {
                    Logger.error(e.getMessage());
                    Logger.trace(e);
                    return false;
                }
            }
            if (newName != null) {
                this.gsc.executeUpdateGSC("UPDATE forest_tablepart SET table_name='" + newName + "' WHERE table_name='" + this.tableName + "';" + "UPDATE forest_tablepartdtl SET table_name='" + newName + "' WHERE table_name='" + this.tableName + "';" + "UPDATE forest_partatr SET table_name='" + newName + "' WHERE table_name='" + this.tableName + "'");
            }
        } else {
            int[] instanceIds = null;
            try {
                instanceIds = this.getInstanceIds();
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
                Logger.trace(e);
                return false;
            }
            for (int i = 0; i < instanceIds.length; ++i) {
                Instance ins = this.gsc.getInstance(instanceIds[i]);
                try {
                    Connection con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                    int rc = con.createStatement().executeUpdate(alterSql);
                    con.close();
                    continue;
                }
                catch (Exception e) {
                    Logger.error(e.getMessage());
                    Logger.trace(e);
                }
            }
        }
        return true;
    }

    public String[] getConstraintDefs() throws ForestToolException {
        int[] instances = this.database.getInstanceIds();
        String[] defs = null;
        try {
            Connection con = null;
            con = this.gsc.getInstance(instances[0]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            defs = TableUtils.getConstraintDefs(con, TableUtils.getSchemaName(this.tableName), TableUtils.getTableName(this.tableName));
            con.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return defs;
    }

    public String[] getIndexDefs() throws ForestToolException {
        int[] instances = this.database.getInstanceIds();
        String[] defs = null;
        try {
            Connection con = null;
            con = this.gsc.getInstance(instances[0]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            defs = TableUtils.getIndexDefs(con, TableUtils.getSchemaName(this.tableName), TableUtils.getTableName(this.tableName));
            con.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return defs;
    }

    public int getPartCount() {
        return Integer.parseInt(this.getTableParam("part_count"));
    }

    public int getTableType() {
        return Integer.parseInt(this.getTableParam("part_type"));
    }

    private String getTableParam(String column) {
        String val = null;
        try {
            ResultSet rs = null;
            String sql = "SELECT " + column + " FROM forest_tablepart " + " WHERE table_name='" + this.tableName + "'" + "   AND dbname='" + this.database.getDatabaseName() + "'";
            rs = this.gsc.executeQueryGSC(sql);
            if (rs.next()) {
                val = rs.getString(1);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return val;
    }

    public String[] getPartitionKeys() {
        String sql = "SELECT column_name FROM forest_partatr  WHERE dbname='" + this.database.getDatabaseName() + "' " + "   AND table_name ='" + this.tableName + "' ORDER BY column_no";
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
        return ArrayUtil.array2stringarray(a);
    }

    public boolean dropIndex(String index) {
        boolean rc = true;
        if (this.getTableType() == 0) {
            int[] instanceIds = null;
            try {
                instanceIds = this.getInstanceIds();
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
                Logger.trace(e);
                rc = false;
            }
            for (int i = 0; i < instanceIds.length; ++i) {
                Connection con = null;
                try {
                    con = this.gsc.getInstance(instanceIds[i]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                    con.createStatement().executeUpdate("DROP INDEX " + index);
                    con.close();
                    continue;
                }
                catch (Exception e) {
                    Logger.error(e.getMessage());
                    Logger.trace(e);
                    rc = false;
                }
            }
        } else {
            for (int p = 0; p < this.getPartCount(); ++p) {
                int[] instanceIds = null;
                try {
                    instanceIds = this.getInstanceIds(p);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage());
                    Logger.trace(e);
                    rc = false;
                }
                for (int i = 0; i < instanceIds.length; ++i) {
                    Connection con = null;
                    try {
                        con = this.gsc.getInstance(instanceIds[i]).getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                        String idx = PartitionUtils.buildPartitionName(index, p);
                        con.createStatement().executeUpdate("DROP INDEX " + idx);
                        con.close();
                        continue;
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        Logger.trace(e);
                        rc = false;
                    }
                }
            }
        }
        return rc;
    }

    public String getHashName() {
        return this.getTableParam("hash_name");
    }

    public int getStatus() {
        return Integer.parseInt(this.getTableParam("status"));
    }

    public String getName() {
        return this.tableName;
    }

    public String[] getIndexNames() {
        int[] instanceids = this.getInstanceIds(0);
        Instance ins = this.gsc.getInstance(instanceids[0]);
        ArrayList<String> a = new ArrayList<String>();
        try {
            String t = this.tableName;
            if (this.getPartCount() > 1) {
                t = PartitionUtils.buildPartitionName(this.tableName, 0);
            }
            String n = TableUtils.getSchemaName(this.tableName);
            Connection con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
            String sql = "SELECT i.relname FROM pg_namespace n, pg_class r, pg_class i, pg_index ii  WHERE n.nspname='" + n + "' AND n.oid=r.relnamespace AND r.relname='" + t + "' " + "   AND r.oid=ii.indrelid AND ii.indexrelid=i.oid AND ii.indisprimary=false";
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String ind = rs.getString(1);
                Logger.debug("index: " + ind);
                if (this.getPartCount() > 1) {
                    a.add(ind.substring(0, ind.length() - 3));
                    continue;
                }
                a.add(ind);
            }
            rs.close();
            con.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return null;
        }
        return ArrayUtil.array2stringarray(a);
    }

    private boolean validateSchema() {
        boolean rc = true;
        try {
            int[] instanceIds = this.getInstanceIds();
            String selectList = "*";
            if (this.getPartCount() >= 2) {
                String[] pkeys = this.getPartitionKeys();
                for (int i = 0; i < pkeys.length; ++i) {
                    selectList = i == 0 ? "" : selectList + ",";
                    selectList = selectList + pkeys[i];
                }
            }
            for (int i = 0; i < instanceIds.length; ++i) {
                Instance ins = this.gsc.getInstance(instanceIds[i]);
                Connection con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                ResultSet rs = con.createStatement().executeQuery("SELECT " + selectList + " FROM " + this.tableName + " LIMIT 0");
                rc = true;
                con.close();
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            rc = false;
        }
        return rc;
    }

    private boolean validateCount() {
        int count = -1;
        boolean result = true;
        try {
            int[] instanceIds = this.getInstanceIds();
            for (int i = 0; i < instanceIds.length; ++i) {
                Instance ins = this.gsc.getInstance(instanceIds[i]);
                Connection con = ins.getDatabaseConnection(this.database.getDatabaseName(), this.gsc.getUser(), this.gsc.getPassword());
                ResultSet rs = con.createStatement().executeQuery("SELECT count(*) FROM " + this.tableName);
                if (rs.next()) {
                    int c = rs.getInt(1);
                    Logger.debug("validateCount(): " + ins.toString());
                    Logger.debug("validateCount(): record count, " + this.tableName + " = " + c);
                    if (i > 0 && c != count) {
                        Logger.error("Record count is different between instance " + instanceIds[i - 1] + "(" + count + ") and " + instanceIds[i] + "(" + c + ").");
                        result = false;
                    }
                    count = c;
                }
                con.close();
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return result;
    }

    public boolean validate(int flags) {
        Logger.debug("Validating table " + this.tableName + "....");
        boolean rc = true;
        if ((flags & 1) != 0) {
            boolean bl = rc = rc && this.validateSchema();
        }
        if ((flags & 2) != 0) {
            boolean bl = rc = rc && this.validateCount();
        }
        if ((flags & 4) != 0) {
            rc = false;
        }
        return rc;
    }

    public int getPriority(int instanceId, int partitionNo) {
        int priority = -1;
        try {
            String sql = "SELECT priority FROM forest_servdb s, forest_tablepartdtl t WHERE s.serverid=" + instanceId + " " + "   AND s.dbno=t.dbno " + "   AND s.dbname=t.dbname " + "   AND t.dbname='" + this.database.getDatabaseName() + "' " + "   AND t.table_name='" + this.tableName + "'" + "   AND t.part_no=" + partitionNo;
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            if (rs.next()) {
                priority = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return priority;
    }

    public boolean setPriority(int instanceId, int partitionNo, int priority) {
        boolean result = false;
        try {
            String sql = "UPDATE forest_tablepartdtl SET priority=" + priority + " WHERE dbname='" + this.database.getDatabaseName() + "'" + "   AND table_name='" + this.tableName + "'" + "   AND part_no=" + partitionNo + "   AND dbno=(SELECT dbno FROM forest_servdb " + "              WHERE dbname='" + this.database.getDatabaseName() + "' " + "                AND serverid=" + instanceId + ")";
            int rc = this.gsc.executeUpdateGSC(sql);
            if (rc > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return result;
    }
}

