/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresforest.tool.ArrayUtil;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;

public class TableUtils {
    public static String[] getConstraintDefs(Connection con, String schema, String relname) throws ForestToolException {
        return TableUtils.getConstraintDefs(con, schema, relname, relname);
    }

    public static String[] getConstraintDefs(Connection con, String schema, String relname, String newrel) throws ForestToolException {
        String sql = "SELECT c.conname, pg_get_constraintdef(c.oid) as condef   FROM pg_constraint c, pg_class r, pg_namespace n  WHERE c.conrelid=r.oid    AND r.relname='" + relname + "' " + "   AND r.relnamespace=n.oid " + "   AND n.nspname='" + schema + "' " + " ORDER BY conname";
        ArrayList<String> a = new ArrayList<String>();
        try {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String conname = rs.getString("conname");
                String condef = rs.getString("condef");
                String def = null;
                def = "ALTER TABLE " + schema + "." + newrel + " ADD CONSTRAINT " + conname + " " + condef + ";";
                a.add(def);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public static String[] getIndexDefs(Connection con, String schema, String relname) throws ForestToolException {
        return TableUtils.getIndexDefs(con, schema, relname, relname);
    }

    public static String[] getIndexDefs(Connection con, String schema, String relname, String newrel) throws ForestToolException {
        String sql = "SELECT pg_get_indexdef(r2.oid) as indexdef, r2.relname as indexname   FROM pg_namespace n, pg_class r, pg_class r2, pg_index i  WHERE n.nspname='" + schema + "' " + "   AND n.oid=r.relnamespace " + "   AND r.relname='" + relname + "' " + "   AND r.oid=i.indrelid " + "   AND i.indexrelid=r2.oid" + "   AND i.indisprimary=false";
        ArrayList<String> a = new ArrayList<String>();
        try {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String def = rs.getString("indexdef") + ";";
                String name = rs.getString("indexname");
                Logger.debug("getIndexDefs: " + name + "=" + def);
                def = def.replaceAll(" ON " + relname, " ON " + newrel);
                a.add(def);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public static String getSchemaName(String tableName) {
        if (tableName.indexOf(46) > 0) {
            return tableName.substring(0, tableName.indexOf(46));
        }
        return "public";
    }

    public static String getTableName(String tableName) {
        if (tableName.indexOf(46) > 0) {
            return tableName.substring(tableName.indexOf(46) + 1);
        }
        return tableName;
    }
}

