#!/bin/sh

. ./env.conf
. ./common.conf

function make_directory()
{
    echo -n "Creating ${d} ";
	for d in ${DESTDIR} ${DESTDIR}/bin ${DESTDIR}/lib ${DESTDIR}/share ${DESTDIR}/src;
      do mkdir -p ${d};
	     echo -n "${d} ";
    done;
	echo "done.";
}

function install_files()
{
	install -m 644 ./env.conf ${DESTDIR}/bin
	install -m 644 ./common.conf ${DESTDIR}/bin

	install -m 755 build/forest_ctl ${DESTDIR}/bin
	install -m 755 build/forest_initdb ${DESTDIR}/bin

	install -m 644 share/postgresql-8.1-407.jdbc3.jar ${DESTDIR}/share

    ## ---------------------------------------------------
    ## Install the template database stuffs and functions
    ## ---------------------------------------------------
	install -m 644 share/forest_init.sql ${DESTDIR}/share;
	install -m 644 share/forest_plpgsql_funcs.sql ${DESTDIR}/share;
	install -m 644 share/forest_pljava_init.sql ${DESTDIR}/share;
	install -m 644 share/forest_pljava_funcs.sql ${DESTDIR}/share;

    ## -----------------------------------
    ## Install PL/Java and functions
    ## -----------------------------------
	install_pljava;

#	install -m 644 lib/RePartition.jar ${DESTDIR}/lib;
#	install -m 644 lib/Restore.jar ${DESTDIR}/lib;

	install -m 644 share/postgresforest*.jar ${DESTDIR}/share;

    ## ---------------------------------------------------
    ## Install ForestTool
    ## ---------------------------------------------------
#	install -m 755 build/ForestTool.sh ${DESTDIR}/bin;
#	install -m 644 lib/ForestToolCUI*.jar ${DESTDIR}/lib;
	install -m 644 lib/commons-cli-1.0.jar ${DESTDIR}/lib;

	install -m 755 build/forestadm ${DESTDIR}/bin;
	install -m 644 lib/org.postgresforest.tool.cli.jar ${DESTDIR}/lib;
	install -m 644 lib/org.postgresforest.tool.lib.jar ${DESTDIR}/lib;

    ## ---------------------------------------------------
    ## Install Jpsql
    ## ---------------------------------------------------
	install -m 755 build/Jpsql.sh ${DESTDIR}/bin;
	install -m 644 lib/Jpsql.jar ${DESTDIR}/lib;

    ## ---------------------------------------------------
    ## Install recoverykit
    ## ---------------------------------------------------
        install -m 644 lib/RecoveryManager*.jar ${DESTDIR}/lib;
        install -m 755 build/ForestRecovery.sh ${DESTDIR}/bin;
        install build/functions/libforest_recovery* ${DESTDIR}/lib;
        install build/functions/libforest_recovery* ${DESTDIR}/lib;
        install build/functions/forest_recovery.sql ${DESTDIR}/share;
}


function install_pljava()
{
	cd build

    check_pljava_version

	if [ "x${PLJAVA_VERSION}" != "x" ]; then
		cd pljava-${PLJAVA_VERSION}

		mkdir -p ${PGHOME}/lib/pljava
		install -m 644 build/pljava.jar ${PGHOME}/lib/pljava
		install -m 644 build/deploy.jar ${PGHOME}/lib/pljava
		install -m 644 build/examples.jar ${PGHOME}/lib/pljava
		install build/objs/*.so ${PGHOME}/lib

		cd ..
	fi;

	cd ..
}

function check_install_files
{
	FILES=`xargs < MANIFEST`
	OK=1

	for f in ${FILES};
	  do if [ ! -f ${DESTDIR}$f ]; then
		  echo ${DESTDIR}$f not found.;
		  OK=0;
	  fi;
	done;

	if [ $OK -gt 0 ]; then
		echo "===============================================";
		echo "====== All files installed successfully. ======";
		echo "===============================================";
	else
		echo "==================================";
		echo "====== Installation failed. ======";
		echo "==================================";
	fi;
}

version_check;

make_directory;

install_files;

check_install_files;
