/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;

import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * O[oVXeJ^O쐬NX
 * 
 * O[oVXeJ^O̍쐬sB
 */
public class GscAction extends ActionBase{
	/**
	 * @param gsc
	 */
	public GscAction(GSCdata gsc) {
		super(gsc);
		// TODO ꂽRXgN^[EX^u
	}
	/**
	 * GSC쐬C
	 * 
	 */
	public boolean makeGsc(LoginInfo login)  {


		
		//͏擾
		String userName = login.getUser();
		String password = login.getPassword();

		//GSCNX
		GSCdata gsc = new GSCdata(userName, password);

		//ڑݒ
		String hostName = login.getHostname();
		String portNo = login.getPortno();
		String dbName = login.getDbname();
		if(dbName != null && dbName.compareTo("") != 0 ){
			gsc.addUrl(hostName, portNo, dbName);
		}
		
		//GSCݒ`FbN
		if (gsc.getURL().length == 0) {
			System.out.println(MessagesCommandLine.getString("errors.gsc.input"));
			return false;
		}

		//------------------------------
		//GSCf[^x[X쐬
		//------------------------------
		try {
			//template1ɐڑ
			if (!connectTemlate(gsc)) {
				return false;
			}

			//DB쐬
			if (!gsc.makeDB()) {
				setAccessErrs("errors.db.create", gsc);
				return false;
			}
			gsc.close();

			if (!connect(gsc)) {
				return false;
			}

			//XL[}쐬
			if (!gsc.makeGscTables()) {
				setAccessErrs(gsc);
				gsc.rollback();
				return false;
			}
			
			//GSCCX^Xo^
			if (!gsc.addGscServer(dbName, hostName, portNo)) {
				setAccessErrs(gsc);
				gsc.rollback();
				return false;
			}
			
			//ftHgRtBO̓o^
			//f[^XV
			if (!gsc.addConfig(new ConfigInfo()) ) {
				setAccessErrs(gsc);
				gsc.rollback();
				return false;
			}
			
			gsc.commit();

		} finally {
			gsc.close();
		}

		
		return true;
	}

	/**
	 * O[oVXeJ^O쐬
	 * 
	 */
	public boolean addGsc(String dbName, String serverid)  {
		
		
		//ǉGSCpGSCNX쐬
		GSCdata makegsc = new GSCdata(m_gsc.getUserPassword());
		
		try {
			//------------------------------
			//GSCXV
			//------------------------------
			if (!connect(m_gsc)) {
				return false; 
			}
			
			// T[oIDzXgA|[gNo擾
			Integer[] serverIdList = new Integer[1];
			serverIdList[0] = Integer.valueOf(serverid);
			ArrayList serverList;
			try {
				serverList = m_gsc.getServerList(serverIdList);
			} catch (SQLException e) {
				setAccessErrs(m_gsc);
				return false; 
			}
			ServerInfo info = (ServerInfo)serverList.get(0);
			String hostName = info.getHost();
			String portNo = info.getPort();
			
			//ǉGSCpGSCNXURLǉ
			if(dbName.compareTo("") != 0 ){
				makegsc.addUrl(hostName, portNo, dbName);
			}
			else{
				setAccessErrs(m_gsc);
				return false; 
			}
			
			//GSCCX^Xo^
			if (!m_gsc.addGscServer(Integer.parseInt(serverid), dbName)) {
				setAccessErrs(m_gsc);
				m_gsc.rollback();
				return false; 
			}

			//GSCCT[gpSQL擾
			ArrayList sqlList;
			try {
				sqlList = m_gsc.getGscInsertSql();
			} catch (SQLException e1) {
				setAccessErrs(m_gsc);
				m_gsc.rollback();
				return false; 
			}

			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false; 
			}
			
			//------------------------------
			//GSCf[^x[X쐬
			//------------------------------
			//template1ɐڑ
			if (!connectTemlate(makegsc)) {
				m_gsc.rollback();
				return false; 
			}

			//GSCf[^x[X쐬
			if (!makegsc.makeDB()) {
				setAccessErrs("errors.db.create", makegsc);
				m_gsc.rollback();
				return false; 
			}
			makegsc.close();

			//쐬GSCɐڑ
			if (!connect(makegsc)) {
				m_gsc.rollback();
				return false; 
			}

			//XL[}쐬
			if (!makegsc.makeGscTables()) {
				setAccessErrs(makegsc);
				makegsc.rollback();
				m_gsc.rollback();
				return false; 
			}

			//GSCCT[gpSQLs
			if (!makegsc.setGscInsertSql(sqlList)) {
				setAccessErrs(makegsc);
				makegsc.rollback();
				m_gsc.rollback();
				return false; 
			}
			
			
			makegsc.commit();
			m_gsc.commit();

			//GSCXV
			m_gsc.updateGscServer();
		
		} finally {
			makegsc.close();
			m_gsc.close();
		}
		
		return true;
	}
	/**
	 * O[oVXeJ^O폜
	 * 
	 */
	public boolean delGsc(String dbName, String serverid)  {
		
		
		String hostName = "";
		String portNo = "";
		
		//폜GSCpGSCNX쐬
		GSCdata makegsc = new GSCdata(m_gsc.getUserPassword());
		
		try {
			//--------------
			// GSC@XV
			//--------------
			if (!connect(m_gsc)) {
				return false; 
			}
			
			// T[oIDzXgA|[gNo擾
			Integer[] serverIdList = new Integer[1];
			serverIdList[0] = Integer.valueOf(serverid);

			ArrayList serverList;
			try {
				serverList = m_gsc.getServerList(serverIdList);
			} catch (SQLException e) {
				setAccessErrs(m_gsc);
				return false; 
			}
			
			ServerInfo info = (ServerInfo)serverList.get(0);
			hostName = info.getHost();
			portNo = info.getPort();
			
			//폜GSCpGSCNXURLǉ
			makegsc.addUrl(hostName, portNo, dbName);
			
			//GSCCX^X폜
			if (!m_gsc.delGscServer(Integer.parseInt(serverid), dbName)) {
				setAccessErrs(m_gsc);
				m_gsc.rollback();
				return false; 
			}

			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false; 
			}
			
			m_gsc.commit();
			
			//GSCXV
			m_gsc.updateGscServer();
			
			//GSCڑN[YiŃN[YȂƁAGSCɐڑꂽ܂܂ƂȂ̂DROPłȂBj
			m_gsc.close();

			//--------------
			// GSCf[^x[X폜
			//--------------
			//ڑ
			if (connectTemlate(makegsc)) {
				//GSCf[^x[X폜
				if (!makegsc.delDB()) {
					setAccessErrs("errors.db.drop", makegsc);
					return false;
				}
			}
		} finally {
			m_gsc.close();
			makegsc.close();
		}

		return true; 
		
	}	
	/**
	 * T[o擾
	 * 
	 */
	public ArrayList getGscList() throws Exception {
		ArrayList gscList = null;
			

		try {
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}

			//--------------
			// GSC𐶐
			//--------------
			gscList = m_gsc.getGscList();

		} catch (Exception e) {
			setAccessErrs(m_gsc);
			throw new Exception();

		} finally {
			m_gsc.close();
		}
		
		return gscList;
	}	
}
