package org.postgresforest.tool.commandline;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.sql.SQLException;

import org.postgresforest.tool.ForestToolCommandLine;
import org.postgresforest.tool.action.LoginAction;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.commandline.action.BrokenLogActions;
import org.postgresforest.tool.commandline.action.ConfigActions;
import org.postgresforest.tool.commandline.action.DbActions;
import org.postgresforest.tool.commandline.action.GscActions;
import org.postgresforest.tool.commandline.action.HashActions;
import org.postgresforest.tool.commandline.action.HelpActions;
import org.postgresforest.tool.commandline.action.InstanceActions;
import org.postgresforest.tool.commandline.action.TableActions;
import org.postgresforest.tool.commandline.action.UserActions;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.ReWriter;

	/**
	 * R}hCNX
	 * R}h̎󂯂AUsB
	 */
	public class ForestCommandLine {

	private static ForestToolCommandLine ftc = null;
	private static LoginInfo loginInfo = null;
	public static GSCdata gsc = null;
	/** Added by CWJ to permit \q command */
	static boolean done = false;
	/** sR}h */
	static String ExecLine = ""; //$NON-NLS-1$
	private static boolean isDbOpened = false;
	private static String selectDb = null; 
	
	/**
	 * RXgN^
	 * (ʏ탍OC)
	 * IvVOCɊi[
	 * @return ForestCommandLine
	 * @param hostname zXg
	 * @param portno |[gԍ
	 * @param username [U
	 * @param userpass [UpX[h
	 * @param gscname GSC
	 */
	public ForestCommandLine(String hostname, String portno, String username,
			String userpass, String gscname) {
		loginInfo = new LoginInfo();
		loginInfo.setHostname(hostname);
		loginInfo.setPortno(portno);
		loginInfo.setUser(username);
		loginInfo.setPassword(userpass);
		loginInfo.setDbname(gscname);
		// G[o͂ResourceBundleg߃CX^X
		ftc = new ForestToolCommandLine();
	}
	

	/**
	 * R}hC
	 * [U̓͂󂯂B
	 * @return void
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException
	 * @throws IOException
	 * @throws SQLException
	 */
	public void commandLine() throws ClassNotFoundException, FileNotFoundException, IOException, SQLException{
		// OC
		if (!login(loginInfo)) {
			System.out.println("[Error] Can not connect to DB ");
			return;
		}
		
		// IvVɂ鏈̐U蕪
		// R}ht@C͂ꍇAt@Cݒꊇ 
		if (ForestTool.isInputFile()) {
			String inputfile = ForestTool.getInputFile();
			System.out.println("Using Command file input from " + inputfile);
			System.out.println("------------ Start Commands ------------");
			processCommandFile(inputfile);
			System.out.println("------------- End Commands -------------");
			System.exit(0);//ȍ~͍̏sȂ
		} 
		
		// R}hC
		// ʏ폈
		if (true) { //Todo U蕪̐ 
			/* ̓vvg\A͂ꂽR}h𒀎 */
			// This provides us the means of reading from stdin
			StreamTokenizer input = new StreamTokenizer(new InputStreamReader(System.in));
			input.resetSyntax();
			input.slashSlashComments(true); // allow // as a comment delimiter
			input.eolIsSignificant(false);	// treat eol's as spaces
			input.wordChars(32, 126);
			// input.whitespaceChars(59, 59);	// Z~RXy[Xɂ͕ϊȂ
			// obNXbVR}hsɂ̓Z~R͂Kv͖
			// input.quoteChar(39); *** CWJ: messes up literals in query string ***
			
			// Now the main loop.
			int tt = 0, lineno = 1;
			boolean IsPronpt = true;
			
			while (tt != StreamTokenizer.TT_EOF && ! done)
			{	
				/* vvg\tOɏ]ăvvg\ */
				if(IsPronpt){
					if (isDbOpened) {
						// DBI[h
						System.out.println();
						System.out.print("[" + selectDb + "]> "); //$NON-NLS-1$ //$NON-NLS-2$
						System.out.flush();
						IsPronpt = false;
					} else {
						// GSCI[h
						System.out.println();
						System.out.print("[" + loginInfo.getDbname() + "]$ "); //$NON-NLS-1$ //$NON-NLS-2$
						System.out.flush();
						IsPronpt = false;
					}
				}
				
				// Here, we trap SQLException so they don't terminate the application
				try
				{
					tt = input.nextToken();
					if (tt == StreamTokenizer.TT_WORD || tt == StreamTokenizer.TT_EOL)
					{
						/* LFs󂯎Ƃ̂݃vvg\tO𗧂Ă */
						if(input.ttype == StreamTokenizer.TT_EOL){
							IsPronpt = true;
						}
						else{
							processLine(input.sval);
							lineno++;
						}
					}
				}
				catch (IOException e)
				{
					System.out.println("cui.error");
					System.out.println(e.getMessage());
					ExecLine = ""; //$NON-NLS-1$
				}
			}
	}
	System.out.println("Now closing the connection");			 //$NON-NLS-1$
	}
	
	/**
	 * OC
	 * IvVɊÂOCs
	 * @return void
	 * @param lInfo OCi[GSCdata
	 */
	private static boolean login(LoginInfo lInfo) {
		LoginAction adminLoginMng = new LoginAction();
		if(!adminLoginMng.login(loginInfo)){
			return false;
		}
		gsc = adminLoginMng.getGsc();
		return true;
	}
			

	/**
	 * ͂ꂽXe[gg
	 * This processes a statement
	 * 
	 * @return void
	 * @param line R}hC͂ꂽ
	 * @throws SQLException
	 */
	private static void processLine(String line) throws SQLException
	{	
		String EndChar = "q"; //$NON-NLS-1$
		
		String SQLEnd = ";"; //$NON-NLS-1$
		
		// Rg
		if (line.startsWith("--") || line.startsWith("#")){
			return ;
		} 
		
		if (line.startsWith("\\")) //$NON-NLS-1$
		{
			/* obNXbVR}hŃZ~RgĂꍇA폜 */
			if(line.endsWith(";")){ //$NON-NLS-1$
				ExecLine = line.substring(0,line.indexOf(';')); 
			}else{
				ExecLine = line;
			}
			processSlashCommand(ExecLine);
			ExecLine = ""; //$NON-NLS-1$
			return ;
		}
		if (line.indexOf(';') < 0) {
			/* ͕A */
			ExecLine += " " + line; //$NON-NLS-1$
		} else {
			/* Z~R͂܂œ͕A */
			ExecLine += line.substring(0, line.indexOf(';'));
			
			// R}h̃p[XEs
			try {
				// R}h̎s
				executeCommand(ExecLine);
			} catch (Exception e) {
				// TODO ꂽ catch ubN
				e.printStackTrace();
			} finally {
				ExecLine = ""; //$NON-NLS-1$
			}	
		}
	}
	
		
	
	
	/**
	 * R}h̎s
	 * CommandParserɂp[XʂɊÂāAeWbNɏUB
	 * @return void
	 * @param command R}h
	 */
	private static void executeCommand(String command) {

		// R}h̃p[X
		CommandParser cp = null;
		try {
			command = ReWriter.toLowerSql(command);
			cp = new CommandParser(command);
		} catch (Exception e1) {
			// TODO ꂽ catch ubN
			//			System.out.println(MessagesCommandLine.getString("cui.error.parser")); //$NON-NLS-1$
			//			e1.printStackTrace();
			return;
		}
		//\zR}h^Cv̎擾
		int cpType = cp.getType();

		//DDLR}h^Cv̎擾
		Parser pr = null;
		try {
			command = ReWriter.toLowerSql(command);
			pr = new Parser(command);
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			System.out.println(MessagesCommandLine.getString("cui.error.parser")); //$NON-NLS-1$
			e.printStackTrace();
			return;
		}
		int prType = pr.getType();

		// R}h^Cvʂ̃p[X
		if (cp.isHelpCommand()){
			HelpActions help = new HelpActions();
			help.show(cp);	
		} else if ( (cpType != CommandParser.NONE) && (prType == Parser.NONE)) {
			//DB Close
			if (!isDbOpened) {
				switch (cpType) {
	
					case CommandParser.NONE : //͕s
	
					case CommandParser.CREATE_INSTANCE :
						InstanceActions addInstance = new InstanceActions();
						addInstance.create(cp, gsc);	
						break;
				 	
					case CommandParser.DROP_INSTANCE :
						InstanceActions delInstance = new InstanceActions();
						delInstance.drop(cp, gsc);
						break;
	
					case CommandParser.SHOW_INSTANCE :
						InstanceActions showInstance = new InstanceActions();
						showInstance.show(gsc);
						break;
	
					case CommandParser.SET_INSTANCE_UP :
						InstanceActions setInstanceUp = new InstanceActions();
						setInstanceUp.set(cp, gsc, GSCdata.SERVER_RUNNING);
						break;
	
					case CommandParser.SET_INSTANCE_DOWN :
						InstanceActions setInstanceDown = new InstanceActions();
						setInstanceDown.set(cp, gsc, GSCdata.SERVER_TROUBLE);
						break;
	
					case CommandParser.CREATE_GSC :
						GscActions addGsc = new GscActions();
						addGsc.create(cp, gsc);					
						break;
	
					case CommandParser.DROP_GSC :
						GscActions delGsc = new GscActions();
						delGsc.drop(cp, gsc);		
						break;
						
					case CommandParser.SHOW_GSC :
						GscActions showGsc = new GscActions();
						showGsc.show(gsc);		
						break;
						
					case CommandParser.DUMP_GSC :
						System.out.println(MessagesCommandLine.getString("cui.message.gsc.dump") ); //$NON-NLS-1$
						// To do
						break;
	
					case CommandParser.RESTORE_GSC :
						// To do
						System.out.println(MessagesCommandLine.getString("cui.message.gsc.restore")) ; //$NON-NLS-1$
						break;
	
					case CommandParser.CHECK_GSC :
						GscActions checkGsc = new GscActions();
						checkGsc.check(loginInfo);		
						break;
	
					case CommandParser.CREATE_DB :
						DbActions createDb = new DbActions();
						createDb.create(cp, gsc);
						break;
	
					case CommandParser.DROP_DB :
						DbActions dropDb = new DbActions();
						dropDb.drop(cp, gsc);
						break;
	
					case CommandParser.RESTORE_DB :
						DbActions restoreDb = new DbActions();
						restoreDb.restore(cp, gsc);
						break;
	
					case CommandParser.SHOW_DB :
						DbActions showDb = new DbActions();
						showDb.show(gsc);
						break;
	
					case CommandParser.CREATE_DBINSTANCE :
						DbActions addDb = new DbActions();
						addDb.createDbInstance(cp, gsc);
						break;
	
					case CommandParser.DROP_DBINSTANCE :
						DbActions deleteDb = new DbActions();
						deleteDb.dropDbInstance(cp, gsc);
						break;
	
					case CommandParser.CREATE_USER :
						UserActions createUser = new UserActions();
						createUser.create(cp, gsc);
						break;
	
					case CommandParser.DROP_USER :
						UserActions dropUser = new UserActions();
						dropUser.drop(cp, gsc);
						break;
	
					case CommandParser.SHOW_USER :
						UserActions showUser = new UserActions();
						showUser.show(gsc);
						break;
	
					case CommandParser.CREATE_CONFIG :
						ConfigActions createConfig = new ConfigActions();
						createConfig.create(cp, gsc);
						break;
	
					case CommandParser.DROP_CONFIG :
						ConfigActions dropConfig = new ConfigActions();
						dropConfig.drop(cp, gsc);
						break;
	
					case CommandParser.SHOW_CONFIG :
						ConfigActions showConfig = new ConfigActions();
						showConfig.show(gsc);
						break;
	
					case CommandParser.SET_CONFIG :
						ConfigActions setConfig = new ConfigActions();
						setConfig.set(cp, gsc);
						break;
	
					case CommandParser.REPLICATE_CONFIG :
						ConfigActions replicateConfig = new ConfigActions();
						replicateConfig.replicate(cp, gsc);
						break;
	
					case CommandParser.CREATE_HASH :
						HashActions createHash = new HashActions();
						createHash.create(cp, gsc);
						break;
	
					case CommandParser.DROP_HASH :
						HashActions dropHash = new HashActions();
						dropHash.drop(cp, gsc);
						break;
	
					case CommandParser.SHOW_HASH :
						HashActions showHash = new HashActions();
						showHash.show(gsc);
						break;
	
					case CommandParser.SHOW_BROKENLOG :
						BrokenLogActions showLog = new BrokenLogActions();
						showLog.show(gsc);
						break;
	
					case CommandParser.CLEAR_BROKENLOG :
						BrokenLogActions clearLog = new BrokenLogActions();
						clearLog.clear(gsc);
						break;
	
					case CommandParser.OPEN_DB :
						if (isDbOpened != true) {
							if (cp.getDB().isEmpty() != true) {
								DbActions openDb = new DbActions();
								if (openDb.open(cp, gsc)) {
									isDbOpened = true ; 
									selectDb = (String)cp.getDB().get(0);									
									System.out.println(MessagesCommandLine.getString("cui.message.db.open", new Object[] { selectDb })) ; //$NON-NLS-1$
								} else {
									// GSCɑ݂ȂDBw肳ꂽꍇ
									String nosuchGsc = (String)cp.getDB().get(0);									
									System.out.println(MessagesCommandLine.getString("cui.error.db.open.nosuchdb", new Object[] { nosuchGsc })) ;									 //$NON-NLS-1$
								}
							} else {
								//DBw肳ĂȂꍇ
								System.out.println(MessagesCommandLine.getString("cui.error.db.notspecify")); //$NON-NLS-1$
							}
						} else {
							//DBOpenԂ̏ꍇ
							System.out.println(MessagesCommandLine.getString("cui.error.db.dupricateopen", new Object[] { selectDb })) ;							 //$NON-NLS-1$
						}
						break;
					

						
					default :
						System.out.println(MessagesCommandLine.getString("cui.message.db.notopen") ); //$NON-NLS-1$
						break;
				}
			}
			//DB Open
			else if (isDbOpened) {
				switch (cpType) {		
					case CommandParser.CLOSE_DB :
						if (selectDb != null) {
							System.out.println(MessagesCommandLine.getString("cui.message.db.close", new Object[] { selectDb })) ; //$NON-NLS-1$
							isDbOpened = false ;
							selectDb = null;
						} else {
							System.out.println(MessagesCommandLine.getString("cui.error.db.close", new Object[] { selectDb })) ; //$NON-NLS-1$
						}
						break;
						
					case CommandParser.SHOW_TABLE :
						TableActions showTable = new TableActions();
						showTable.showTable(gsc, selectDb);
						break;
						
					case CommandParser.SHOW_TABLE_COLUMN :
						TableActions showTableColumn = new TableActions();
						showTableColumn.showTableColumn(cp, gsc, selectDb);
						break;

					case CommandParser.PART_TABLE :
						TableActions partTable = new TableActions();
						partTable.part(cp, gsc, selectDb);
						break;

					case CommandParser.PART_TABLE2 :
						TableActions partTable2 = new TableActions();
						partTable2.part2(cp, gsc, selectDb);
						break;

					case CommandParser.REPART_TABLE :
						TableActions repartTable = new TableActions();
						repartTable.repart(cp, gsc, selectDb);
						break;

					case CommandParser.UNPART_TABLE :
						TableActions unpartTable = new TableActions();
						unpartTable.unpart(cp, gsc, selectDb);
						break;

					case CommandParser.SET_PRIORITY :
						TableActions setPriority = new TableActions();
						setPriority.setPriority(cp, gsc, selectDb);
						break;

					case CommandParser.SHOW_PRIORITY :
						TableActions showPriority = new TableActions();
						showPriority.showPriority(cp, gsc, selectDb);
						break;	
						
					default :
						//DBOpenԂ̏ꍇ
						System.out.println(MessagesCommandLine.getString("cui.error.db.dupricateopen", new Object[] { selectDb })) ;							 //$NON-NLS-1$
						break;
				}
			}			
		} else if ((cpType == CommandParser.NONE) && (prType != Parser.NONE)) {
			if (isDbOpened) {
				if (pr.getType() == Parser.DML) {
					// DMLs(Jpsqľďo)
					// To do
					System.out.println(MessagesCommandLine.getString("cui.error.dml.notsupport")); //$NON-NLS-1$
				} else if (pr.getType() != Parser.NONE) {
					//DDLs
					DbActions execDdl = new DbActions();
					execDdl.executeDdl(gsc, command, selectDb);
				} 
			} else {
				// DBI[vԂł́ADDL/DMLR}h̓
				System.out.println(MessagesCommandLine.getString("cui.message.db.notopen")); //$NON-NLS-1$
			} 
		} else if (cpType == CommandParser.SHOW_HELP){
			System.out.println(MessagesCommandLine.getString("cui.help.command.show")) ; //$NON-NLS-1$
 		} else if (cp.isHelpCommand()){
			System.out.println(MessagesCommandLine.getString("cui.help.help.show")) ; //$NON-NLS-1$
		} else {
			// Ή̃R}h 
			System.out.println(MessagesCommandLine.getString("cui.error.command.noexist"));		 //$NON-NLS-1$
		}
	}

	/**
	 * R}ht@Cǂݍݎs
	 * 
	 * @param filename ͂ꂽR}ht@C(tpX)
	 * @throws SQLException
	 * @throws IOException
	 */
	public static void processCommandFile(String filename) throws SQLException,IOException{
		BufferedReader br;
		String line;

		try{
			br = new BufferedReader(new FileReader(filename));
			while((line = br.readLine()) != null){
				processLine(line);
			}		
		}
		catch(FileNotFoundException e){
			System.out.println(MessagesCommandLine.getString("cui.error.command.filenotfound", new Object[] {filename})); //$NON-NLS-1$
		}
	}
	
	
	/**
	 * obNXbVR}h(\q,\i,\fi,\fg\,\fu,\fc,\fh\,fb,\ft,\fp)
	 * This process / commands (for now just /d)
	 * 
	 * @return void
	 * @param line R}hC͂ꂽ
	 * @throws SQLException
	 * 
	 */
	public static void processSlashCommand(String line) throws SQLException
	{	

		// t@C̓ǂݍ
		if (line.startsWith("\\i")) //$NON-NLS-1$
		{
			if (line.startsWith("\\i ")) //$NON-NLS-1$
			{
					// Display details about a table
					String file = extractSlashCmdArgument(line, 3);
					// file̓ǂݍ
					try {
						System.out.println("execute command"); //$NON-NLS-1$
						System.out.println("  fileF" + file); //$NON-NLS-1$
						ExecLine = ""; //$NON-NLS-1$
						processCommandFile(file);
					} catch (IOException e) {
						System.out.println(MessagesCommandLine.getString("cui.error.command.io", new Object[] { file })); //$NON-NLS-1$						
						e.printStackTrace();
					}
			} else {
				// Display details about a table
				System.out.println(MessagesCommandLine.getString("cui.help.back.i")); //$NON-NLS-1$
			}
		} else	if (line.startsWith("\\f")) { //$NON-NLS-1$
			// PostgresForest CommandLineToolp̃obNXbVR}h
			if (line.startsWith("\\fi")) { //$NON-NLS-1$
				// CX^X̕\
				InstanceActions showInstance = new InstanceActions();
				showInstance.show(gsc);				
			} else if (line.startsWith("\\fg")) { //$NON-NLS-1$
				// GSC̕\
				GscActions showGsc = new GscActions();
				showGsc.show(gsc);					
			} else if (line.startsWith("\\fd")) { //$NON-NLS-1$
				// DB̕\
				DbActions showDb = new DbActions();
				showDb.show(gsc);					
			} else if (line.startsWith("\\fu")) { //$NON-NLS-1$
				// [U̕\
				UserActions showUser = new UserActions();
				showUser.show(gsc);						
			} else if (line.startsWith("\\fc")) { //$NON-NLS-1$
				// RtBO̕\
				ConfigActions showConfig = new ConfigActions();
				showConfig.show(gsc);			
			} else if (line.startsWith("\\fh")) { //$NON-NLS-1$
				// nbV̕\
				HashActions showHash = new HashActions();
				showHash.show(gsc);					
			} else if (line.startsWith("\\fb")) { //$NON-NLS-1$
				// O̕\
				BrokenLogActions showLog = new BrokenLogActions();
				showLog.show(gsc);				
			} else if (line.startsWith("\\ft")) { //$NON-NLS-1$
				// e[u̕\
				if (isDbOpened) {
					if (line.startsWith("\\ft ")) { //$NON-NLS-1$
						// e[u̎擾
						String table = extractSlashCmdArgument(line, 4);
						if (!table.equals("")) { //$NON-NLS-1$
							// e[u̕\
							TableActions showTable = new TableActions();
							showTable.showTableColumn(table, gsc, selectDb);
							return;
						}
					}
					TableActions showTable = new TableActions();
					showTable.showTable(gsc, selectDb);							
				} else {
					System.out.println(MessagesCommandLine.getString("cui.message.db.notopen"));					 //$NON-NLS-1$
				}
			} else if (line.startsWith("\\fp")) { //$NON-NLS-1$
				// Dx̕\
				if (isDbOpened) {
					if (line.startsWith("\\fp ")) { //$NON-NLS-1$
						// e[u̎擾
						String table = extractSlashCmdArgument(line, 4);
						if (!table.equals("")) { //$NON-NLS-1$
							// Dx̕\
							TableActions showPriority = new TableActions();
							showPriority.showPriority(table, gsc, selectDb);
							return;
						}
					}
					System.out.println(MessagesCommandLine.getString("cui.error.help.back.fp"));					 //$NON-NLS-1$
					System.out.println(MessagesCommandLine.getString("cui.help.back.f")); //$NON-NLS-1$
				} else {
					System.out.println(MessagesCommandLine.getString("cui.message.db.notopen"));					 //$NON-NLS-1$
				}
			} else {
				System.out.println(MessagesCommandLine.getString("cui.error.back.f")); //$NON-NLS-1$
				System.out.println(MessagesCommandLine.getString("cui.help.back.f")); //$NON-NLS-1$
			}
		} else if (line.equals("\\q")) // Added by CWJ to permit \q command //$NON-NLS-1$
			done = true;
		else {
//			System.out.println("Unsupported \\ command: " + line);
			System.out.println(MessagesCommandLine.getString("cui.error.back.f")); //$NON-NLS-1$
			System.out.println(MessagesCommandLine.getString("cui.help.back.f")); //$NON-NLS-1$
		}
	}


	public static LoginInfo getLoginInfo() {
		return loginInfo;
	}
	
	/**
	 * obNXbVR}h̃p[^𒊏o
	 * R}ȟ̃Xy[X𖳎āAp[^݂̂𒊏o
	 * @param str Xy[X܂񂾕
	 * @param index obNXbVR}h̕+1
	 * @return obNXbVR}h̃p[^
	 */
	private static String extractSlashCmdArgument(String str, int index) {
		String ret = ""; //$NON-NLS-1$
		String subStr = str.substring(index);
		StreamTokenizer tokenizer = CommandParser.initTokenizer(subStr);
		try {
			int token = tokenizer.nextToken();
			if(tokenizer.sval != null) {
				ret = tokenizer.sval;				
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return ret;
	}

}

