/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.partition.priority;



import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.dialog.ValidateResult;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.view.partitionlist.PartitionListLabelProvider;


/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class PartitionPriorityDialog extends CommonDialog {

	
	protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
	protected int m_partCount;
	protected ArrayList m_servers;
	
	/**
	 * @param parent
	 */
	public PartitionPriorityDialog() {
		
		
	}

	/* ( Javadoc)
	 * @see org.postgresforest.tool.m_dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {
		

		
		//e[u
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION |SWT.HIDE_SELECTION | SWT.SINGLE |SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		
		//wb_J̕ҏW
		TableColumn column = new TableColumn(table, SWT.LEFT );
		column.setText(Messages.getString("form.instance"));
		column.setWidth(100);

		for (int i = 1; i <= m_partCount; i++) {
			column = new TableColumn(table, SWT.CENTER, i);
			column.setText(m_dcFmt.format(i-1));
			column.setWidth(60);
			
		}
		
		
		TableViewer viewer = new TableViewer(table);
		
		viewer.setContentProvider(new CommonTableContentProvider());
		viewer.setLabelProvider(new PartitionListLabelProvider());

		

		//TableViewerɃe[uꗗݒ
		viewer.setInput(m_servers);

		
		ComboBoxCellEditor comboEditer = new ComboBoxCellEditor();		

		String[] properties = new String[m_partCount + 1];
		CellEditor[] editors = new CellEditor[m_partCount + 1];
		String[] comboItem = new String[m_servers.size()];
		for (int i = 0; i < m_partCount; i++) {
			//ŏ̃J̓CX^XJ
			properties[i+1] = Integer.toString(i);
			editors[i+1] = comboEditer;
		}
		for (int i = 0; i < comboItem.length; i++) {
			comboItem[i] = Integer.toString(i);
		}

		
		
		comboEditer.setStyle(SWT.READ_ONLY|SWT.CENTER);
		comboEditer.create(table);
		comboEditer.setItems(comboItem);


		
		// JEvpeB̐ݒ
		viewer.setColumnProperties(properties);

	    //ZEGfB^̐ݒ
	    viewer.setCellEditors(editors);
	    
	    //ZEfBt@C̐ݒ
	    viewer.setCellModifier(new PartitionPriorityCellModifier(viewer));
		
		
		
		
	}

		
	/* ( Javadoc)
	 * @see org.postgresforest.tool.m_dialog.CommonDialog#validate()
	 */
	protected ValidateResult validate() {

		ValidateResult result = new ValidateResult();
		
		
		
		//D揇`FbN	
		for (int partNo = 0; partNo < m_partCount; partNo++) {
			ArrayList priorityNoList = new ArrayList();
			//D揇z쐬
			for (Iterator iterator = m_servers.iterator(); iterator.hasNext();) {		
				ServerPriorityInfo svrPriorityInfo =
					(ServerPriorityInfo) iterator.next();

				PriorityInfo priorityInfo =	svrPriorityInfo.getPartition(partNo);
				if(priorityInfo != null){
					priorityNoList.add(priorityInfo.getPriority());
				}
			}

			//D揇z`FbN
			for (int priority = 0; priority < priorityNoList.size(); priority++) {
				boolean check = false;
				boolean duplicate = false;
				for (int i = 0; i < priorityNoList.size(); i++) {
					Integer priorityNo = (Integer)priorityNoList.get(i);
					if (priority == priorityNo.intValue()) {
						if(check){
							duplicate = true;
							break;
						}
						check = true;
					}
				}
				if (duplicate) {
					result.setMessage(Messages.getString("errors.duplicate", m_dcFmt.format(partNo)));
					result.setValid(false);
					break;
				}
				if (!check) {
					String[] param = {m_dcFmt.format(partNo),Integer.toString(priority)};
					result.setMessage(Messages.getString("errors.priority", param));
					result.setValid(false);
					break;
				}
			}
		}
		
		
		return result;
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.user.partition"));
	
	}

	
	/**
	 * @param partCount partCount ݒB
	 */
	public void setPartCount(int partCount) {
		m_partCount = partCount;
	}
	/**
	 * @return tableList ߂܂B
	 */
	public ArrayList getTableList() {
		return m_servers;
	}
	/**
	 * @param tableList tableList ݒB
	 */
	public void setServers(ArrayList tableList) {
		m_servers = tableList;
	}
}
