/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.brokenlog;


import java.util.ArrayList;
import java.util.Date;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewPluginAction;
import org.postgresforest.tool.action.BrokenLogAction;
import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.TableColumnSelectionListener;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.DelBrokenLogAction;
import org.postgresforest.tool.view.action.ModBrokenLogAction;

/**
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class BrokenLogView extends ViewBase {
	public static final String ID = "org.postgresforest.tool.view.BrokenLogView";

	private TableViewer viewer = null;

	private ViewerSorter m_soreter = null;

	/* ( Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		int i = 0;
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI |SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
//		  Column  |            Type             | Modifiers
//		  ----------+-----------------------------+-----------
//		   serverid | smallint                    | not null
//		   datetime | timestamp without time zone |
//		   client   | character varying(64)       |
//		   msg      | text                        |
//		   status   | text                        |
//		   query    | text                        |		
		TableColumn column = new TableColumn(table, SWT.LEFT, 
				BrokenLogLabelProvider.FOREST_BROKENLOG_SERVER_URL_COLUMN);
		column.setText(Messages.getString("form.brokenlog.url"));
		column.setWidth(100);	
//		column.addSelectionListener(new SelectionListener(){
//			public void widgetSelected(SelectionEvent e){
//				e.
//			}
//			public void widgetDefaultSelected(SelectionEvent e){
//				
//			}
//		
//		});
		
		column = new TableColumn(table, SWT.LEFT, 
				BrokenLogLabelProvider.FOREST_BROKENLOG_DATETIME_COLUMN);
		column.setText(Messages.getString("form.brokenlog.datetime"));
		column.setWidth(100);
//MASUCOMMENT 2005.11.07 JǉɂC		
		column = new TableColumn(table, SWT.LEFT, 
				BrokenLogLabelProvider.FOREST_BROKENLOG_CLIENT_COLUMN);
		column.setText(Messages.getString("form.brokenlog.client"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				BrokenLogLabelProvider.FOREST_BROKENLOG_MSG_COLUMN);
		column.setText(Messages.getString("form.brokenlog.msg"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				BrokenLogLabelProvider.FOREST_BROKENLOG_STATUS_COLUMN);
		column.setText(Messages.getString("form.brokenlog.status"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				BrokenLogLabelProvider.FOREST_BROKENLOG_QUERY_COLUMN);
		column.setText(Messages.getString("form.brokenlog.query"));
		column.setWidth(100);
		
		
		
		viewer = new TableViewer(table);

		viewer.setContentProvider(new CommonTableContentProvider());
		
		viewer.setLabelProvider(new BrokenLogLabelProvider());

		TableColumn [] columns = table.getColumns();
		for (i=0; i< columns.length; i++){
			TableColumnSelectionListener tcSelection = new TableColumnSelectionListener(i, viewer);
			columns[i].addSelectionListener(tcSelection);
		}
		
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
		    public void selectionChanged(SelectionChangedEvent event){
		    
		        ISelection selection = event.getSelection();
		        setEnabledAction(DelBrokenLogAction.ID,selection);
		        setEnabledAction(ModBrokenLogAction.ID,selection);
		        
		    }
    								
		});
		viewer.addDoubleClickListener(new IDoubleClickListener(){
			
			public void doubleClick(DoubleClickEvent event){
		    	PluginActionContributionItem ci = (PluginActionContributionItem)getViewSite().getActionBars().getToolBarManager().find(ModBrokenLogAction.ID);
		    	ViewPluginAction action =  (ViewPluginAction)ci.getAction();
		    	action.run();
		 
				
				
			}
			
		});
		//MASUCOMMENT ENbN΍
		createContextMenu(viewer.getTable());
	}


	public void update() {

	    if(!isLogin()){
			viewer.setInput(null);
			setEnabledAction(DelBrokenLogAction.ID, EnableSelection.FALSE);
	        return;
	    }

		ArrayList brokenLogList = null;

		//T[o擾
		BrokenLogAction brokenLogAction = new BrokenLogAction(getGsc());
		try {
			brokenLogList = brokenLogAction.getList();
			viewer.setInput(brokenLogList);
		} catch (Exception e) {
//			ErrorLog.log("", e);
		}


	}
	
	
	/**
	 * IT[oID擾
	 * 
	 * @return T[oID
	 */
	public String getSelectId() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			BrokenLogInfo brokenLogInfo = (BrokenLogInfo)selectItem[0].getData();
			return Integer.toString(brokenLogInfo.getServerid());
		}
		else{
			return "";
		}
	}
	/**
	 * Q擾
	 * 
	 * @return T[oID
	 */
	public Date getSelectDate() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			BrokenLogInfo brokenLogInfo = (BrokenLogInfo)selectItem[0].getData();
			return brokenLogInfo.getDatetime();
		}
		else{
			return null;
		}
	}
	/**
	 * IꂽijBrokenLog擾
	 * @return
	 */
	//MASUCOMMENT 2005.11.15 Addition
	public ArrayList getSelectedBrokenLogInfoList(){
		int i=0;
		ArrayList brokenLogInfoList = null;
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		
		if(selectItem.length >= 1){
			brokenLogInfoList = new ArrayList();
			for(i=0; i< selectItem.length; i++){
				brokenLogInfoList.add((BrokenLogInfo)selectItem[i].getData());
			}
		}
		return brokenLogInfoList;
	}

}
