/*-------------------------------------------------------------------------
*
* Copyright (c) 2004-2005, PostgreSQL Global Development Group
*
* IDENTIFICATION
*   $PostgreSQL: pgjdbc/org.postgresforest.jdbc3/ForestResultSetMetaData.java,v 1.7 2005/01/11 08:25:47 jurka Exp $
*
*-------------------------------------------------------------------------
*/
package org.postgresforest.vm.jdbc;

import java.sql.SQLException;

import org.postgresforest.core.*;

public class ForestResultSetMetaData extends org.postgresforest.jdbc2.AbstractJdbc2ResultSetMetaData implements java.sql.ResultSetMetaData
{

	ForestConnection m_con;
	
    public ForestResultSetMetaData(BaseConnection connection, Field[] fields) {
		super(connection, fields);
		m_con = (ForestConnection) connection;
	}

	public String getBaseColumnName(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getBaseColumnName(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public String getBaseSchemaName(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getBaseSchemaName(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public String getBaseTableName(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getBaseTableName(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public String getColumnClassName(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getColumnClassName(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getColumnDisplaySize(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getColumnDisplaySize(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getColumnType(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getColumnType(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public String getColumnTypeName(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getColumnTypeName(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getPrecision(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getPrecision(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getScale(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getScale(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public boolean isAutoIncrement(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.isAutoIncrement(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public boolean isCaseSensitive(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.isCaseSensitive(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public boolean isCurrency(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.isCurrency(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int isNullable(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.isNullable(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public boolean isSearchable(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.isSearchable(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public boolean isSigned(int column) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.isSigned(column);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}


}

