/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.core;

import java.sql.SQLException;
import java.util.Properties;
import org.postgresforest.core.ProtocolConnection;
import org.postgresforest.core.v3.ConnectionFactoryImpl;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"forest", new org.postgresforest.vm.core.ConnectionFactoryImpl()}, {"3", new ConnectionFactoryImpl()}, {"2", new org.postgresforest.core.v2.ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(String host, int port, String user, String database, Properties info) throws SQLException {
        String protoName = info.getProperty("protocolVersion");
        for (int i = 0; i < versions.length; ++i) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)versions[i][0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)versions[i][1]).openConnectionImpl(host, port, user, database, info)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract ProtocolConnection openConnectionImpl(String var1, int var2, String var3, String var4, Properties var5) throws SQLException;
}

