/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli;

import java.io.IOException;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.cli.AbstractCommandProcessor;
import org.postgresforest.tool.cli.action.DbActions;
import org.postgresforest.tool.cli.action.TableActions;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.ReWriter;

public class DbCommandProcessor
extends AbstractCommandProcessor {
    private AbstractCommandProcessor m_gscCommandProcessor = null;
    private Database m_db = null;

    public DbCommandProcessor(GSCdata gsc, AbstractCommandProcessor gscProcesser, String dbname) throws ForestToolException {
        super(gsc);
        this.m_gscCommandProcessor = gscProcesser;
        this.m_db = this.m_gsc.getDatabase(dbname);
    }

    public void printPrompt() {
        System.out.println("");
        System.out.print("[" + this.m_db.getDatabaseName() + "]> ");
        System.out.flush();
    }

    protected AbstractCommandProcessor executeCommand(CommandParser cp, String command) {
        int cpType = cp.getType();
        switch (cpType) {
            case 101: {
                Logger.notice((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u3092\u30af\u30ed\u30fc\u30ba\u3057\u307e\u3057\u305f\u3002", (String)this.m_db.getDatabaseName()));
                return this.m_gscCommandProcessor;
            }
            case 110: {
                TableActions.showTable(this.m_db);
                break;
            }
            case 114: {
                TableActions.showTableColumn(cp, this.m_db);
                break;
            }
            case 111: {
                TableActions.part(cp, this.m_db);
                break;
            }
            case 112: {
                TableActions.part2(cp, this.m_db);
                break;
            }
            case 113: {
                TableActions.unpart(cp, this.m_db);
                break;
            }
            case 120: {
                TableActions.setPriority(cp, this.m_db);
                break;
            }
            case 121: {
                TableActions.showPriority(cp, this.m_db);
                break;
            }
            case 100: {
                Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u304c\u30aa\u30fc\u30d7\u30f3\u3055\u308c\u3066\u3044\u307e\u3059\u3002", (String)this.m_db.getDatabaseName()));
                break;
            }
            default: {
                Parser pr = null;
                try {
                    command = ReWriter.toLowerSql(command);
                    pr = new Parser(command);
                }
                catch (IOException e) {
                    Logger.error((String)GT.tr((String)"\u30b3\u30de\u30f3\u30c9\u307e\u305f\u306f\u69cb\u6587\u304c\u9055\u3044\u307e\u3059\u3002"));
                    Logger.error((String)e.getMessage());
                    Logger.trace((Exception)e);
                    break;
                }
                catch (NullPointerException e) {
                    Logger.error((String)GT.tr((String)"\u30b3\u30de\u30f3\u30c9\u307e\u305f\u306f\u69cb\u6587\u304c\u9055\u3044\u307e\u3059\u3002"));
                    Logger.debug((String)"NullPointerException");
                    Logger.trace((Exception)e);
                    break;
                }
                int prType = pr.getType();
                if (prType == 200) {
                    Logger.error((String)GT.tr((String)"DML\u6587\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                    break;
                }
                if (prType != -1) {
                    DbActions.executeDdl(command, pr, this.m_db);
                    break;
                }
                Logger.error((String)GT.tr((String)"\u30b3\u30de\u30f3\u30c9\u307e\u305f\u306f\u69cb\u6587\u304c\u9055\u3044\u307e\u3059\u3002"));
            }
        }
        return this;
    }

    protected void processSlashCommandTable(String line) {
        String table;
        if (line.startsWith("\\ft ") && !(table = CommandParser.extractSlashCmdArgument(line, 4)).equals("")) {
            TableActions.showTableColumn(table, this.m_db);
            return;
        }
        TableActions.showTable(this.m_db);
    }

    protected void processSlashCommandPriority(String line) {
        String table;
        if (line.startsWith("\\fp ") && !(table = CommandParser.extractSlashCmdArgument(line, 4)).equals("")) {
            TableActions.showPriority(table, this.m_db);
            return;
        }
        Logger.error((String)MessagesCommandLine.getString("cui.error.help.back.fp"));
        Logger.println((String)MessagesCommandLine.getString("cui.help.back.f"));
    }
}

