/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;

import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.db.GSCdata;

/**
 * CX^Xo^NX
 * 
 * CX^Xo^sB
 */
public class ConfigAction extends ActionBase{

	/**
	 * @param gsc
	 */
	public ConfigAction(GSCdata gsc) {
		super(gsc);
	}
	
	/**
	 * T[oXe[^X擾
	 * 
	 */
	public ArrayList getList() throws Exception{


		//f[^쐬
		ArrayList configList = null;
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}
			
			//T[o쐬
			configList = m_gsc.getConfigList();

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			m_gsc.close();
		}

		return configList;
	}
	
	/**
	 * 
	 */
	public ConfigInfo get(String id) throws Exception {


		//f[^쐬
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}
			
			//T[o쐬
			return m_gsc.getConfigInfo(id);

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			m_gsc.close();
		}


		
		
	}
	/**
	 * CX^Xo^
	 * 
	 */
	public boolean add(ConfigInfo configInfo )  {
		
		try {
			//GSC֐ڑ
			if (!connect(m_gsc)) {
				return false;
			}
			
			//f[^XV
			if (m_gsc.addConfig(configInfo)) {
				m_gsc.commit();
			} else {
				m_gsc.rollback();
			}
			
		} finally {
			m_gsc.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
		}
		
		return true;
	}
	/**
	 * nbV֐폜
	 * 
	 */
	public boolean del(String id)  {
		
		try {
			if (!connect(m_gsc)) {
				return false;
			}

			//f[^XV
			if (m_gsc.delConfig(id)) {
				m_gsc.commit();
			} else {
				m_gsc.rollback();
			}

		} finally {
			m_gsc.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
		}
		return true;
	}
	//TODOMASU ͍폜ׂH
	/**
	 * nbV֐폜
	 * 
	 */
//	public boolean mod(ConfigInfo configInfo) {
//		
//		try {
//			if (!connect(m_gsc)) {
//				return false;
//			}
//
//			//f[^XV
//			if (m_gsc.delConfig(configInfo.getConfigId())&& m_gsc.addConfig(configInfo)) {
//				m_gsc.commit();
//			} else {
//				m_gsc.rollback();
//			}
//
//		} finally {
//			m_gsc.close();
//			if( m_gsc.isErrInfo() ){
//				setAccessErrs(m_gsc);
//				return false;
//			}
//		}
//		return true;
//	}
	public boolean mod(String oldConfigID, ConfigInfo configInfo) {
		
		try {
			if (!connect(m_gsc)) {
				return false;
			}

			//f[^XV
			if (m_gsc.delConfig(oldConfigID)&& m_gsc.addConfig(configInfo)) {
				m_gsc.commit();
			} else {
				m_gsc.rollback();
			}

		} finally {
			m_gsc.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
		}
		return true;
	}

	
}
