/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.actionset;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.postgresforest.tool.action.LoginAction;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.dialog.login.AdminLoginDialog;
import org.postgresforest.tool.util.LoginHistry;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewUtil;
import org.postgresforest.tool.view.brokenlog.BrokenLogView;
import org.postgresforest.tool.view.config.ConfigView;
import org.postgresforest.tool.view.dbinstance.DbInstanceView;
import org.postgresforest.tool.view.ddl.DdlView;
import org.postgresforest.tool.view.hash.HashView;
import org.postgresforest.tool.view.menu.AdminMenuView;
import org.postgresforest.tool.view.partitionlist.PartitionListView;
import org.postgresforest.tool.view.serverstatus.ServerStatusView;
import org.postgresforest.tool.view.tablecolumn.TableColumnView;
import org.postgresforest.tool.view.user.UserView;

/**
 * Ǘ҃OCANVNX
 *
 */
public class AdminLoginAction implements IWorkbenchWindowActionDelegate {

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		LoginHistry loginhistry = new LoginHistry(LoginHistry.ADMIN);
		List loginlist = loginhistry.load();
		
		//Ǘ҃OC_CAO\
		AdminLoginDialog dialog = new AdminLoginDialog(loginlist);
		
		
		if (dialog.open() == Window.OK) {
		    //OCi[
			LoginInfo loginInfo = dialog.getLoginInfo();

			loginhistry.save(loginInfo);

			//ZbVvpeB̃O[oVXeJ^ONXNA
		    SessionProperty.set("gsc", null);

			
			LoginAction adminLoginMng = new LoginAction();
			if(!adminLoginMng.login(loginInfo)){
				return;
			}

			//ZbVvpeBɃO[oVXeJ^ONXݒ
			SessionProperty.set("gsc", adminLoginMng.getGsc());
	    
		    //er[ĕ\
			ViewUtil.updateView(ServerStatusView.ID,true,false);
//TODOMASU GSCView͂Ȃ̂ŃAbvf[gȂ
//			ViewUtil.updateView(GscView.ID,true,false);
			ViewUtil.updateView(DbInstanceView.ID,true,false);
			ViewUtil.updateView(UserView.ID,true,false);
			ViewUtil.updateView(ConfigView.ID,true,false);
			ViewUtil.updateView(HashView.ID,true,false);
			//MASUCOMMENT u[NÕr[ǉ
			ViewUtil.updateView(BrokenLogView.ID,true,false);
			//[U[j[r[\
			ViewUtil.updateView(DdlView.ID);
			ViewUtil.updateView(TableColumnView.ID);
			ViewUtil.updateView(PartitionListView.ID);
//TODOMASU TableListView͂Ȃ̂ŃAbvf[gȂ
//			ViewUtil.updateView(TableListView.ID);
			
		}
		
		//Ǘ҃j[XV
	    ViewUtil.updateView(AdminMenuView.ID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

}
