/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.GSCInfo;
import org.postgresforest.tool.bean.HashInfo;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresql.jdbc3.Jdbc3Connection;

/**
 * O[oVXeJ^ONX.
 * 
 * O[oVXeJ^Oɑ΂f[^ANZX񋟂B
 * 
 */
public class GSCdata extends DbBase {

	public static final int PRIMARY = 0;
	public static final int BACKUP = 1;

	public static final int SERVER_RUNNING = 1;
	public static final int SERVER_TROUBLE = -1;

	//TODOMASU e[uXy[X擾̂
	protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
	//	/**
//	 * RXgN^B
//	 * ̃RXgN^́A[UApX[h\[Xt@C擾B
//	 *
//	 */
//	public GSCdata() {
//		super();
//
//		m_prop.put("user", m_sqlResource.getString("admin.user"));
//		m_prop.put("password", m_sqlResource.getString("admin.password"));
//
//	}
	/**
	 *@RXgN^.
	 */
	public GSCdata(String user, String password) {
		super(user, password);

	}
	
	/**
	 * RXgN^
	 * @param userPassword@[UApX[hi[ꂽvpeBNX
	 * @since 2.0
	 */
	public GSCdata(Properties userPassword) {
		super();
		m_prop = userPassword;

	}

	/**
	 * O[oVXeJ^Of[^x[X쐬
	 * 
	 * O[oVXeJ^Op̍쐬IvV\[X擾āA
	 * f[^x[X쐬sB
	 * 
	 * @return
	 * @throws SQLException
	 */
	public boolean makeDB()  {

		String gscOption = m_sqlResource.getString("create.db.gsc.option");
		return makeDB(gscOption, DB_MAKE);
		
	}

	/**
	 * O[oVXeJ^Õe[u쐬B
	 * [Ugrants
	 * @return	true:.false:s
	 */
	public boolean makeGscTables()  {

		boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				Statement ps = con.createStatement();

				connectUrl = ((Jdbc3Connection) con).getURL();
				
				//GSCpe[u쐬
				ps.execute(m_sqlResource.getString("create.gsc.forest_server"));
				ps.execute(m_sqlResource.getString("create.gsc.forest_servdb"));
				//Ver3.0
				ps.execute(m_sqlResource.getString("create.gsc.forest_hash"));
				ps.execute(
					m_sqlResource.getString("create.gsc.forest_tablepart"));
				ps.execute(
					m_sqlResource.getString("create.gsc.forest_tablepartdtl"));
				ps.execute(m_sqlResource.getString("create.gsc.forest_partatr"));
				ps.execute(m_sqlResource.getString("create.gsc.forest_gsc"));
				//Ver2.1
				ps.execute(m_sqlResource.getString("create.gsc.forest_brokenlog"));

				//Ver3.0
				ps.execute(m_sqlResource.getString("create.gsc.forest_config"));

				//GSCpe[uւ̃[UOg
				ps.execute(m_sqlResource.getString("grant.gsc.forest_server"));
				ps.execute(m_sqlResource.getString("grant.gsc.forest_servdb"));
				ps.execute(
					m_sqlResource.getString("grant.gsc.forest_tablepartdtl"));
				ps.execute(m_sqlResource.getString("grant.gsc.forest_tablepart"));
				ps.execute(m_sqlResource.getString("grant.gsc.forest_partatr"));
				ps.execute(m_sqlResource.getString("grant.gsc.forest_gsc"));
				//Ver2.1
				ps.execute(m_sqlResource.getString("grant.gsc.forest_brokenlog"));

								
				ps.close();

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}
		}

		return ret;


	}

	/**
	 * T[oCX^X폜
	 * 
	 * forest_server 炵ĂꂽID̃R[h폜
	 * @param id	T[oID
	 * @return	true:.false:s
	 */
	public boolean delServer(int id) {

		boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.server"));
	
				smt.setInt(1, id);
	
				smt.execute();
				smt.close();
	

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}

	/**
	 * nbV֐o^
	 * 
	 * w肳ꂽNXt@Cforest_hash֒ǉB
	 * 
	 * 
	 * @param name
	 * @param description
	 * @param classImage
	 * @return	true:.false:s
	 * @since 3.0
	 */
	public boolean addHash(String name, String description, byte[] classImage) {

		boolean ret = true;
		String connectUrl = "";

		//--------------
		// GSCXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.hash"));
		
				psmt.setString(1, name);
				psmt.setString(2, description);
				psmt.setBytes(3, classImage);
				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}

	/**
	 * nbV֐o^
	 * 
	 * w肳ꂽNXt@Cforest_hash֒ǉB
	 * 
	 * 
	 * @param name
	 * @param description
	 * @param classImage
	 * @return	true:.false:s
	 * @since 3.0
	 */
	public boolean addConfig(ConfigInfo configInfo) {

		boolean ret = true;
		String connectUrl = "";

		//--------------
		// GSCXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.config"));
		
				psmt.setString(1, configInfo.getConfigId());
				psmt.setString(2, configInfo.getDescription());
				psmt.setLong(3, configInfo.getCacheReflesh());
				psmt.setLong(4, configInfo.getRetryCount());
				psmt.setLong(5, configInfo.getDefectTimeout());
				psmt.setLong(6, configInfo.getDistributedCon());
				psmt.setBoolean(7, configInfo.isPertitionMode());
				psmt.setBoolean(8, configInfo.isSyncMode());
				psmt.setTimestamp(9, new Timestamp(configInfo.getUpdateDate().getTime()));

				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}


	/**
	 * RtBO[Ve[u̍XVݓōXVB
	 * 
	 * @return	true:.false:s
	 * @since 3.0
	 */
	public boolean updateConfigDate() {

        boolean ret = true;
		String connectUrl = "";

		Timestamp tm = new Timestamp( System.currentTimeMillis() );
		
		//--------------
		// GSCXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("update,gsc,config.date"));
		
				psmt.setTimestamp(1, tm );

				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;


    }
	
	/**
	 * nbV֐폜
	 * 
	 * forest_server 炵ĂꂽID̃R[h폜
	 * @param id	NX
	 * @return	true:.false:s
	 */
	public boolean delHash(String id) {

		boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.hash"));
	
				smt.setString(1, id);
	
				smt.execute();
				smt.close();
	

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}
	/**
	 * nbV֐폜
	 * 
	 * forest_server 炵ĂꂽID̃R[h폜
	 * @param id	NX
	 * @return	true:.false:s
	 */
	public boolean delConfig(String id) {

		boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.config"));
	
				smt.setString(1, id);
	
				smt.execute();
				smt.close();
	

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}

	/**
	 *@T[oDBN̍폜
	 *
	 * w肳ꂽf[^x[XAT[oIDforest_servdb폜
	 *  
	 * @param dbName	f[^x[X
	 * @param serverId	T[oID
	 * @return	true:.false:s
	 */
	public boolean delServDb(String dbName, int serverId) {

		boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {

			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.servdb"));

				smt.setString(1, dbName);
				smt.setInt(2, serverId);
				smt.execute();

				smt.close();

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}

	/**
	 * T[oCX^Xo^
	 * 
	 * w肳ꂽzXgA|[gԍforest_server֒ǉB
	 * T[oID͊IDől+1
	 * 
	 * @param host	zXg
	 * @param port	|[gԍ
	 * @return	true:.false:s
	 */
	public boolean addServer(String host, String port) {


		boolean ret = true;
		String connectUrl = "";

		//--------------
		// serverURL
		//--------------
		String serverUrl = makeUrl(host, port, "");


		//--------------
		// ̃T[oID擾
		//--------------
		int nextServerId = 0;

		Connection conSelect = getSelectConnectoin();
		try{
			connectUrl = ((Jdbc3Connection) conSelect).getURL();

			Statement smt = conSelect.createStatement();

			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.server.maxserverid"));

			rs.next();
			if (rs.getInt("COUNT") > 0) {
				nextServerId = rs.getInt("MAX") + 1;
			}


			smt.close();


		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			return false;
		}



		//--------------
		// T[oXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.server"));
		
				psmt.setInt(1, nextServerId);
				psmt.setString(2, serverUrl.toString());
				psmt.setInt(3, SERVER_RUNNING);
				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}


		return ret;

	}

	/**
	 *@T[oDBN̓o^
	 * w肳ꂽf[^x[XAT[oIDforest_servdb֓o^
	 * 
	 * @param dbName	f[^x[X
	 * @param serverIdList	T[oID̃Xg
	 * @param serverIdList	T[oID̃Xg
	 * @return	true:.false:s
	 */
	public boolean addServDb(String dbName, Integer[] serverIdList) {


		boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {

			Connection con = (Connection) iter.next();
			try{
				connectUrl = ((Jdbc3Connection) con).getURL();
	
	
				PreparedStatement pSelectSmt =
					con.prepareStatement(
						m_sqlResource.getString("select.gsc.servdb.maxdbno"));
	
				PreparedStatement pInsertSmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.servdb"));
	
				for (int i = 0; i < serverIdList.length; i++) {
	
					
					if (serverIdList[i] == null) {
						continue;
					}
					//--------------
					// DBNO擾
					//--------------
					pSelectSmt.setString(1, dbName);
					ResultSet rs = pSelectSmt.executeQuery();
					int nextDbNo = 0;
					rs.next();
					if (rs.getInt("COUNT") > 0) {
						nextDbNo = rs.getInt("MAX") + 1;
					}
					rs.close();
	
					//--------------
					// T[oXV
					//--------------
					pInsertSmt.setInt(1, serverIdList[i].intValue());
					pInsertSmt.setString(2, dbName);
					pInsertSmt.setInt(3, nextDbNo);
					pInsertSmt.execute();
	
				}
	
				pSelectSmt.close();
				pInsertSmt.close();
	
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}
		}

		return ret;

	}

	/**
	 * p[eBVe[uݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAp[eBVɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * e[u̍XViforest_tablepart̍XVj
	 * p[eBV̍XViforest_partatrփR[h}j
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableInfo	p[eBVe[u
	 * @return
	 */
	public boolean setPartition(String dbName, TableInfo tableInfo, int partCount, String newHashName) {
		String connectUrl = "";
		
		String tableName = tableInfo.getName();

		//T[o
		ArrayList serverList = tableInfo.getServer();

		//T[o擾
		int serverCount = serverList.size();
		
		//J
		ArrayList columnList = tableInfo.getColumn();

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				// e[uڍ׏̍XV
				//--------------
				
				//forest_tablepartdtl폜
				PreparedStatement psmt = 
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.tablepartdtl"));
				psmt.setString(1, dbName);
				psmt.setString(2, tableName);
				psmt.execute();
				
				//forest_tablepartdtlɒǉ
				for (Iterator iterator = serverList.iterator();
					iterator.hasNext();
					) {
	
					ServerInfo svrPartInfo =
						(ServerInfo) iterator.next();

					for (int partNo = 0; partNo < partCount; partNo++) {
						//D揇擾
						int priority = getDbNo(svrPartInfo.getId(), dbName);
						priority = priority - partNo;
						if (priority < 0){
							priority = serverCount + priority;
						}
						psmt = con.prepareStatement(
							m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
						psmt.setInt(1, getDbNo(svrPartInfo.getId(), dbName));
						psmt.setString(2, dbName);
						psmt.setString(3, tableName);
						psmt.setInt(4, partNo);
						psmt.setInt(5, priority);
						psmt.execute();
					}
				}
				
				//--------------
				// e[u̍XV
				//--------------
				//p[eBVXV
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("update.gsc.tablepart"));
	
				psmt.setInt(1, partCount);
				psmt.setInt(2, tableInfo.getPartType());
				psmt.setString(3, newHashName);
				psmt.setString(4, dbName);
				psmt.setString(5, tableName);
				psmt.execute();
	
				//--------------
				// p[eBV̍XV
				//--------------
				//p[eBV}
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.partatr"));
	
				for (Iterator iterator = columnList.iterator();
					iterator.hasNext();
					) {
	
					ColumnInfo columnInfo = (ColumnInfo) iterator.next();
	
					if (columnInfo.isPartition()) {
						psmt.setString(1, dbName);
						psmt.setString(2, tableName);
						psmt.setString(3, columnInfo.getName());
						psmt.setInt(4, columnInfo.getNumber());
						psmt.setString(5, columnInfo.getType());
						psmt.execute();
					}
				}
	
				psmt.close();

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				return false;
			}


		}

		return true;


	}
	/**
	 * p[eBVe[uݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAp[eBVɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * e[u̍XViforest_tablepart̍XVj
	 * p[eBV̍XViforest_partatrփR[h}j
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableInfo	p[eBVe[u
	 * @return
	 */
	public boolean setPartition2(String dbName, TableInfo tableInfo, int partCount, String newHashName) {
		String connectUrl = "";
		
		String tableName = tableInfo.getName();
	
		//T[o
		ArrayList serverList = tableInfo.getServer();
	
		//T[o擾
		int serverCount = serverList.size();
		
		//J
		ArrayList columnList = tableInfo.getColumn();
	
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();
	
			try{
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				//--------------
				// e[uڍ׏̍XV
				//--------------
				
				//forest_tablepartdtl폜
				PreparedStatement psmt = 
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.tablepartdtl"));
				psmt.setString(1, dbName);
				psmt.setString(2, tableName);
				psmt.execute();
				
				int[] priorityList = new int[partCount];
				for (int i = 0; i < priorityList.length; i++) {
					priorityList[i] = 0;
					
				}
				
				
				//forest_tablepartdtlɒǉ
				for (Iterator iterator = serverList.iterator();
					iterator.hasNext();
					) {
	
					
					ServerPartition2Info svrPartInfo =
						(ServerPartition2Info) iterator.next();

					for (int partNo = 0; partNo < partCount; partNo++) {
						
						if( svrPartInfo.getMakeInstance(partNo).booleanValue() == false ){
							continue;
						}

						int priority = priorityList[partNo]++;
						
						psmt = con.prepareStatement(
							m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
						psmt.setInt(1, getDbNo(svrPartInfo.getId(), dbName));
						psmt.setString(2, dbName);
						psmt.setString(3, tableName);
						psmt.setInt(4, partNo);
						psmt.setInt(5, priority);
						psmt.execute();
					}
				
					
				}
				
				//--------------
				// e[u̍XV
				//--------------
				//p[eBVXV
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("update.gsc.tablepart"));
	
				psmt.setInt(1, partCount);
				psmt.setInt(2, tableInfo.getPartType());
				psmt.setString(3, newHashName);
				psmt.setString(4, dbName);
				psmt.setString(5, tableName);
				psmt.execute();
	
				//--------------
				// p[eBV̍XV
				//--------------
				//p[eBV}
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.partatr"));
	
				for (Iterator iterator = columnList.iterator();
					iterator.hasNext();
					) {
	
					ColumnInfo columnInfo = (ColumnInfo) iterator.next();
	
					if (columnInfo.isPartition()) {
						psmt.setString(1, dbName);
						psmt.setString(2, tableName);
						psmt.setString(3, columnInfo.getName());
						psmt.setInt(4, columnInfo.getNumber());
						psmt.setString(5, columnInfo.getType());
						psmt.execute();
					}
				}
	
				psmt.close();
	
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				return false;
			}
	
	
		}
	
		return true;
	
	
	}

	/**
	 * p[eBVe[uݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAp[eBVɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h폜j
	 * e[u̍XViforest_tablepart̍XVj
	 * p[eBV̍XViforest_partatrփR[h폜j
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableName	p[eBVe[u
	 * @param serverList	T[o񃊃Xg
	 * @return
	 */
	public boolean releasePartition(String dbName, String tableName, ArrayList serverList) {
		boolean ret = true;
		String connectUrl = "";

		//T[o
		int serverCount = serverList.size();
		
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				//e[uڍ׏̍XV
				//--------------
				
				//forest_tablepartdtl폜
				PreparedStatement psmt = 
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.tablepartdtl"));
				psmt.setString(1, dbName);
				psmt.setString(2, tableName);
				psmt.execute();
				
				//forest_tablepartdtlɒǉ			
				for (Iterator iterator = serverList.iterator();
					iterator.hasNext();
					) {
	
					ServerInfo svrInfo =
						(ServerInfo) iterator.next();

					//D揇擾
					psmt = con.prepareStatement(
						m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
					psmt.setInt(1, getDbNo(svrInfo.getId(),dbName));
					psmt.setString(2, dbName);
					psmt.setString(3, tableName);
					psmt.setInt(4, 0);
					psmt.setInt(5, 0);
					psmt.execute();
				}
				
				//--------------
				//e[u̍XV
				//--------------
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("update.gsc.tablepart"));
				
				psmt.setInt(1, 1);
				psmt.setInt(2, TableInfo.TYPE_MULTI);
				psmt.setString(3, null);
				psmt.setString(4, dbName);
				psmt.setString(5, tableName);
				psmt.execute();
				
				//--------------
				//p[eBV̍XV
				//--------------
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.partatr"));

				psmt.setString(1, dbName);
				psmt.setString(2, tableName);
				psmt.execute();

				psmt.close();

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

	
		return ret;
	}
	
	/**
	 * p[eBVe[uݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAp[eBVɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * e[u̍XViforest_tablepart̍XVj
	 * p[eBV̍XViforest_partatrփR[h}j
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableInfo	p[eBVe[u
	 * @return
	 * @since 2.0
	 */
	public boolean rePartition(String dbName, TableInfo tableInfo, int partCount) {
		String connectUrl = "";
		
		//e[u擾
		String tableName = tableInfo.getName();

		//T[o擾
		ArrayList serverList;
		try{
			serverList = getServerList(dbName);
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			return false;
		}
		
		//T[oCX^X擾
		int serverCount = serverList.size();
		
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				// e[uڍ׏̍XV
				//--------------
				//p[eBVNoݒ		
				PreparedStatement psmt = 
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.tablepartdtl"));
				psmt.setString(1, dbName);
				psmt.setString(2, tableName);
				psmt.execute();

				for (Iterator iterator = serverList.iterator();
					iterator.hasNext();
					) {
	
					ServerInfo serverInfo =
						(ServerInfo) iterator.next();

					for (int partNo = 0; partNo < partCount; partNo++) {
						//D揇擾
						int priority = getDbNo(serverInfo.getId(), dbName);
						priority = priority - partNo;
						if (priority < 0){
							priority = serverCount + priority;
						}
						psmt = con.prepareStatement(
							m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
						psmt.setInt(1, getDbNo(serverInfo.getId(), dbName));
						psmt.setString(2, dbName);
						psmt.setString(3, tableName);
						psmt.setInt(4, partNo);
						psmt.setInt(5, priority);
						psmt.execute();
					}
				}
				
				//--------------
				// e[u̍XV
				//--------------
				//p[eBVXV
				psmt =
					con.prepareStatement(
						m_sqlResource.getString("update.gsc.tablepart"));
	
				psmt.setInt(1, partCount);
				psmt.setInt(2, TableInfo.TYPE_PARTITION);
				psmt.setString(3, tableInfo.getHashName());
				psmt.setString(4, dbName);
				psmt.setString(5, tableName);
				psmt.execute();
	
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				return false;
			}
		}

		return true;
	}

	/**
	 * de[uݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAe[uɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * e[u̍XViforest_tablepart̍XVj
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableInfo	p[eBVe[u
	 * @return
	 */
	public boolean addTable(String dbName, String tableName) {

		boolean ret = true;
		String connectUrl = "";

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				//e[u
				//--------------
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.tablepart"));
	
				smt.setString(1, dbName);
				smt.setString(2, tableName);
				smt.execute();
	
				//--------------
				//e[uڍ׏
				//--------------
				smt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.tablepartdtl"));
	
				smt.setString(1, tableName);
				smt.setString(2, dbName);
				smt.execute();
	
				smt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}
		return ret;

	}

	/**
	 * de[uݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAe[uɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h폜j
	 * e[u̍XViforest_tablepart̍XVj
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableName	p[eBVe[u
	 * @return
	 */
	public boolean delTable(String dbName, String tableName) {

		boolean ret = true;
		String connectUrl = "";

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				//e[uڍ׏
				//--------------
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.tablepartdtl"));
	
				smt.setString(1, dbName);
				smt.setString(2, tableName);
				smt.execute();
	
				//--------------
				//e[u
				//--------------
				smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.tablepart"));
	
				smt.setString(1, dbName);
				smt.setString(2, tableName);
				smt.execute();
	
				smt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}
	
		}
		return ret;

	}
	/**
	 * T[o[擾
	 * @return
	 * @throws SQLException
	 */
	public ArrayList getServerList() throws SQLException {

		ArrayList servers = new ArrayList();
		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			Statement smt = con.createStatement();
	
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.server.status"));
	
			while (rs.next()) {
				ServerInfo srvInfo = new ServerInfo();
				srvInfo.setId(rs.getInt("SERVERID"));
				srvInfo.setStatus(rs.getInt("STATUS"));
				srvInfo.setChangeStatus(rs.getInt("STATUS"));
	
				Properties info = GSCdata.parseURL(rs.getString("URL"));
				srvInfo.setHost((String) info.getProperty("PGHOST",""));
				srvInfo.setPort((String) info.getProperty("PGPORT",""));
	
				srvInfo.setId(rs.getInt("SERVERID"));
	
				servers.add(srvInfo);
	
			}
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}

		return servers;
	}
	/**
	 * T[o[擾
	 * @return
	 * @throws SQLException
	 */
	public ArrayList getHashList() throws SQLException {
	
		ArrayList servers = new ArrayList();
		String connectUrl = "";
	
		Connection con =getSelectConnectoin(); 
	
		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			Statement smt = con.createStatement();
	
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.hash"));
	
			while (rs.next()) {
	
				servers.add(new HashInfo(rs.getString("NAME"),rs.getString("DESCRIPTION")));
	
			}
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
	
		return servers;
	}
	/**
	 * nbV֐NXC[W擾
	 * @return
	 * @throws SQLException
	 */
	public byte[] getHashImage(String hashName) throws SQLException {
	
		byte[] classImage = null;

		String connectUrl = "";
	
		Connection con =getSelectConnectoin(); 
	
		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			PreparedStatement psmt =
				con.prepareStatement(
					m_sqlResource.getString("select.gsc.hash.image"));

			psmt.setString(1, hashName);

			ResultSet rs = psmt.executeQuery();
			
			if (rs.next()) {
				classImage = rs.getBytes("CLASS");

			}
			
			psmt.close();

			return classImage;

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
	
	}

	/**
	 * T[o[擾
	 * @return
	 * @throws SQLException
	 */
	public ArrayList getConfigList() throws SQLException {
	
		ArrayList configList = new ArrayList();
		String connectUrl = "";
	
		Connection con =getSelectConnectoin(); 
	
		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			Statement smt = con.createStatement();
	
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.config"));
	
			while (rs.next()) {
				ConfigInfo configInfo = new ConfigInfo();
				configInfo.setConfigId(rs.getString("CONFIGID"));
				configInfo.setDescription(rs.getString("DESCRIPTION"));
				configInfo.setUpdateDate(new Date(rs.getTimestamp("UPDATE_DATE").getTime()));
				
			    // cache_reflesh | retry_count | defect_timeout | distributed_connection | pertition_mode | syncronize_mode |       update_date			
				//MASUCOMMENT configlSĎ擾
				configInfo.setCacheReflesh(rs.getLong("CACHE_REFLESH"));
				configInfo.setRetryCount(rs.getLong("RETRY_COUNT"));
				configInfo.setDefectTimeout(rs.getLong("DEFECT_TIMEOUT"));
				configInfo.setDistributedCon(rs.getInt("DISTRIBUTED_CONNECTION"));
				configInfo.setPertitionMode(rs.getBoolean("PERTITION_MODE"));
				configInfo.setSyncMode(rs.getBoolean("SYNCRONIZE_MODE"));
				
				configList.add(configInfo);
	
				
			}
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
	
		return configList;
	}
	//MASUCOMMENT BrokenLogł̒ǉ\bh
	/**
	 * Broken_Log擾
	 * @return
	 * @throws SQLException
	 * @auther tm364458
	 */
	public ArrayList getBrokenLogList() throws SQLException {
	
		ArrayList brokenLogList = new ArrayList();
		String connectUrl = "";
	
		Connection con = getSelectConnectoin(); 
	
		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			Statement smt = con.createStatement();
	
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.broken_log"));
	
			while (rs.next()) {
				BrokenLogInfo brokenLogInfo = new BrokenLogInfo();
				brokenLogInfo.setServerid(rs.getInt("serverid"));
				brokenLogInfo.setDatetime(new Date(rs.getTimestamp("datetime").getTime()));
				brokenLogInfo.setClient(rs.getString("client"));
				brokenLogInfo.setMsg(rs.getString("msg"));
				brokenLogInfo.setStatus(rs.getString("status"));
				brokenLogInfo.setQuery(rs.getString("query"));
				brokenLogInfo.setServerUrl(rs.getString("url"));
				
				brokenLogList.add(brokenLogInfo);	
			}
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
	
		return brokenLogList;
	}
	/**
	 * RtBO擾
	 * @return
	 * @throws SQLException
	 */
	public ConfigInfo getConfigInfo(String id) throws SQLException {
	
		ConfigInfo configInfo = new ConfigInfo();

		String connectUrl = "";
	
		Connection con =getSelectConnectoin(); 
	
		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			PreparedStatement psmt =
				con.prepareStatement(
					m_sqlResource.getString("select.gsc.config.detail"));

			psmt.setString(1, id);

			ResultSet rs = psmt.executeQuery();
			
			if (rs.next()) {
				configInfo.setConfigId(rs.getString("CONFIGID"));
				configInfo.setDescription(rs.getString("DESCRIPTION"));

				configInfo.setCacheReflesh(rs.getInt("CACHE_REFLESH"));
				configInfo.setDefectTimeout(rs.getInt("DEFECT_TIMEOUT"));
				configInfo.setDistributedCon(rs.getInt("DISTRIBUTED_CONNECTION"));
				configInfo.setRetryCount(rs.getInt("RETRY_COUNT"));

				configInfo.setPertitionMode(rs.getBoolean("PERTITION_MODE"));
				configInfo.setSyncMode(rs.getBoolean("SYNCRONIZE_MODE"));

			}
			
			psmt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
	
		return configInfo;
	}
	/**
	 * BrokenLog擾
	 * @return
	 * @throws SQLException
	 * 
	 * 
	 */
	public BrokenLogInfo getBrokenLogInfo(String serverid) throws SQLException {
	
		BrokenLogInfo brokenLogInfo = new BrokenLogInfo();

		String connectUrl = "";
	
		Connection con =getSelectConnectoin(); 
	
		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			PreparedStatement psmt =
				con.prepareStatement(
					m_sqlResource.getString("select.gsc.brokenlog.detail"));

			psmt.setString(1, serverid);

			ResultSet rs = psmt.executeQuery();
			
			if (rs.next()) {
				brokenLogInfo.setServerid(rs.getInt("SERVERID"));
				brokenLogInfo.setDatetime(new Date(rs.getTimestamp("DATETIME").getTime()));
				brokenLogInfo.setClient(rs.getString("CLIENT"));
				brokenLogInfo.setMsg(rs.getString("MSG"));
				brokenLogInfo.setStatus(rs.getString("STATUS"));
				brokenLogInfo.setQuery(rs.getString("QUERY"));
				brokenLogInfo.setServerUrl(rs.getString("URL"));
			}
			
			psmt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
	
		return brokenLogInfo;
	}

	/**
	 * T[o[擾
	 * 
	 * w肳ꂽT[oIDŃT[o擾
	 * 
	 * @param ServerId	T[oID
	 * @return	T[o񃊃Xg
	 * @throws SQLException
	 */
	public ArrayList getServerList(Integer[] ServerId) throws SQLException {

		String connectUrl = "";
		ArrayList servers = new ArrayList();

		Connection con =getSelectConnectoin(); 

		try {
			connectUrl = ((Jdbc3Connection) con).getURL();

			PreparedStatement smt =	con.prepareStatement(m_sqlResource.getString("select.gsc.server"));

			for (int i = 0; i < ServerId.length; i++) {

				if (ServerId[i] == null){
					continue;
				}

				smt.setInt(1, ServerId[i].intValue());
				ResultSet rs = smt.executeQuery();

				rs.next();
				ServerInfo srvInfo = new ServerInfo();
				srvInfo.setId(rs.getInt("SERVERID"));
				srvInfo.setStatus(rs.getInt("STATUS"));

				Properties info = GSCdata.parseURL(rs.getString("URL"));
				srvInfo.setHost((String) info.get("PGHOST"));
				srvInfo.setPort((String) info.get("PGPORT"));

				srvInfo.setId(rs.getInt("SERVERID"));

				servers.add(srvInfo);

			}
			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}

		return servers;
	}

	/**
	 * 
	 * T[o[擾
	 * 
	 * w肳ꂽDBɊ֘AtꂽT[o擾
	 * 
	 * @param dbName	f[^x[X
	 * @return	T[o񃊃Xg
	 * @throws SQLException
	 */
	public ArrayList getServerList(String dbName) throws SQLException {

		ArrayList servers = new ArrayList();
		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();

			PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.server.bydbname"));

			smt.setString(1, dbName);
			ResultSet rs = smt.executeQuery();

			while (rs.next()) {
				ServerInfo srvInfo = new ServerInfo();
				srvInfo.setId(rs.getInt("SERVERID"));
				srvInfo.setStatus(rs.getInt("STATUS"));

				Properties info = GSCdata.parseURL(rs.getString("URL"));
				srvInfo.setHost((String) info.get("PGHOST"));
				srvInfo.setPort((String) info.get("PGPORT"));

				srvInfo.setId(rs.getInt("SERVERID"));

				servers.add(srvInfo);

			}

			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}

		return servers;
	}

	/**
	 *  DB-T[õN𐶐
	 * 
	 * T[oDBN擾āA
	 * T[o񃊃XgDBŕRt
	 * f[^x[X[T[o@NNX̃Xg𐶐
	 * 
	 * @param serverList	T[o񃊃Xg
	 * @return
	 * @throws SQLException
	 * @throws Exception
	 */
	public ArrayList getDbLinkList(ArrayList serverList)
		throws SQLException {

		String connectUrl = "";

		ArrayList dbInfoList = new ArrayList();
		Connection con =getSelectConnectoin(); 

		try {
			connectUrl = ((Jdbc3Connection) con).getURL();

			Statement smt = con.createStatement();
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.servdb.dblist"));

			String dbName = "";
			DbLinkInfo dbinfo = null;

			while (rs.next()) {
				String dbNameWk = rs.getString("DBNAME");
				if (dbNameWk.compareToIgnoreCase(dbName) != 0) {
					dbName = dbNameWk;
					dbinfo = new DbLinkInfo();
					dbinfo.setName(dbName);
					dbinfo.setServer(new ArrayList());
					dbInfoList.add(dbinfo);

				}

				//--------------
				//T[oƕRt
				//--------------
				int serverId = rs.getInt("SERVERID");
				ArrayList dbServerList = dbinfo.getServer();
				for (Iterator iter = serverList.iterator(); iter.hasNext();) {
					ServerInfo serverInfo = (ServerInfo) iter.next();
					if (serverInfo.getId() == serverId) {
						ServerInfo dbServer = new ServerInfo();
						dbServer.setHost(serverInfo.getHost());
						dbServer.setPort(serverInfo.getPort());
						dbServer.setId(serverInfo.getId());
						dbServer.setStatus(serverInfo.getStatus());
						dbServer.setChangeStatus(serverInfo.getChangeStatus());
						dbServer.setChkFlag(serverInfo.isChkFlag());
						dbServerList.add(dbServer);
						break;
					}
				}

			}

			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}


		return dbInfoList;
	}

	/**
	 * e[uꗗ擾
	 * 
	 * w肳ꂽDB̃e[üꗗ𐶐
	 * 
	 * @param dbName	f[^x[X
	 * @param serverList	T[o񃊃Xg
	 * @return
	 * @throws SQLException
	 * @throws Exception
	 */
	public ArrayList getTableList(String dbName )
		throws SQLException  {

		ArrayList tableList = new ArrayList();


		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();

			PreparedStatement smt =	con.prepareStatement(m_sqlResource.getString("select.gsc.table"));

			smt.setString(1, dbName);
			ResultSet rs = smt.executeQuery();

			String tableName = "";

			TableInfo tableInfo = null;

			while (rs.next()) {
					tableInfo = new TableInfo();
					tableInfo.setName(rs.getString("TABLE_NAME"));
					tableInfo.setServer(new ArrayList());
					tableInfo.setPartCount(rs.getInt("PART_COUNT"));
					tableInfo.setPartType(rs.getInt("PART_TYPE"));
					tableInfo.setHashName(rs.getString("HASH_NAME"));
					//TODOMASU Xe[^Xǉ
					tableInfo.setStatus(rs.getInt("STATUS"));
					tableList.add(tableInfo);

			}

			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}


		return tableList;
	}

	/**
	 * p[eBV擾
	 * 
	 *	f[^x[XAe[u炻̃p[eBV擾 
	 * 
	 * @param dbName	f[^x[X
	 * @param tableName	e[u
	 * @return	p[eBṼXg
	 * @throws SQLException
	 */
	public ArrayList getPartitionColumn(String dbName, String tableName)
		throws SQLException  {

		ArrayList columnList = new ArrayList();

		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();

			PreparedStatement smt =	con.prepareStatement(m_sqlResource.getString("select.gsc.partatr"));

			smt.setString(1, dbName);
			smt.setString(2, tableName.toLowerCase());
			ResultSet rs = smt.executeQuery();

			while (rs.next()) {
				ColumnInfo columnInfo = new ColumnInfo();
				columnInfo.setName(rs.getString("COLUMN_NAME"));
				columnInfo.setNumber(rs.getInt("COLUMN_NO"));
				columnInfo.setPartition(true);
				columnInfo.setType(rs.getString("COLUMN_TYPE"));
				columnList.add(columnInfo);
			}

			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}


		return columnList;
	}

	/**
	 * f[^x[Xꗗ̎擾
	 * @return
	 */
	public ArrayList getDbList()  {

		ArrayList dbList = new ArrayList();

		try {

			Statement smt = getSelectConnectoin().createStatement();
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.servdb.db"));

			String dbName = "";
			DbLinkInfo dbinfo = null;

			while (rs.next()) {
				dbList.add(rs.getString("DBNAME"));

			}


		} catch (SQLException e) {
		}

		return dbList;
	}

	/**
	 * p[eBV擾
	 * 
	 *	f[^x[XAe[u炻̃p[eBV擾 
	 * 
	 * @param dbName	f[^x[X
	 * @param tableName	e[u
	 * @return	p[eBV
	 * @throws SQLException
	 */
	public int getPartitionCount(
		String dbName,
		String tableName) throws SQLException {

		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		int partCount = 0;

		try {
			connectUrl = ((Jdbc3Connection) con).getURL();

			PreparedStatement smt =
			getSelectConnectoin().prepareStatement(
					m_sqlResource.getString("select.gsc.tablepart.partcount"));

			smt.setString(1, dbName);
			smt.setString(2, tableName.toLowerCase());

			ResultSet rs = smt.executeQuery();
			if (rs.next()) {
				partCount = rs.getInt("PART_COUNT");

			}

			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}


		return partCount;
	}

	/**
	 * O[oVXeJ^O̍XV
	 * <pre>
	 * T[ȍԃtȌᒆɐݒ肳ĂꍇA
	 * YtOύX
	 * </pre>
	 * @param id
	 */
	public boolean setDBstatus(ArrayList serverList) {

		boolean ret = true;
		String connectUrl = "";
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();
			
			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("update.gsc.server.status"));
					
					for (Iterator iter2 = serverList.iterator(); iter2.hasNext();) {
						ServerInfo serverInfo = (ServerInfo) iter2.next();

						smt.setInt(1, serverInfo.getChangeStatus());
						smt.setInt(2, serverInfo.getId());
						smt.execute();

				}
				smt.close();


			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;
	}



	/**
	 * GSC擾
	 * @return
	 * @throws SQLException
	 * @since 2.0
	 */
	public ArrayList getGscList() throws SQLException {

		ArrayList servers = new ArrayList();
		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			Statement smt = con.createStatement();
	
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.gsc"));
	
			while (rs.next()) {
				GSCInfo gscInfo = new GSCInfo();
				gscInfo.setId(rs.getInt("SERVERID"));
				gscInfo.setDb(rs.getString("DBNAME"));
				Properties info = GSCdata.parseURL(rs.getString("URL"));
				gscInfo.setHost((String) info.getProperty("PGHOST",""));
				gscInfo.setPort((String) info.getProperty("PGPORT",""));
				gscInfo.setStatus(rs.getInt("STATUS"));
				servers.add(gscInfo);
			}
			
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}

		return servers;
	}

	/**
	 * GSCXV
	 * @return
	 * @since 2.0
	 */
	public boolean updateGscServer() {
		boolean ret = false;
		
		try{
			//GSC擾	
			ArrayList gscList = getGscList();
			
			//ڑ񃊃XgNA
			clearServers();
		
			//GSCNXGSCݒ
			if (gscList != null){
				for (int i = 0; i < gscList.size(); i++) {
					GSCInfo gscinfo = (GSCInfo)gscList.get(i);
					String hostName = gscinfo.getHost();
					String portNo = gscinfo.getPort();
					String dbName = gscinfo.getDb();
					int status = gscinfo.getStatus();
					if(dbName.compareTo("") != 0){
						addUrl(hostName, portNo, dbName);
					}
				}
			}
			ret = true;
		} catch (SQLException e) {
			ret = false;
		}
		
		return ret;
	}
	
	/**
	 * GSCCX^Xo^
	 * 
	 * w肳ꂽDBƃT[oIDforest_gsc֒ǉB
	 * 
	 * @param dbname	DB
	 * @param serverid	T[oID
	 * @return	true:.false:s
	 * @since 2.0
	 */
	public boolean addGscServer(int serverid, String dbname) {

		boolean ret = true;
		String connectUrl = "";

		//--------------
		// GSCXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.gsc"));
		
				psmt.setInt(1, serverid);
				psmt.setString(2, dbname);
				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}
	
	/**
	 * GSCCX^Xo^
	 * 
	 * w肳ꂽzXgA|[gԍforest_server֒ǉB
	 * T[oID͊IDől+1
	 * zXgAT[oIDforest_gsc֒ǉB
	 * 
	 * @param host	zXg
	 * @param port	|[gԍ
	 * @return	true:.false:s
	 * @since 2.0
	 */
	public boolean addGscServer(String dbname, String host, String port) {


		boolean ret = true;
		String connectUrl = "";

		//--------------
		// serverURL
		//--------------
		String serverUrl = makeUrl(host, port, "");


		//--------------
		// ̃T[oID擾
		//--------------
		int nextServerId = 0;

		Connection conSelect = getSelectConnectoin();
		try{
			connectUrl = ((Jdbc3Connection) conSelect).getURL();

			Statement smt = conSelect.createStatement();

			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString("select.gsc.server.maxserverid"));

			rs.next();
			if (rs.getInt("COUNT") > 0) {
				nextServerId = rs.getInt("MAX") + 1;
			}


			smt.close();


		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			return false;
		}



		//--------------
		// T[oXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.server"));
		
				psmt.setInt(1, nextServerId);
				psmt.setString(2, serverUrl.toString());
				psmt.setInt(3, SERVER_RUNNING);
				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}
		
		//--------------
		// GSCXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("insert.gsc.gsc"));
		
				psmt.setInt(1, nextServerId);
				psmt.setString(2, dbname);
				psmt.execute();
		
				psmt.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}
	
	/**
	 * GSCCT[gpSQL擾
	 * 
	 * GSCGSC擾ACT[gpSQL擾B
	 * 
	 * @return	ArrayList:CT[gpSQLXg
	 * @throws SQLException
	 * @since 2.0
	 */
	public ArrayList getGscInsertSql() throws SQLException {
		
		ArrayList sqlList = new ArrayList();

		try{

			//--------------------------------------
			// forest_hashe[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.hash.all", 
								   "insert.gsc.hash.copy");

			//--------------------------------------
			// forest_confige[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.config.all", 
								   "insert.gsc.config.copy");

			//--------------------------------------
			// forest_servere[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
                                   "select.gsc.server.all", 
                                   "insert.gsc.server.copy");
			
			//--------------------------------------
			// forest_servdbe[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.servdb.all", 
								   "insert.gsc.servdb.copy");
			
			//--------------------------------------
			// forest_tableparte[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.tablepart.all", 
								   "insert.gsc.tablepart.copy");
								   
			//--------------------------------------
			// forest_tablepartdtle[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.tablepartdtl.all", 
								   "insert.gsc.tablepartdtl.copy");
			
			//--------------------------------------
			// forest_partatre[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.partatr.all", 
								   "insert.gsc.partatr.copy");
			
			//--------------------------------------
			// forest_gsce[ũCT[gSQL쐬
			//--------------------------------------
			sqlList = getInsertSql(sqlList, 
								   "select.gsc.gsc.all", 
								   "insert.gsc.gsc.copy");

			
			
		} catch (SQLException e) {
			throw e;
		}

		return sqlList;
	}

	/**
	 * CT[gpSQL擾
	 * 
	 * pSQĽʂɁACT[gpSQL擾B
	 * 
	 * @param sqlList		CT[gpSQLXg
	 * @param sqlSelect	pSQL
	 * @param sqlInsert	INSERTpSQL
	 * @return	ArrayList:CT[gpSQLXg
	 * @throws SQLException
	 * @since 2.0
	 */
	public ArrayList getInsertSql(ArrayList sqlList,
	                               String sqlSelect,
	                               String sqlInsert) throws SQLException {

		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
			Statement smt = con.createStatement();
	
			//--------------------------------------
			// e[ũCT[gSQL쐬
			//--------------------------------------
			ResultSet rs =
				smt.executeQuery(
					m_sqlResource.getString(sqlSelect));

			ResultSetMetaData md = rs.getMetaData();
			int colCount = md.getColumnCount();
			
			while (rs.next()) {
				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString(sqlInsert));
		
				for (int i = 1; i <= colCount; i++) {
					psmt.setObject(i, rs.getObject(i));
				}
				String sql = psmt.toString();
				sqlList.add(sql);
			}
			rs.close();
			
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}

		return sqlList;
	}

	/**
	 * GSCCT[gpSQLs
	 * 
	 * GSCCT[gpSQLsB
	 * 
	 * @param sqlList	CT[gpSQLXg
	 * @return	true:.false:s
	 * @since 2.0
	 */
	public boolean setGscInsertSql(ArrayList sqlList) {
		boolean ret = true;
		String connectUrl = "";

		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();
	
			//--------------------------------------
			// GSCCT[gpSQLs
			//--------------------------------------
			for (Iterator iter = sqlList.iterator(); iter.hasNext();) {
				String sql = (String)iter.next();
				PreparedStatement smt =
					con.prepareStatement(sql);
				smt.execute();
				smt.close();
			}
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			ret = false;
		}

		return ret;
	}
	
	/**
	 * GSCCX^X폜
	 * 
	 * forest_server w肳ꂽID̃R[h폜
	 * forest_gsc w肳ꂽIDDB̃R[h폜
	 * 
	 * @param id	T[oID
	 * @param dbName	DB
	 * @return	true:.false:s
	 * @since 2.0
	 */
	public boolean delGscServer(int id, String dbName) {

		boolean ret = true;
		String connectUrl = "";

		//--------------
		// GSCXV
		//--------------
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				PreparedStatement smt =
					con.prepareStatement(
						m_sqlResource.getString("delete.gsc.gsc"));
	
				smt.setInt(1, id);
				smt.setString(2, dbName);
	
				smt.execute();
				smt.close();
	

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}
		
		return ret;
	}
	
	/**
	 * D揇ꗗ擾
	 * 
	 * w肳ꂽe[u̗D揇ꗗ𐶐
	 * 
	 * @param dbName		f[^x[X
	 * @param tableName	e[u
	 * @param serverList	T[o񃊃Xg
	 * @return
	 * @throws SQLException
	 * @throws Exception
	 * @since 2.0
	 */
	public ArrayList getPriorityList(String dbName, String tableName, ArrayList serverList)
		throws SQLException  {

		String connectUrl = "";
		
		//p[eBV̎擾
		int partCount = getPartitionCount(dbName, tableName);
		
		ArrayList priorityList = new ArrayList();
		
		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();

			for (Iterator iter = serverList.iterator(); iter.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iter.next();
				int serverId = serverInfo.getId();
				
				ServerPriorityInfo serverPriorityInfo = new ServerPriorityInfo();
				serverPriorityInfo.setId(serverInfo.getId());
				serverPriorityInfo.setHost(serverInfo.getHost());
				serverPriorityInfo.setPort(serverInfo.getPort());
				serverPriorityInfo.setStatus(serverInfo.getStatus());
				serverPriorityInfo.setChangeStatus(serverInfo.getChangeStatus());
				
				PreparedStatement smt =	
					con.prepareStatement(m_sqlResource.getString("select.gsc.priority"));
				smt.setInt(1, serverId);
				smt.setString(2, dbName);
				smt.setString(3, tableName);
				ResultSet rs = smt.executeQuery();
				
				//TODOMASU PriorityInfo beanɃe[uXy[Xǉ
				//TODOMASU ܂́AYDBɐڑ
				
				DbBase dbBase = new DbBase(m_prop.getProperty("user"), m_prop.getProperty("password"));
				dbBase.addUrl(serverPriorityInfo.getHost(), serverInfo.getPort(), dbName );
				dbBase.connect(false);
				Connection targetDBCon = dbBase.getSelectConnectoin();
				PreparedStatement targetDBsmt =	
					targetDBCon.prepareStatement(m_sqlResource.getString("select.tablespace"));
				
				
				int i = 0;
				while (rs.next()) {
					PriorityInfo priorityInfo = new PriorityInfo();
					priorityInfo.setPartitionNo(rs.getInt("PART_NO"));
					priorityInfo.setPriority(new Integer(rs.getInt("PRIORITY")));
					targetDBsmt.setString(1, tableName + "_" + m_dcFmt.format(priorityInfo.getPartitionNo().intValue()));
					targetDBsmt.execute();
					ResultSet targetDBrs = targetDBsmt.getResultSet();
					String tblSpaceName = null;
					if(targetDBrs.next()){
						tblSpaceName = targetDBrs.getString("TABLESPACE");
					}
					if(tblSpaceName == null){
						tblSpaceName = "";
					}
					priorityInfo.setTableSpaceName(tblSpaceName);
					serverPriorityInfo.addPartition(priorityInfo);
					targetDBrs.close();
					i++;
				}
				priorityList.add(serverPriorityInfo);
				rs.close();
				smt.close();
				targetDBsmt.close();
				dbBase.close();
				
			}
		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
			throw e;
		}
		return priorityList;
	}
	
	/**
	 * D揇ݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̃e[uɑ΂āAD揇ɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * </pre>
	 * @param dbName	f[^x[X
	 * @param tableName	e[u
	 * @param serverList	T[o񃊃Xg
	 * @return
	 */
	public boolean setPriority(String dbName, String tableName, ArrayList serverList) {
		String connectUrl = "";
		
		int serverCount = serverList.size();

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				// e[uڍ׏̍XV
				//--------------
				//D揇ݒ		
				for (Iterator iterator = serverList.iterator(); iterator.hasNext();) {
					ServerPriorityInfo svrPriorityInfo =
						(ServerPriorityInfo) iterator.next();
					ArrayList priorityList = svrPriorityInfo.getPartition();
					for (int i = 0; i < priorityList.size(); i++) {
						PriorityInfo priorityInfo =	(PriorityInfo)priorityList.get(i);
						
						PreparedStatement psmt = 
							con.prepareStatement(
								m_sqlResource.getString("update.gsc.tablepartdtl.partition"));
						psmt.setInt(1, priorityInfo.getPriority().intValue());
						psmt.setInt(2, priorityInfo.getPartitionNo().intValue());
						psmt.setString(3, dbName);
						psmt.setString(4, tableName);
						psmt.setString(5, dbName);
						psmt.setInt(6, svrPriorityInfo.getId());
						psmt.execute();
						psmt.close();
					}
				}
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				return false;
			}
		}
		return true;
	}

	/**
	 * e[u(DBǉ)ݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAe[uɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * e[u̍XViforest_tablepart̍XVj
	 * </pre>
	 * @param dbName		f[^x[X
	 * @param serverIdList	T[oIDXg
	 * @return
	 * @since 2.0
	 */
	public boolean setDbAdd(String dbName, Integer[] serverIdList) {
		String connectUrl = "";
		
		ArrayList tableList;
		try{
			//e[u
			tableList = getTableList(dbName);
		} catch (SQLException e) {
			return false;
		} catch (Exception e) {
			return false;
		}
		
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				//--------------
				// e[uڍ׏̍XV
				//--------------
				for (Iterator iterator = tableList.iterator(); iterator.hasNext();) {
					TableInfo tableInfo = (TableInfo) iterator.next();
					String tableName = tableInfo.getName();
					for (int i = 0; i < serverIdList.length; i++) {
						if (serverIdList[i] == null) {
							continue;
						}
						
						//--------------
						// ̃p[eBVNo(D揇)擾
						//--------------
						if (tableInfo.getPartType() == 0) {	//de[u
							//--------------
							// e[uڍ׏֒ǉ
							//--------------
							PreparedStatement smt = 
								con.prepareStatement(
									m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));			
							////smt.setInt(1, serverIdList[i].intValue());
							smt.setInt(1, getDbNo(serverIdList[i].intValue(), dbName));
							smt.setString(2, dbName);
							smt.setString(3, tableName);
							smt.setInt(4, 0);
							smt.setInt(5, 0);
							smt.execute();
							smt.close();
						}
						else if (tableInfo.getPartType() == 1) {	//p[eBVe[u
							for (int partNo = 0; partNo < tableInfo.getPartCount(); partNo++) {
								int nextPriority = 0;
								
								PreparedStatement smt =
									con.prepareStatement(
										m_sqlResource.getString("select.gsc.tablepartdtl.max"));
			
								smt.setString(1, dbName);
								smt.setString(2, tableName);
								smt.setInt(3, partNo);
								ResultSet rs = smt.executeQuery();
								rs.next();
								if (rs.getInt("COUNT") > 0) {
									nextPriority = rs.getInt("MAX") + 1;
								}
								smt.close();
								rs.close();
								
								//--------------
								// e[uڍ׏֒ǉ
								//--------------
								smt = con.prepareStatement(
									m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
								////								smt.setInt(1, serverIdList[i].intValue());
								smt.setInt(1, getDbNo(serverIdList[i].intValue(), dbName));
								smt.setString(2, dbName);
								smt.setString(3, tableName);
								smt.setInt(4, partNo);
								smt.setInt(5, nextPriority);
								smt.execute();
								smt.close();
							}
						}
					}
				}
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				return false;
			}
		}
		return true;
	}
	
	/**
	 * e[u(DBڍs)ݒ
	 * 
	 * <pre>
	 * w肳ꂽDB̏ɑ΂āAe[uɊÂĈȉ̏sB
	 * e[uڍ׏̍XViforest_tablepartdtlփR[h}j
	 * e[u̍XViforest_tablepart̍XVj
	 * </pre>
	 * @param dbName		f[^x[X
	 * @param tableList	e[u񃊃Xg
	 * @param serverList	T[o񃊃Xg
	 * @return
	 * @since 2.0
	 */
	public boolean setDbShift(String dbName, ArrayList tableList, ArrayList serverList) {
		String connectUrl = "";
		
		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try{
				connectUrl = ((Jdbc3Connection) con).getURL();

				for (int i = 0; i < tableList.size() ; i++) {
					String tableName = (String) tableList.get(i);
					
					//--------------
					// e[u֒ǉ
					//--------------
					//p[eBVXV
					PreparedStatement smt =
						con.prepareStatement(
							m_sqlResource.getString("insert.gsc.tablepart"));
					smt.setString(1, dbName);
					smt.setString(2, tableName);
					smt.execute();
					smt.close();

					for (Iterator iterator = serverList.iterator(); iterator.hasNext();) {
						ServerInfo serverInfo = (ServerInfo) iterator.next();
						
						//--------------
						// e[uڍ׏֒ǉ
						//--------------
						smt = con.prepareStatement(
							m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
						////smt.setInt(1, serverInfo.getId());
						smt.setInt(1, getDbNo(serverInfo.getId(), dbName));
						smt.setString(2, dbName);
						smt.setString(3, tableName);
						smt.setInt(4, 0);
						smt.setInt(5, 0);
						smt.execute();
						smt.close();
					}
				}
				
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				return false;
			}
		}
		return true;
	}
	
	/**
	 * f[^x[XNo̎擾
	 * @param serverId		T[oID
	 * @param dbName		DB
	 * @return
	 * @since 2.0
	 */
	public int getDbNo(int serverId, String dbName)  {
		String connectUrl = "";
		int dbNo = -1;
		Connection con =getSelectConnectoin(); 

		try{
			connectUrl = ((Jdbc3Connection) con).getURL();

			PreparedStatement smt =
				con.prepareStatement(
					m_sqlResource.getString("select.gsc.servdb.dbno"));
			smt.setInt(1, serverId);
			smt.setString(2, dbName);
			ResultSet rs = smt.executeQuery();

			while (rs.next()) {
				dbNo = rs.getInt("DBNO");
			}
			rs.close();
			smt.close();

		} catch (SQLException e) {
			setErrInfo(connectUrl, e);
		}

		return dbNo;
	}
    /* ( Javadoc)
     * @see org.postgresforest.tool.db.DbBase#connect(boolean)
     */
    public boolean connect(boolean autocommit) {
        boolean ret = super.connect(autocommit);
        if(!ret){
            
            ret = removeGsc();
        }

        
		return ret;

    }

    
    /**
     * @param ret
     * @return
     * @since 
     */
    private boolean removeGsc() {
        boolean ret = false;

        if(m_servers.size() <= 1){
            return ret;
        }
        
        StringBuffer errUrls =  new StringBuffer();
        for (Iterator iter = m_errInfoList.iterator(); iter.hasNext();) {
            ErrInfo element = (ErrInfo) iter.next();
            errUrls.append(element.getUrl());
            errUrls.append("\n");
            
        }
//        boolean removeGsc = MsgDialogUtil.question(Messages.getString("GSCɐڑł܂łB\n{0}\nΏۂ珜O܂B",errUrls.toString()));
        boolean removeGsc = true;
        System.out.println(MessagesCommandLine.getString("GSCɐڑł܂łB\n{0}\nΏۂ珜O܂B"));
        if(removeGsc){
            ArrayList removeList = new ArrayList();
            for (Iterator iter = m_errInfoList.iterator(); iter.hasNext();) {
                ErrInfo element = (ErrInfo) iter.next();
                
                String errUrl = element.getUrl();
                
        		for (Iterator iter2 = m_servers.iterator(); iter2.hasNext();) {
        			UrlInfo url = (UrlInfo) iter2.next();
        			String connetStr = PROTOCOL + makeUrl(url);
        			
        			//f[^\[Xւ̃RlNVm
        			if( errUrl.equals(connetStr) ){
        			    removeList.add(url);
        			    //m_servers.remove(url);
        			    
        			}
        		}
            }
            m_servers.removeAll(removeList);
            clearErrInfoList();
            ret = true;
        }
        return ret;
    }

    /* ( Javadoc)
     * @see org.postgresforest.tool.db.DbBase#connectTemplate()
     */
    public boolean connectTemplate() {
        boolean ret = super.connectTemplate();
        if(!ret){
            
            ret = removeGsc();
        }

        
		return ret;

    }

    
    /* ( Javadoc)
     * @see org.postgresforest.tool.db.DbBase#connectSELECT()
     */
    public boolean connectSELECT() {
        
        boolean ret = super.connectSELECT();
        if(!ret){
                        
            ret = removeGsc();
            if(ret){
                ret = connectSELECT();
            }
            
        }
        
        return ret;
    }
    
    
    //TODOMASU BrokenLogǉ邱Ƃ͖
//    public boolean addBrokenLog(BrokenLogInfo brokenLogInfo){
//    	return false;
//    }
    
    public boolean delBrokenLog(String serverID, Date datetime){
    	
    	boolean ret = true;
		String connectUrl = "";


		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				PreparedStatement smt =
					con.prepareStatement(
							//TODOMASU delete.gsc.brokenlogSQL.propertiest@CɎw肷
						m_sqlResource.getString("delete.gsc.brokenlog"));
	
				smt.setString(1, serverID);
				smt.setTimestamp(2, new Timestamp(datetime.getTime()));
	
				smt.execute();
				smt.close();
	

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;
    }
    public boolean delBrokenLog(int serverID, Date datetime){
    	boolean ret = false;
    	ret = delBrokenLog(Integer.toString(serverID), datetime);
    	return ret;
    }
    
}
