/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewPluginAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.SessionProperty;

//import org.eclipse.ui.views.

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
abstract public class ViewBase extends ViewPart {


	/**
	 * 
	 */
	public ViewBase() {
		super();
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {

	}
	
	//\XV
	abstract public void update();


	/**
	 * Adapter󂯓n
	 * 
	 */
	public Object getAdapter(Class cls) {
//		 ̃GfB^ɃvpeBEV[gET|[gǉ邩ǂ
	    if(cls.equals(IPropertySheetPage.class)) { // ?@
	      return new PropertySheetPage();
	    }
	    // KX[p[NX̃\bhĂ
	    return super.getAdapter(cls);
//		if ( cls.isInstance(this) ) {
//			return this;
//		} else {
//			return super.getAdapter(cls);
//		}
	}

	/**
	 * 
	 * @since
	 */
    protected boolean isLogin() {
        return getGsc() == null?false:true;
    }

	/**
	 * 
	 * @return
	 * @since
	 */
    protected GSCdata getGsc() {
        return (GSCdata)SessionProperty.get("gsc");
    }

    /**
     * @param enable
     */
    protected void setEnabledAction(String actionID, boolean enable) {
    	PluginActionContributionItem ci = (PluginActionContributionItem)getViewSite().getActionBars().getToolBarManager().find(actionID);
    	IAction action =  ci.getAction();
    	action.setEnabled(enable);
    }

    /**
     * 
     * @since 
     */
    protected void setEnabledActionAll(boolean enable) {
        IToolBarManager tm = (IToolBarManager)getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] cis = tm.getItems();
        
        for (int i = 0; i < cis.length; i++) {
        	if (cis[i] instanceof PluginActionContributionItem) {
        		PluginActionContributionItem ci = (PluginActionContributionItem) cis[i];
        		ci.getAction().setEnabled(enable);
        	}
        }
    }

    /**
     * @param enable
     */
    protected void setEnabledAction(String actionID,ISelection selection) {
    	PluginActionContributionItem ci = (PluginActionContributionItem)getViewSite().getActionBars().getToolBarManager().find(actionID);
    	ViewPluginAction action =  (ViewPluginAction)ci.getAction();
    	action.selectionChanged(selection);
    }

    //MASUCOMMENT ȉAǉ@\
	protected void createContextMenu(Control lControl){
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				//j[ڐݒ
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(lControl);
		lControl.setMenu(menu);
	}
		
	protected void fillContextMenu(IMenuManager manager) {
		int i = 0;
		PluginActionContributionItem pluginItem = null;
		
		//r[̃ANṼCX^X擾
		IToolBarManager toolbar = this.getViewSite().getActionBars()
		.getToolBarManager();
		//PluginActionContributionItem ̃Xg擾
		IContributionItem[] contributionItems = toolbar.getItems();
		
		for(i=0; i<contributionItems.length; i++ ){
			//contributionItems[i]PluginActionContributionItemǂmF
			if(contributionItems[i] instanceof PluginActionContributionItem){
				pluginItem = null;
				pluginItem = (PluginActionContributionItem)contributionItems[i];
				if(pluginItem != null){
					manager.add(pluginItem.getAction());
				}
			}
		}
		
	}
}
