/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.postgresforest.tool.action.UserMngAction;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.adduser.AddUserDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.SessionProperty;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AddUserAction extends ActionBase {
    public static final String ID = "org.postgresforest.tool.view.action.AddUserAction";
	private AddUserDialog m_dialog;
	
	public void init(IViewPart view) {
		super.init(view);
		m_dialog = new AddUserDialog();

	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		
		if (m_dialog.open() == Window.OK) {

			
			//[U[쐬͏擾
			String user = m_dialog.getUserName();
			String password = m_dialog.getPassword();
			String passwordOption = m_dialog.getPasswordOption();
			String createDbOption = m_dialog.getCreatedbOption();
			String createUserOption = m_dialog.getCreateuserOption();


			//[U[쐬
			UserMngAction addUser = new UserMngAction((GSCdata)SessionProperty.get("gsc"));
			try {
				addUser.addUser(user, password, passwordOption, createDbOption, createUserOption);
			} catch (Exception e1) {
				ErrorLog.log("", e1);
			    MsgDialogUtil.err(e1.getLocalizedMessage());
			}
		
		}		
		//O[oVXeJ^Or[XV
		m_view.update();
	}

}
