/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.brokenlog;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.bean.BrokenLogInfo;
//import org.postgresforest.tool.bean.ColumnInfo;
//import org.postgresforest.tool.bean.ConfigInfo;
//import org.postgresforest.tool.util.Messages;
//
//import com.sun.corba.se.internal.iiop.messages.Message;

/** 
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class BrokenLogLabelProvider extends LabelProvider implements ITableLabelProvider {

	DateFormat m_dtfmt = SimpleDateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG);
	static Image m_checked_image = ForestToolPlugin.getDefault().getImageRegistry().getDescriptor(ForestToolPlugin.IMG_CHECKED).createImage();
	static Image m_unchecked_image = ForestToolPlugin.getDefault().getImageRegistry().getDescriptor(ForestToolPlugin.IMG_UNCHECKED).createImage();
	
	//MASUCOMMENT Jԍ
	static final int FOREST_BROKENLOG_SERVERID_COLUMN = 6;
	static final int FOREST_BROKENLOG_DATETIME_COLUMN = 1;
	static final int FOREST_BROKENLOG_CLIENT_COLUMN = 	2;
	static final int FOREST_BROKENLOG_MSG_COLUMN = 		3;
	static final int FOREST_BROKENLOG_STATUS_COLUMN = 	4;
	static final int FOREST_BROKENLOG_QUERY_COLUMN = 	5;
	static final int FOREST_BROKENLOG_SERVER_URL_COLUMN = 0;
	
	public String getColumnText(Object element, int columnIndex) {
		BrokenLogInfo brokenLogInfo = (BrokenLogInfo)element;
		String status;
		switch(columnIndex) {
		case FOREST_BROKENLOG_DATETIME_COLUMN:
			return m_dtfmt.format(brokenLogInfo.getDatetime());
		//MASUCOMMENT 2005/11/07 ǉ
		case FOREST_BROKENLOG_CLIENT_COLUMN:
			return brokenLogInfo.getClient();
		case FOREST_BROKENLOG_MSG_COLUMN:
			return brokenLogInfo.getMsg();
		case FOREST_BROKENLOG_STATUS_COLUMN:
			return brokenLogInfo.getStatus();
		case FOREST_BROKENLOG_QUERY_COLUMN:
			return brokenLogInfo.getQuery();
		case FOREST_BROKENLOG_SERVER_URL_COLUMN:
			return brokenLogInfo.getServerUrl();

		}
		return null;
	}
	public Image getColumnImage(Object element, int columnIndex) {	
		return null;
	}
	//TODOMASU Rgt
	public static Object getData(int lColumnNumber, BrokenLogInfo lBrokenLogInfo){
		Object retObject = null;
		
		switch (lColumnNumber){
		case FOREST_BROKENLOG_DATETIME_COLUMN:
			retObject = (Object)lBrokenLogInfo.getDatetime();
			break;
		case FOREST_BROKENLOG_CLIENT_COLUMN:
			retObject = (Object)lBrokenLogInfo.getClient();
			break;
		case FOREST_BROKENLOG_MSG_COLUMN:
			retObject = (Object)lBrokenLogInfo.getMsg();
			break;
		case FOREST_BROKENLOG_STATUS_COLUMN:
			retObject = (Object)lBrokenLogInfo.getStatus();
			break;
		case FOREST_BROKENLOG_QUERY_COLUMN:
			retObject = (Object)lBrokenLogInfo.getQuery();
			break;
		case FOREST_BROKENLOG_SERVER_URL_COLUMN:
			retObject = (Object)lBrokenLogInfo.getServerUrl();
			break;	
		}
		
		return retObject;
	}

}