/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.config;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.postgresforest.tool.action.ConfigAction;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.AddConfigAction;
import org.postgresforest.tool.view.action.CopyConfigAction;
import org.postgresforest.tool.view.action.DelConfigAction;
import org.postgresforest.tool.view.action.ModConfigAction;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class ConfigView extends ViewBase {
	public static final String ID = "org.postgresforest.tool.view.ConfigView";

	private TableViewer viewer = null;


	/* ( Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE |SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
	
		TableColumn column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_CONFIGID_COLUMN);
		column.setText(Messages.getString("form.id"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_DESCRIPTION_COLUMN);
		column.setText(Messages.getString("form.description"));
		column.setWidth(100);
//MASUCOMMENT 2005.11.07 JǉɂC		
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_CACHE_REFLESH_COLUMN);
		column.setText(Messages.getString("form.config.cache"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_RETRY_COUNT_COLUMN);
		column.setText(Messages.getString("form.config.retry"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_DEFECT_TIMEOUT_COLUMN);
		column.setText(Messages.getString("form.config.timeout"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_DISTRIBUTED_CONNECTION_COLUMN);
		column.setText(Messages.getString("form.config.distribution"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_PERTITION_MODE_COLUMN);
		column.setText(Messages.getString("form.config.partitionsync"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_SYNCRONIZE_MODE_COLUMN);
		column.setText(Messages.getString("form.config.updatesync"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 
				ConfigLabelProvider.FOREST_CONFIG_UPDATE_DATE_COLUMN);
		column.setText(Messages.getString("form.config.date"));
		column.setWidth(100);

		

		
		TableColumn [] columnList = table.getColumns();		
		
		
		viewer = new TableViewer(table);

		viewer.setContentProvider(new CommonTableContentProvider());
		
		viewer.setLabelProvider(new ConfigLabelProvider());

		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
		    public void selectionChanged(SelectionChangedEvent event){
		    
		        ISelection selection = event.getSelection();
		        setEnabledAction(DelConfigAction.ID,selection);
		        setEnabledAction(ModConfigAction.ID,selection);
		        setEnabledAction(CopyConfigAction.ID,selection);
		    }
    								
		});
//TODOMASU ConfigView̃_uNbN͎Ȃ
//		viewer.addDoubleClickListener(new IDoubleClickListener(){
//			public void doubleClick(DoubleClickEvent event){
//		    	PluginActionContributionItem ci = (PluginActionContributionItem)getViewSite().getActionBars().getToolBarManager().find(ModConfigAction.ID);
//		    	ViewPluginAction action =  (ViewPluginAction)ci.getAction();
//		    	action.run();
//				
//			}
//			
//		});
		createContextMenu(viewer.getTable());
		
	}


	public void update() {

	    if(!isLogin()){
			viewer.setInput(null);
			setEnabledAction(AddConfigAction.ID, EnableSelection.FALSE);
	        return;
	    }

	    
		setEnabledAction(AddConfigAction.ID,EnableSelection.TRUE);

		ArrayList configList = null;

		//T[o擾
		ConfigAction configAction = new ConfigAction(getGsc());
		try {
			configList = configAction.getList();
			viewer.setInput(configList);
		} catch (Exception e) {
//			ErrorLog.log("", e);
		}


	}
	
	
	/**
	 * IT[oID擾
	 * 
	 * @return T[oID
	 */
	public String getSelectId() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			ConfigInfo configInfo = (ConfigInfo)selectItem[0].getData();
			return configInfo.getConfigId();
		}
		else{
			return "";
		}
	}

}
