/*
 * Copyright (C) 2006 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.postgresforest.tool.Logger;

/**
 * コマンドラインツール用のリソースバンドル
 * The main plugin class to be used in the desktop.
 */
public class ForestToolCommandLine  {
	//The shared instance.
	private static ForestToolCommandLine plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;	
	
	/**
	 * The constructor.
	 */
	public ForestToolCommandLine() {
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.postgresforest.tool.ForestToolPluginResources");
		} catch (MissingResourceException x) {
			Logger.error("Cannot find the message catalog file.");
			Logger.error(x.getMessage());
			Logger.trace(x);
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static ForestToolCommandLine getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = null;

		if ( ForestToolCommandLine.getDefault()==null )
			return key;
		else
			bundle = ForestToolCommandLine.getDefault().getResourceBundle();

		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,s
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
}
