package org.postgresforest.tool;

import java.sql.Timestamp;

/**
 * ログ出力用ユーティリティクラス
 */
public class Logger
{
	public final static int LOG_ERROR   = 1;
	public final static int LOG_WARNING = 2;
	public final static int LOG_NOTICE  = 3;
	public final static int LOG_LOG     = 4;
	public final static int LOG_DEBUG   = 5;
	public final static int LOG_TRACE   = 10;

	private static int level = LOG_LOG;

	private static boolean withTimestamp = false;

	/**
	 * ログの出力レベルを設定する
	 *
	 * @param l 出力レベル
	 */
	public static void setLevel(int l)
	{
		level = l;
	}

	private static void println(String prefix, String msg)
	{
		String t = "";
		if ( withTimestamp )
		{
			Timestamp ts = new Timestamp(System.currentTimeMillis());
			t = ts.toString() + " ";
		}
		System.out.println(t + prefix + ": " + msg);
	}

	public static void println(String msg)
	{
		System.out.println(msg);
	}

    public static void warning(String msg)
    {
        if ( level>=LOG_WARNING )
			println("WARNING", msg);
    }

	public static void debug(String msg)
	{
        if ( level>=LOG_DEBUG )
			println("DEBUG", msg);
	}

	public static void error(String msg)
	{
        if ( level>=LOG_ERROR )
			println("ERROR", msg);
	}

	public static void notice(String msg)
	{
        if ( level>=LOG_NOTICE )
			println("NOTICE", msg);
	}

	public static void detail(String msg)
	{
		println("DETAIL", msg);
	}

	/**
	 * トレース情報出力メソッド。
	 * 出力レベルがLOG_TRACE以上の場合に、
	 * 渡されたExceptionオブジェクトのスタックトレースが出力される。
	 *
	 * @param e スタックトレースを出力するExceptionオブジェクト
	 */
	public static void trace(Exception e)
	{
        if ( level>=LOG_TRACE )
			e.printStackTrace();
	}
}
