/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

/**
 * パーティションNo.を決定する関数(implements)
 * <BR>
 * ノード分割値のハッシュコードを加算して、ノード数で割った余をノードナンバーとする
 *
 * @see org.postgresforest.vm.Hash_I
 */
public class Hash01 implements Hash_I {

	int nodenum = 0; //ノード数
	long hashcode_sum = 0; //hashコードの合計

	/**
	 *  ノード数設定
	 * @see org.postgresforest.vm.Hash_I#setPartNum(int)
	 */
	public void setPartNum(int part) {
		nodenum = part;
	}

	/**
	 *  ノード分割値設定.
	 * そのままhashコードの合計に加算
	 * 
	 * @see org.postgresforest.vm.Hash_I#addCol(int)
	 */
	public void addCol(int col) {
		hashcode_sum += col;
	}

	/**
	 *  ノード分割値設定.
	 * hashコード取得しの合計に加算
	 * 
	 * @see org.postgresforest.vm.Hash_I#addCol(java.lang.String)
	 */
	public void addCol(String col) {

		hashcode_sum += col.hashCode();

	}

	/**
	 *  ノード分割値設定.
	 * hashコード取得しの合計に加算
	 * 
	 * @see org.postgresforest.vm.Hash_I#addCol(java.sql.Date)
	 */
	public void addCol(Date col) {
		hashcode_sum += col.hashCode();
	}

	/**
	 *  ノード分割値設定.
	 * hashコード取得しの合計に加算
	 * 
	 * @see org.postgresforest.vm.Hash_I#addCol(java.sql.Time)
	 */
	public void addCol(Time col) {
		hashcode_sum += col.hashCode();

	}

	/**
	 *  ノード分割値設定.
	 * hashコード取得しの合計に加算
	 * 
	 * @see org.postgresforest.vm.Hash_I#addCol(java.sql.Timestamp)
	 */
	public void addCol(Timestamp col) {
		hashcode_sum += col.hashCode();

	}

	/** 
	 * ノード分割値クリア.
	 * ノード数と、hashコードの合計をクリア
	 * 
	 * @see org.postgresforest.vm.Hash_I#clearCol()
	 */
	public void clearCol() {
		hashcode_sum = 0;

	}

	/** ノードNo取得.
	 * 設定されているハッシュコードの合計をノード数で割る
	 * 
	 * @see org.postgresforest.vm.Hash_I#getNodeNo()
	 */
	public int getNodeNo() {
		//文字列でマイナスの値になるので
		//return (int) (hashcode_sum % nodenum);
		return (int)(Math.abs(hashcode_sum)%nodenum);
	}


}
