<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * 桼ѥ桼
 *
 * $RCSfile$
 * $Revision$
 * $Date$
 **********************************************************/
include_once("../../initial");
include_once("lib/dglibldap");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");

/********************************************************
 *ƥڡ
 *********************************************************/
define("OPERATION", "Modifying user");
define("MODE_LDAPDATA", 0);
define("MODE_POSTDATA", 1);
define("TMPLFILE", "user_user_mod.tmpl");
define("FORWARD_ON", "1");

/*********************************************************
 * check_user_data
 *
 * ϥեηå
 *
 * []
 *         $mail     ᡼륢ɥ쥹
 *         $passwd   ѥ
 *         $repasswd ѥ(ǧ)
 *         $trans    ž襢ɥ쥹
 *         $save     ᡼¸
 *         &$attrs   °Ǽ
 * [֤]
 *         TRUE      
 *         FALSE     ۾
 *
 **********************************************************/
function check_user_data($mail, $passwd, $repasswd, $trans, $save, &$attrs)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $web_conf;
    global $user;
    global $ldapdata;
    global $url_data;
    
    $enpass = "";

    if (isset($ldapdata[0]['mailAlias'][0])) {
        $alias = $ldapdata[0]['mailAlias'][0];
    }
    $transes = array();

    /* ѥϥå */
    if ($passwd != "" || $repasswd != "") {
        $ret = check_passwd($passwd, (int)$web_conf["global"]["minpasswordlength"], 
                            (int)$web_conf["global"]["maxpasswordlength"]);
        if ($ret === FALSE) {
            return FALSE;
        }
        /* ѥɤΰפǧ */
        if ($passwd != $repasswd) {
            $err_msg = $msgarr['21001'][SCREEN_MSG];
            $log_msg = $msgarr['21001'][LOG_MSG];
            return FALSE;
        }

        /* ѥɤǼ */
        $enpass = make_passwd($passwd);
        if ($enpass === FALSE) {
            return FALSE;
        }
        $attrs['userPassword'] = $enpass;
    }

    // forwardconfoffξ
    if($web_conf[$url_data['script']]['forwardconf'] === FORWARD_OFF) {
        if ($trans != "") {
            /* ᡼žɥ쥹ϥå */
            if (check_mail ($trans) === FALSE) {
                $err_msg = $msgarr['21002'][SCREEN_MSG];
                $log_msg = $msgarr['21002'][LOG_MSG];
                return FALSE;
            }
            array_push ($transes, $trans);
            /* ᡼¸å */
            if ($save == "") {
                $err_msg = $msgarr['21003'][SCREEN_MSG];
                $log_msg = $msgarr['21003'][LOG_MSG];
                return FALSE;
            }
            if (check_flg($save) === FALSE) {
                $err_msg = $msgarr['21004'][SCREEN_MSG];
                $log_msg = $msgarr['21004'][LOG_MSG];
                return FALSE;
            }
            /* žɥ쥹ʣå */
            if ($trans == $mail) {
                $err_msg = $msgarr['21005'][SCREEN_MSG];
                $log_msg = $msgarr['21005'][LOG_MSG];
                return FALSE;
            }
            if (isset ($alias) && $trans == $alias) {
                $err_msg = $msgarr['21006'][SCREEN_MSG];
                $log_msg = $msgarr['21006'][LOG_MSG];
                return FALSE;
            }
            if ($save == 0) {
                /* ᡼Ĥξžɥ쥹˼᡼륢ɥ쥹ɲ */
                array_push($transes, $mail);
            }
 
            /* žɥ쥹Ǽ */
            $attrs['mailForwardingAddr'] = $transes;
        } else {
            /* ž襢ɥ쥹ǤСо */
            $attrs['mailForwardingAddr'] = array();
        }

        // mailFilterOrdermailFilterArticle¸ߤк
        if (isset($ldapdata[0]['mailFilterOrder'])) {
            $attrs["mailFilterOrder"][0] = "";
        }
        if (isset($ldapdata[0]['mailFilterArticle'])) {
            $attrs["mailFilterArticle"] = array();
        }

    // forwardconfonξ֤mailForwardingAddrǤ򥭡
    } else {
        if (isset($ldapdata[0]['mailForwardingAddr'])) {
            $attrs['mailForwardingAddr'] = $ldapdata[0]['mailForwardingAddr'];
        }
    }

    /* ᡼ǥ쥯ȥ°ʤк */
    if (!isset($ldapdata[0]["mailDirectory"][0])) {
        $attrs["mailDirectory"] = $web_conf[$url_data["script"]]["basemaildir"] . 
                                  "/" . $user . "/";
    }

    // mailFilterArticle, Order¸ߤϺо
    if (isset($ldapdata[0]['mailFilterOrder'])) {
        $attrs['mailFilterOrder'] = array();
    }
    if (isset($ldapdata[0]['mailFilterArticle'])) {
        $attrs['mailFilterArticle'] = array();
    }

    return TRUE;
}

/*********************************************************
 * mod_user_data
 *
 * 桼ǡѹԤ
 *
 * []
 *         $attrs   °Ǽ
 * [֤]
 *         TRUE     
 *         FALSE    ۾
 *
 **********************************************************/
function mod_user_data($attrs)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $env;
    global $user;
    global $sesskey;

    /* DNѹ */
    $env['user_self'] = FALSE;

    /* LDAPǡι */
    $dn = $env['user_selfdn'];
    $ret = LDAP_mod_entry($dn, $attrs);
    if ($ret !== LDAP_OK) {
        return FALSE;
    } else {
        $err_msg = $msgarr['21007'][SCREEN_MSG];
        $log_msg = $msgarr['21007'][LOG_MSG];
        result_log(OPERATION . ":OK:" . $log_msg);
        if (isset ($_POST['passwd1']) && $_POST['passwd1'] != "") {
           /* Ѥ˥å󥭡 */
           sess_key_make($user, $_POST['passwd1'], $sesskey);
        }
    }
    return TRUE;
}

/***********************************************************
 * 
 **********************************************************/

/*  */
$tag["<<TITLE>>"] = "";
$tag["<<JAVASCRIPT>>"] = "";
$tag["<<SK>>"] = "";
$tag["<<TOPIC>>"] = "";
$tag["<<MESSAGE>>"] = "";
$tag["<<TAB>>"] = "";
$tag["<<UID>>"] = "";
$tag["<<TRANSFERADDR>>"] = "";
$tag["<<SAVEMAILENABLED>>"] = "";
$tag["<<SAVEMAILDISABLED>>"] = "";
$tag["<<MAXPASSLEN>>"] = "";
$tag["<<FORWARD_START>>"] = "";
$tag["<<FORWARD_END>>"] = "";

/* ե롢ִեɹåå */
$ret = user_init();
if ($ret === FALSE) {
    $sys_err = TRUE;
    syserr_display();
    exit (1);
}

/***********************************************************
 * main
 **********************************************************/
/* ʬ */

/* 桼̾Ǽ */
$user = $env['loginuser'];
$userdn = $env['user_selfdn'];

/* 桼μ */
$ret = get_userdata ($userdn);
if ($ret === FALSE) {
    $err_msg = $msgarr['21008'][SCREEN_MSG];
    $log_msg = $msgarr['21008'][LOG_MSG];
    $sys_err = TRUE;
    result_log(OPERATION . ":NG:" . $log_msg);
    syserr_display();
    exit (1);
}

$dispusr = $web_conf[$url_data['script']]['displayuser'];
$dispusr = escape_html($ldapdata[0][$dispusr][0]);

$mode = MODE_LDAPDATA;
if (isset($_POST['modify'])) {

    $mode = MODE_POSTDATA;

    $mail = $ldapdata[0]['mail'][0];
    $passwd = $_POST['passwd1'];
    $repasswd = $_POST['passwd2'];
    $trans = $_POST['trans'];
    if (isset($_POST['save'])) { 
        $save = $_POST['save'];
    } else {
        $save = NULL;
    }

    /* ϥǡΥå */
    $ret = check_user_data($mail, $passwd, $repasswd, $trans, $save, $attrs);
    if ($ret === FALSE) {
        result_log(OPERATION . ":NG:" . $log_msg);
    } else {

        $ret = mod_user_data($attrs);
        if ($ret === FALSE) {
            result_log(OPERATION . ":NG:" . $log_msg);
        } else {
            /* ɽѤ˺LDAPǡ */
            unset($ldapdata);
            $ret = get_userdata($userdn);
            if ($ret === FALSE) {
                $err_msg = $msgarr['21008'][SCREEN_MSG];
                $log_msg = $msgarr['21008'][LOG_MSG];
                $sys_err = TRUE;
                result_log(OPERATION . ":NG:" . $log_msg);
                syserr_display();
                exit (1);
            }
        }
    }
}

/***********************************************************
 * ɽ
 **********************************************************/

/* ᡼žɥ쥹ɽ */
$trans = "";
$save_mail_check = "";
$unsave_mail_check = "";
if ($mode == MODE_POSTDATA) {
    /* ⡼ɡʹܥ󤬲줿 */
    $trans = escape_html($_POST['trans']);
    if (isset($_POST['save']) && $_POST['save'] == "0") {
        $save_mail_check = "checked";
    } else {
        $unsave_mail_check = "checked";
    }
} else {
    /* LDAPǡ⡼ɡʽɽ */
    $count = 0;
    if (isset($ldapdata[0]['mailForwardingAddr'])) {
        $count = count($ldapdata[0]['mailForwardingAddr']);
    }

    if ($count == 2) {
        /* mailForwardingAddr2ꤵƤϥ᡼Ĥ */
        $save_mail_check = "checked";
        /* ʬΥ᡼륢ɥ쥹Ǥʤž襢ɥ쥹Ǥ */
        if ($ldapdata[0]['mailForwardingAddr'][0] == $ldapdata[0]['mail'][0]) {
            $trans = $ldapdata[0]['mailForwardingAddr'][1];
        } else {
            $trans = $ldapdata[0]['mailForwardingAddr'][0];
        }
    } elseif ($count == 1) {
        /* mailForwardingAddr1ꤵƤϥ᡼Ĥʤ */
        $unsave_mail_check = "checked";
        /* ξϡʤ餺ž襢ɥ쥹Ǥ */
        $trans = $ldapdata[0]['mailForwardingAddr'][0];
    }
    $trans = escape_html($trans);
} 

/* ͤ򥻥å */
$java_script = <<<EOD
window.onload = function() {
    var i;
    var len = document.mod_form.save.length;
    if(document.mod_form.trans.value == "") {
        for(i=0;i<len;i++) {
          document.mod_form.save[i].disabled = true;
        }
    } else {
        for(i=0;i<len;i++) {
            document.mod_form.save[i].disabled = false;
        }
    }
}
function check(n) {
    var i;
    var len = document.mod_form.save.length;
    if(n == "") {
        for(i=0;i<len;i++) {
            document.mod_form.save[i].disabled = true;
        }
    } else {
        for(i=0;i<len;i++) {
            document.mod_form.save[i].disabled = false;
        }
    }
}
EOD;
set_tag_common($tag, $java_script);
$tag["<<UID>>"] = $dispusr;
$tag["<<TRANSFERADDR>>"] = $trans;
$tag["<<SAVEMAILENABLED>>"] = $save_mail_check;
$tag["<<SAVEMAILDISABLED>>"] = $unsave_mail_check;
$tag["<<MAXPASSLEN>>"] = $web_conf["global"]["maxpasswordlength"];

// ForwardConfONξϵɽä
if ($web_conf[$url_data['script']]['forwardconf'] === FORWARD_ON) {
    $tag["<<FORWARD_START>>"] = "<!--";
    $tag["<<FORWARD_END>>"] = "-->";
}

/* ڡν */
$ret = display(TMPLFILE, $tag, array(), "", "");
if ($ret === FALSE) {
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}

?>
