/**
 * PowerDBJ
 * create date 2006/09/15
 * amonden
 */
package jp.co.powerbeans.common.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * PBClassLoadUtil
 * @author amonden
 * @create date 2006/09/15
 */
public class PBClassLoadUtil {

	/**
	 * 
	 */
	private PBClassLoadUtil() {
		super();
	}

	/**
	 * jarファイルからクラスをロードしリストを取得する
	 * @param jar_filepath jarファイルパス
	 * @param filter_cls 実装クラス
	 * @return クラス一覧
	 */
	public static Class[] getClassesFromJar(String jar_filepath) {
		return getClassesFromJar(jar_filepath, null);
	}
	
	/**
	 * jarファイルからクラスをロードし,filter_clsを実装しているクラスリストを取得する
	 * @param jar_filepath jarファイルパス
	 * @param filter_cls 実装クラス
	 * @return クラス一覧
	 */
	public static Class[] getClassesFromJar(String jar_filepath, Class filter_cls) {
		List clslist= new ArrayList();
		// 1. Jar ファイルをロード
		try {
			URL[] urls = new URL[]{new File(jar_filepath).toURL()};
			URLClassLoader classLoader = new URLClassLoader(urls, PBClassLoadUtil.class.getClass().getClassLoader());
			
			JarFile jarfile = new JarFile(jar_filepath);
			for (Enumeration jarnum = jarfile.entries(); jarnum.hasMoreElements();) {
				JarEntry entry = (JarEntry) jarnum.nextElement();
				String filename = entry.getName();
				if (filename.endsWith("class") && filename.indexOf("$") == -1) {
					try {
						String clsname = filename.replace('/', '.').replaceFirst(".class$", "");
						Class tcls = classLoader.loadClass(clsname);
						if (filter_cls != null && filter_cls.isAssignableFrom(tcls)) {
							clslist.add(tcls);
						} else if (filter_cls == null) {
							clslist.add(tcls);
						}
					} catch (NoClassDefFoundError e) {
					} catch (ClassNotFoundException e) {
					}
				}
			}
		} catch (MalformedURLException e1) {
//			e1.printStackTrace();
		} catch (IOException e) {
//			e.printStackTrace();
		}
		return (Class[]) clslist.toArray(new Class[clslist.size()]);
	}

	/**
	 * jar_filepath内の target_cls ファイルをロード.
	 * jarファイルに存在しない場合は ClassNotFoundException をスロー
	 * @param jar_filepath jarファイルパス
	 * @param target_cls ロード対象クラス名
	 * @return ロードしたクラス
	 * @throws ClassNotFoundException 
	 */
	public static Class loadClassFromJar(String jar_filepath, String target_cls) throws ClassNotFoundException {
		try {
			URL[] urls = new URL[]{new File(jar_filepath).toURL()};
			URLClassLoader classLoader = new URLClassLoader(urls, PBClassLoadUtil.class.getClass().getClassLoader());
			String target_file = target_cls.replace('.', '/') + ".class";
			
			JarFile jarfile = new JarFile(jar_filepath);
			for (Enumeration jarnum = jarfile.entries(); jarnum.hasMoreElements();) {
				JarEntry entry = (JarEntry) jarnum.nextElement();
				String filename = entry.getName();
				if (filename.equals(target_file)) {
					// 見つかったのでロード
					String clsname = filename.replace('/', '.').replaceFirst(".class$", "");
					Class tcls = classLoader.loadClass(clsname);
					// 成功
					return tcls;
				}
			}
		} catch (MalformedURLException e1) {
		} catch (IOException e) {
		}
		throw new ClassNotFoundException("can't load class [" + target_cls + "]");
	}

	
}
