package jp.co.powerbeans.eclipse.plugin.powerdbj.db;

import java.lang.reflect.Array;
import java.sql.SQLException;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

import jp.co.powerbeans.eclipse.common.PBEclipseUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.dao.POQLAutoJoinDAO;
import jp.co.powerbeans.powerql.dao.POQLDAO;
import jp.co.powerbeans.powerql.dao.POQLRawSqlDAO;
import jp.co.powerbeans.powerql.ds.POQLSingleConnectionDataSource;
import jp.co.powerbeans.powerql.exceptions.POQLException;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Table;

/**
 * DBManager
 * @author amonden
 * @create date 2006/09/15
 */
public class DBSysManager {
	
	// とりあえず static で管理
	private static POQLManager poqlManager = null;
	// PowerDBJ プラグイン内部用DataSource
	private static POQLSingleConnectionDataSource ds;
	static {
		try {
			String path = PBEclipseUtil.getPluginsPath() + "/" 
				+ Msg.getConfigCurrentDir() + "/powerdbj.db";
			
			ds = new POQLSingleConnectionDataSource(
					"org.hsqldb.jdbcDriver",
          "jdbc:hsqldb:"+ path  +";shutdown=true",
//          "jdbc:hsqldb:file:"+ path  +";shutdown=true",
					"sa",
					"");
			poqlManager = new POQLManager(ds, "SeqTable");
			poqlManager.setAutoCreateTable(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * モデルの配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @return 検索結果
	 */
	public static Object[] findByAll(Class model_class) {
		POQLDAO dao = createDAO(model_class);
		return dao.findByAll().toArray((Object[]) Array.newInstance(model_class, 0));
	}

	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * モデルの配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @return 検索結果
	 */
	public static Object[] find(Class model_class, String sql) {
		POQLRawSqlDAO dao = createRawSqlDAO();
		return dao.find(sql, model_class).toArray((Object[]) Array.newInstance(model_class, 0));
	}
	
	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * モデルの配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @return 検索結果
	 */
	public static Object[] findByAll(Class result_class, Class[] join_classes) {
		POQLAutoJoinDAO dao = poqlManager.createAutoJoinDAO(result_class, join_classes);
		return dao.findByAll().toArray((Object[]) Array.newInstance(result_class, 0));
	}
	
	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * モデルの配列を文字列配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @param columns 結果格納カラム名
	 * @return 検索結果
	 */
	public static String[][] findByAllToStrArray(Class model_class, String[] columns) {
		return DBUtil.modelsToStrings(DBSysManager.findByAll(model_class), columns);
	}
	
	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * モデルの配列を文字列配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @param columns 結果格納カラム名
	 * @return 検索結果
	 */
	public static String[][] findByAllToStrArray(Class model_class, String sql, String[] columns) {
		return DBUtil.modelsToStrings(DBSysManager.find(model_class, sql), columns);
	}
	
	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * モデルの配列を文字列配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @param columns 結果格納カラム名
	 * @return 検索結果
	 */
	public static String[][] findByAllToStrArray(Class model_class, Class[] join_classes, String[] columns) {
		return DBUtil.modelsToStrings(DBSysManager.findByAll(model_class, join_classes), columns);
	}
	

	/**
	 * モデルクラスと検索条件を指定して検索し
	 * モデルの配列を文字列配列で取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @param where 句
	 * @param columns 結果格納カラム名
	 * @return 検索結果
	 */
	public static String[][] findByToStrArray(Class model_class, String where, String[] columns) {
		POQLDAO dao = createDAO(model_class);
		return DBUtil.modelsToStrings(dao.findBy(where).toArray((Object[])Array.newInstance(model_class, 0)), columns);
	}

	/**
	 * PK(int)を指定して1レコードを取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @param id プライマリキー(int値)
	 * @return 検索結果
	 */
	public static Object findByPrimaryKey(Class model_class, int id) {
		POQLDAO dao = createDAO(model_class);
		return dao.findByPrimaryKey(id);
	}

	/**
	 * PK(int以外)を指定して1レコードを取得する
	 * @param model_class 検索対象テーブル対応モデル
	 * @param keys プライマリキー(複数可能)
	 * @return 検索結果
	 */
	public static Object findByPrimaryKey(Class model_class, Object keys) {
		POQLDAO dao = createDAO(model_class);
		return dao.findByPrimaryKey(keys);
	}

	/**
	 * 1レコードを追加
	 * @param m モデル
	 * @return 追加レコード数
	 * @throws POQLException 
	 */
	public static int insert(Object m) {
		POQLDAO dao = createDAO(m.getClass());
		dao.setAutoTimestampColName(new String[]{"createDt","updateDt"});
//		int c = dao.create(m);
		int c = dao.createByPowerQLSeq(m);
//		 Log.println("OnSubmitUpdate insert " + c);
		return c;
	}

	/**
	 * モデルのPKをKeyとして1レコードを更新
	 * @param m モデル
	 * @return 更新レコード数
	 * @throws POQLException 
	 */
	public static int update(Object m) {
		POQLDAO dao = createDAO(m.getClass());
		dao.setAutoTimestampColName(new String[]{"updateDt"});
		int c = dao.update(m);
//		Log.println("OnSubmitUpdate update " + c);
		return c;
	}

	
	/**
	 * DAOを生成して返す
	 * @param cls モデルクラス
	 * @return DAO
	 */
	private static POQLDAO createDAO(Class cls) {
		// TODO 将来的にDAOをPOQLManager内でキャッシュ化し同じコネクションで動作するようにする
		// > standaloneアプリ用
		POQLDAO dao = poqlManager.createDAO(cls);
		dao.setThrowException(true);
		return dao;
	}
	
	private static POQLRawSqlDAO createRawSqlDAO() {
		POQLRawSqlDAO dao = poqlManager.createRawSqlDAO();
		dao.setThrowException(true);
		return dao;
	}

	/**
	 * PKを指定して1レコード削除
	 * @param cls モデルクラス
	 * @param id PK(int)
	 * @return 削除件数
	 */
	public static int removeByPrimaryKey(Class cls,  int id) {
		POQLDAO dao = createDAO(cls);
		return dao.removeByPrimaryKey(id);
	}

	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * ComboBoxModelで返す
	 * @param cls モデルクラス
	 * @return ComboBoxModel
	 */
	public static ComboBoxModel findByAllToComboBox(Class cls) {
		return DBUtil.modelsToComboBoxModel(DBSysManager.findByAll(cls));
	}

	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * DefaultComboBoxModelで返す.
	 * 特にComboBoxModelの値を変更したい場合利用する.
	 * @param cls モデルクラス
	 * @return DefaultComboBoxModel
	 */
	public static DefaultComboBoxModel findByAllToDefaultComboBox(Class cls) {
		return DBUtil.modelsToDefaultComboBoxModel(DBSysManager.findByAll(cls));
	}
	
	/**
	 * モデルクラスを指定してテーブル全件を取得し
	 * 結果を引き数のDefaultComboBoxModelに格納する
	 * 
	 * @param cls モデルクラス
	 * @param cmb_model 
	 */
	public static void findByAllToDefaultComboBox(Class cls, DefaultComboBoxModel cmb_model) {
		DBUtil.modelsToDefaultComboBoxModel(DBSysManager.findByAll(cls), cmb_model);
	}
	
	/**
	 * 条件を指定して1レコード削除
	 * @param cls モデルクラス
	 * @param where 条件
	 */
	public static void removeBy(Class cls, String where) {
		POQLDAO dao = createDAO(cls);
		dao.removeBy(where);
	}

	/**
	 * 条件を指定して一致件数を取得
	 * @param cls モデルクラス
	 * @param where 検索条件
	 * @return 一致件数
	 */
	public static int countBy(Class cls, String where) {
		POQLDAO dao = createDAO(cls);
		return dao.countBy(where);
	}
	/**
	 * 件数を取得
	 * @param cls モデルクラス
	 * @return 一致件数
	 */
	public static int countByAll(Class cls) {
		POQLDAO dao = createDAO(cls);
		return dao.countByAll();
	}

	/**
	 * 条件とソート順を指定して複数件取得
	 * @param cls モデルクラス
	 * @param where 検索条件
	 * @param orderby ソート順
	 * @return 検索結果
	 */
	public static Object[] findBy(Class cls, String where, String orderby) {
		POQLDAO dao = createDAO(cls);
		return dao.findBy(where, orderby).toArray((Object[]) Array.newInstance(cls, 0));
	}

	/**
	 * 条件を指定して複数件取得
	 * @param cls モデルクラス
	 * @param where 検索条件
	 * @return 検索結果
	 */
	public static Object[] findBy(Class cls, String where) {
		POQLDAO dao = createDAO(cls);
		return dao.findBy(where).toArray((Object[]) Array.newInstance(cls, 0));
	}

	/**
	 * 条件を指定して1件件取得
	 * @param cls モデルクラス
	 * @param where 検索条件
	 * @return 検索結果
	 */
	public static Object find1By(Class cls, String where) {
		POQLDAO dao = createDAO(cls);
		return dao.find1By(where);
	}

	public static void findByAllToSwtTable(Table table, Class model_class, String[] columns) {
		DBUtil.modelsToSwtTable(table, findByAllToStrArray(model_class, columns));
	}

//	public static void findByAllToSwtTable(Table table, Class model_class, Class[] table_classes, String[] columns) {
//		// TODO 作成中
//		DBUtil.modelsToSwtTable(table, findByAllToStrArray(model_class, table_classes, columns));
//	}

	public static void findByAllToSwtTable(Table table, Class model_class, String sql, String[] columns, Class[] check_cls) {
		// テーブルクラスの存在をチェックする
		for (int i = 0; check_cls != null && i < check_cls.length; i++) {
			DBSysManager.countByAll(check_cls[i]);
		}
		// TODO ↑をPowerQLで行うようにする
		
		// 検索実行
		DBUtil.modelsToSwtTable(table, findByAllToStrArray(model_class, sql, columns));
	}

//	public static void findByToSwtTable(Table table, Class model_class, String where, String[] columns) {
//		DBUtil.modelsToSwtTable(table, findByToStrArray(model_class, where, columns));
//	}
//
	public static void findByToSwtTable(Table table, Class model_class, String[] columns, String where) {
		DBUtil.modelsToSwtTable(table, findBy(model_class, where), columns);
//		DBUtil.modelsToSwtTable(table, findByToStrArray(model_class, where, columns));
	}

	public static void findByAllToSwtComboBox(Combo combo, Class model_class, String column) {
		DBUtil.modelsToSwtCombobox(combo, findByAll(model_class), column);
	}

	public static void findByToSwtComboBox(Combo combo, Class model_class, String column, String where) {
		DBUtil.modelsToSwtCombobox(combo, findBy(model_class, where), column);
	}

	public static void init() {
		// 将来PoqlManagerに統合
//		try {
//			poqlManager.initTable(ActionDef.class);
//			poqlManager.initTable(ActionResultDef.class);
//			poqlManager.initTable(RankingDef.class);
//		} catch (POQLException e) {
//			e.printStackTrace();
//		}
	}
	
	public static void close() {
		try {
			ds.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @param name
	 * @return 
	 */
	public static int removeByAll(Class cls) {
		POQLDAO dao = createDAO(cls);
		return dao.removeByAll();
	}
}
