package jp.co.powerbeans.eclipse.plugin.powerdbj.db;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

import jp.co.powerbeans.common.ChkConv;

import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;


public class DBUtil {

	/**
	 * modelsの各columns[]値をString配列にし、それを行数分のString[][]にして返す
	 * @param models モデル配列
	 * @param columns 表示カラム
	 * @return 表示用String[][]
	 */
	public static String[][] modelsToStrings(Object[] models, String[] columns) {
		
		if (models == null || columns == null) {
			return new String[][]{{}};
		}
//		List res = new ArrayList(models.length);
		String[][] res = new String[models.length][columns.length];
		
		try {
			// プロパティマップ作成
			Map propmap = new HashMap();
			
            if (models.length > 0) {
                BeanInfo info = Introspector.getBeanInfo(models[0].getClass());
                PropertyDescriptor[] properties = info.getPropertyDescriptors();
                for (int i = 0; i < properties.length; i++) {
					if (properties[i].getName().equals("class")) {
						continue;
					}
					propmap.put(properties[i].getName(), properties[i]);
				}
            }
            
            // 値を取得
			for (int i = 0; i < models.length; i++) {
				for (int j = 0; j < columns.length; j++) {
					if (!propmap.containsKey(columns[j])) {
						// 存在しないカラム名は無視
						continue;
					}
					String val = BeanUtils.getProperty(models[i], columns[j]);

					// データタイプにより変換
					if (propmap.containsKey(columns[j])) {
						PropertyDescriptor pd = (PropertyDescriptor) propmap.get(columns[j]);
						Class typ = pd.getPropertyType();
						
						if (typ.isAssignableFrom(Date.class)) {
							// Date型の場合 yyyy/MM/dd に変換
							val = ChkConv.toString((Date)pd.getReadMethod().invoke(models[i],null));
						}
					}
					if (val == null) {
						val = "";
					}
					res[i][j] = val;
				}
			}
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}

		return res;
	}

	/**
	 * オブジェクト配列をComboBoxModelに変換して返す
	 * @param models モデル配列
	 * @return ComboBoxModel
	 */
	public static ComboBoxModel modelsToComboBoxModel(Object[] models) {
		return modelsToDefaultComboBoxModel(models);
	}

	/**
	 * オブジェクト配列をDefaultComboBoxModelに変換して返す
	 * @param models モデル配列
	 * @return DefaultComboBoxModel
	 */
	public static DefaultComboBoxModel modelsToDefaultComboBoxModel(Object[] models) {
		return new DefaultComboBoxModel(models);
	}

	/**
	 * オブジェクト配列をDefaultComboBoxModelに変換して返す
	 * @param models モデル配列
	 * @param cmb_model デフォルトコンボボックス
	 * @return DefaultComboBoxModel
	 */
	public static DefaultComboBoxModel modelsToDefaultComboBoxModel(Object[] models, DefaultComboBoxModel cmb_model) {
		cmb_model.removeAllElements();
		for (int i = 0; i < models.length; i++) {
			cmb_model.addElement(models[i]);
		}
		return cmb_model;
	}

	/**
	 * SWT TableにString[][]を表示
	 * @param datas
	 */
	public static void modelsToSwtTable(Table table, String[][] datas) {
		for (int i = 0; i < datas.length; i++) {
	        TableItem item = new TableItem(table, SWT.NULL);
	        item.setText(datas[i]);
		}
	}

	/**
	 * SWT Tableに検索結果を格納し,Tableにobjectsを保持しておく
	 * @param table
	 * @param objects
	 * @param columns
	 */
	public static void modelsToSwtTable(Table table, Object[] objects, String[] columns) {
		String[][] datas = DBUtil.modelsToStrings(objects, columns);
		modelsToSwtTable(table, datas);
		
		// 検索結果のobjectsもそのまま格納
		table.setData(objects);
	}

	/**
	 * SWT Comboにmodelsのdisp_colプロパティ値をラベルとして追加し
	 * ComboのDataにmodelsを格納する
	 * @param combo
	 * @param models
	 * @param disp_col
	 */
	public static void modelsToSwtCombobox(Combo combo, Object[] models, String disp_col) {
		String[][] datas = modelsToStrings(models, new String[]{disp_col});
		combo.removeAll();
		
		// 表示文字列を設定
		for (int i = 0; i < datas.length; i++) {
			combo.add(datas[i][0]);
		}
		// 検索結果モデルをそのまま格納
		combo.setData(models);
	}

	/**
	 * HSQLDB用Date型比較SQL文を生成して返す
	 * @param dt
	 * @param add_date
	 * @return
	 */
	public static String formatDate(Date dt, int add_date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(dt);
		cal.add(Calendar.DAY_OF_MONTH, add_date);
		
		SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.0");
		return df.format(cal.getTime());
	}
	
	public static String formatDate(Date dt) {
		return formatDate(dt, 0);
	}

	public static String sqlDate(String colname, Date date) {
		return " YEAR(" + colname + ")+'/'+MONTH(" + colname + ")+'/'+DAY(" + colname + ") >= '" + ChkConv.toStringNoZero(date) + "' ";
	}

	public static String sqlDateBetween(String colname, Date from_dt, Date to_dt) {
		StringBuffer sub = new StringBuffer();
		if (from_dt != null) {
			sub.append(" AND " + DBUtil.sqlDate(colname, from_dt));
		}
		if (to_dt != null) {
			sub.append(" AND " + DBUtil.sqlDate(colname, to_dt));
		}
		return sub.toString();
	}

	public static void clearDuplicate(Object[] objs, String propname) {
		try {
			String last_name = "";
			if (objs.length > 0) {
				last_name = BeanUtils.getProperty(objs[0], propname);
			}
			for (int i = 1; i < objs.length; i++) {
				if (last_name.equals(BeanUtils.getProperty(objs[i], propname))) {
					BeanUtils.setProperty(objs[i], propname, "");
				} else {
					last_name = BeanUtils.getProperty(objs[i], propname);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void replace(Object[] objs, String propname, String matchstr, String replacestr) {
		try {
			for (int i = 0; i < objs.length; i++) {
				String val = BeanUtils.getProperty(objs[i], propname);
				if (val == matchstr || ( val != null && val.equals(matchstr))) {
					BeanUtils.setProperty(objs[i], propname, replacestr);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static String sqlToIn(Object[] vals) {
		StringBuffer buf = new StringBuffer("(");
		for (int i = 0; i < vals.length; i++) {
			if (i > 0) {
				buf.append(",");
			}
			buf.append("'" + vals[i] + "'");
		}
		buf.append(")");
		return buf.toString();
	}

	public static String sqlToIn(int[] vals) {
		StringBuffer buf = new StringBuffer("(");
		for (int i = 0; i < vals.length; i++) {
			if (i > 0) {
				buf.append(",");
			}
			buf.append(vals[i]);
		}
		buf.append(")");
		return buf.toString();
	}


}
