/**
 * PowerDBJ
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export;

import java.io.File;
import java.io.IOException;

import jp.co.powerbeans.eclipse.plugin.powerdbj.wizards.DBInfo;

/**
 * ExportMgr
 * @author amonden
 * @create date 2006/09/21
 */
public class ExportMgr {

	/**
   * dbinfoを元に定義をエクスポート
	 * @param dbinfo 定義情報
	 */
	public static void export(DBInfo dbinfo) {
		Exporter exporter = ExporterFactory.getExporter(dbinfo.getExportType());
		String output_path = exporter.export(dbinfo.getJdbcConfig(), dbinfo.getSelectTables(), dbinfo.getOutputPath());
		
		// 1. 開く
		try {
			File file = new File(output_path);
			Runtime.getRuntime().exec("explorer " + file.getPath());
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

}
