/**
 * PowerDBJ
 * create date 2006/09/22
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export;

import java.text.SimpleDateFormat;
import java.util.Date;

import jp.co.powerbeans.docbuild.PBDocmentBuilderFactory;
import jp.co.powerbeans.docbuild.PBDocumentBuilder;

/**
 * ExporterBase
 * @author amonden
 * @create date 2006/09/22
 */
public abstract class ExporterBase implements Exporter {

  /**
   * builderを作成
   * @param type builderタイプ
   * @param templatedir テンプレートディレクトリ
   * @param template テンプレートファイル相対パス
   * @param charset 文字コード
   * @return builder
   */
  protected PBDocumentBuilder createDocBuilder(int type, String templatedir, String template, String charset) {
    PBDocumentBuilder builder = PBDocmentBuilderFactory.create(
        type, templatedir + template, charset);
    
    // 共通パラメータ設定
    assignCommonValue(builder, charset);
  
    return builder;
  }
  /**
   * builderに共通パラメータを格納
	 * @param builder builder
	 */
	private void assignCommonValue(PBDocumentBuilder builder, String charset) {
		// date 作成日
		SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
		builder.assign("date", df.format(new Date()));
		
		// footer
		builder.assign("auther", "This file is exported by PowerDBJ developed 2006 PowerBEANS.Co., Ltd.");
		builder.assign("url", "http://www.powerbeans.co.jp/");
		
		// charset
		builder.assign("charset", charset);
	}

	/**
	 * タイトルを設定.主にHTML用
	 * @param builder PBDobumentBuilder
	 * @param title タイトル
	 */
	protected void setTitle(PBDocumentBuilder builder, String title) {
		builder.assign("title", title);
	}


}
