/**
 * PowerDBJ
 * create date 2006/09/26
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.java;

import java.io.Serializable;

import jp.co.powerbeans.eclipse.plugin.powerdbj.export.java.util.JavaExpUtil;
import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.IndexProperty;
import jp.co.powerbeans.powerql.TableProperty;

/**
 * ClassProperty
 * @author amonden
 * @create date 2006/09/26
 */
public class ClassProperty implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 8173622437143078631L;

  private String className;
  
  private TableProperty tableProperty;
  private PropProperty[] properties;
  
  /**
   * コンストラクタ
   * @param table
   */
  public ClassProperty(TableProperty table) {
    this.tableProperty = table;

    // クラス名作成
    this.className = JavaExpUtil.tableNameToClassName(this.tableProperty.getTableName());

    this.properties = new PropProperty[table.getColumnProperties().length];
    for (int i = 0; i < this.properties.length; i++) {
      this.properties[i] = new PropProperty(table.getColumnProperties()[i]);
    }
  }

  /**
   * @return className
   */
  public String getClassName() {
    return className;
  }

  /**
   * @param className 設定する className
   */
  public void setClassName(String className) {
    this.className = className;
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getColumnProperties()
   */
  public ColumnProperty[] getColumnProperties() {
    return tableProperty.getColumnProperties();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getIndexProperties()
   */
  public IndexProperty[] getIndexProperties() {
    return tableProperty.getIndexProperties();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getSchema()
   */
  public String getSchema() {
    return tableProperty.getSchema();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getTableName()
   */
  public String getTableName() {
    return tableProperty.getTableName();
  }

  /**
   * @param columnProperties
   * @see jp.co.powerbeans.powerql.TableProperty#setColumnProperties(jp.co.powerbeans.powerql.ColumnProperty[])
   */
  public void setColumnProperties(ColumnProperty[] columnProperties) {
    tableProperty.setColumnProperties(columnProperties);
  }

  /**
   * @param indexProperties
   * @see jp.co.powerbeans.powerql.TableProperty#setIndexProperties(jp.co.powerbeans.powerql.IndexProperty[])
   */
  public void setIndexProperties(IndexProperty[] indexProperties) {
    tableProperty.setIndexProperties(indexProperties);
  }

  /**
   * @param schema
   * @see jp.co.powerbeans.powerql.TableProperty#setSchema(java.lang.String)
   */
  public void setSchema(String schema) {
    tableProperty.setSchema(schema);
  }

  /**
   * @param tableName
   * @see jp.co.powerbeans.powerql.TableProperty#setTableName(java.lang.String)
   */
  public void setTableName(String tableName) {
    tableProperty.setTableName(tableName);
  }

  /**
   * @return properties
   */
  public PropProperty[] getProperties() {
    return properties;
  }

  /**
   * @param properties 設定する properties
   */
  public void setProperties(PropProperty[] properties) {
    this.properties = properties;
  }


}
