/**
 * PowerDBJ
 * create date 2006/09/26
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.java.util;

/**
 * JavaExpUtil
 * @author amonden
 * @create date 2006/09/26
 */
public class JavaExpUtil {

  private JavaExpUtil() {
    
  }

  /**
   * DB的な_区切り名をCamel式名称に変換
   * @param column_name カラム名
   * @param top_upper 先頭をおおもじにするかどうか. true 大文字, false 小文字
   * @return Camel式プロパティ名
   */
  public static String toCamel(String column_name, boolean top_upper) {
    
    if (column_name == null) {
      return "";
    } else if (column_name.indexOf("_") == -1) {
      // _ が存在しない場合はそのまま返す
      if (!column_name.equals(column_name.toUpperCase())) {
        // 大文字と小文字が混在する場合は先頭文字のみ変換して２文字目以降はそのまま返す
        return top_upper ? column_name.substring(0,1).toUpperCase() + column_name.substring(1) :
          column_name.substring(0,1).toLowerCase() + column_name.substring(1);
      } else {
        // すべて大文字の場合は２文字目以降も小文字か
        return top_upper ? column_name.substring(0,1).toUpperCase() + column_name.substring(1).toLowerCase() :
          column_name.substring(0,1).toLowerCase() + column_name.substring(1).toLowerCase();
      }
    }
    
    // _ が存在する場合はCamelに変換
    StringBuffer buf = new StringBuffer();
    String[] parts = column_name.split("_");
    for (int i = 0; i < parts.length; i++) {
      if (i > 0 || top_upper) {
        buf.append(parts[i].substring(0,1).toUpperCase() + parts[i].substring(1).toLowerCase());
      } else {
        buf.append(parts[i].substring(0,1).toLowerCase() + parts[i].substring(1).toLowerCase());
      }
    }
    
    return buf.toString();
  }
  
  /**
   * DBカラム名からプロパティ名を取得する
   * _ を Camel式に変換
   * @param column_name カラム名
   * @return Camel式プロパティ名
   */
  public static String columnNameToProperty(String column_name) {
    return toCamel(column_name, false);
  }


  /**
   * プロパティ名からReadメソッド名を取得する
   * @param property プロパティ名
   * @param type type プロパティの型
   * @return Readメソッド
   */
  public static String propertyToReadMethod(String property, Class type) {

    String mname = Character.toUpperCase(property.charAt(0)) + property.substring(1);
    return type == boolean.class ? "is" + mname : "get" + mname;
  }

  /**
   * プロパティ名からWriteメソッド名を取得する
   * @param property プロパティ名
   * @return Writeメソッド
   */
  public static String propertyToWriteMethod(String property) {
    return "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
  }

  /**
   * テーブル名からクラス名を取得する
   * @param tableName テーブル名
   * @return クラス名
   */
  public static String tableNameToClassName(String tableName) {
    return toCamel(tableName, true);
  }
}
