/**
 * PowerDBJ
 * create date 2006/09/15
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.wizards;

import jp.co.powerbeans.common.swt.PBControlUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBSysManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/**
 * PowerDBJWizardBase
 * @author amonden
 * @create date 2006/09/15
 */
public abstract class PowerDBJWizardBase extends WizardPage {

	private DBInfo dbinfo;
	private boolean canNextPage;
	private final boolean lastPage;


	/**
	 * コンストラクタ
	 * @param pageName
	 */
	protected PowerDBJWizardBase(String pageName, DBInfo dbinfo, boolean last_page) {
		super(pageName);
		this.dbinfo = dbinfo;
		this.lastPage = last_page;
	}
	/**
	 * コンストラクタ
	 * @param pageName
	 */
	protected PowerDBJWizardBase(String pageName, DBInfo dbinfo) {
		this(pageName, dbinfo, false);
	}

	public DBInfo getDbinfo() {
		return dbinfo;
	}

	protected Combo createCombo(Composite container) {
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		Combo combo = new Combo(container, SWT.BORDER | SWT.SINGLE);
		combo.setLayoutData(gridData);
		return combo; 
	}
	protected Combo createCombo(Composite container, ModifyListener listener) {
		Combo combo = createCombo(container);
		combo.addModifyListener(listener);
		return combo;
	}
	protected Combo createComboReadOnly(Composite container) {
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		Combo combo = new Combo(container, SWT.BORDER | SWT.SINGLE | SWT.READ_ONLY);
		combo.setLayoutData(gridData);
		return combo; 
	}
	protected Combo createComboReadOnly(Composite container, String[] data) {
		Combo combo =createComboReadOnly(container);
		for (int i = 0; i < data.length; i++) {
			combo.add(data[i]);
		}
		return combo; 
	}

	protected void updateStatus(String message) {
		setErrorMessage(message);
		this.canNextPage = (!this.lastPage && message == null);
		setPageComplete(message == null);
	}
//
//	protected void updateStatusForNext(String message) {
//		setErrorMessage(message);
//		this.canNextPage = (message == null);
//	}

	/**
	 * @param listener
	 * @param container 
	 * @return
	 */
	protected Text createText(Composite container, ModifyListener listener) {
		Text text = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		text.setLayoutData(gridData);
		text.addModifyListener(listener);
		return text;
	}

	/**
	 * @param container
	 * @param text
	 * @return 
	 */
	protected Label createLabel(Composite container, String text) {
		Label label = new Label(container, SWT.NULL);
    label.setText(text);
    return label;
	}

	/**
	 * @param container
	 * @param text
	 * @return 
	 */
	protected Label createLabel(Composite container) {
		return createLabel(container,"");
	}


  /**
   * horizontalSpanを指定してラベルを作成
   * @param container コンテナ
   * @param text テキスト
   * @param horizontalSpan 横連結数 
   * @return ラベル
   */
  protected Label createLabelHSpan(Composite container, String text, int hspan) {
    Label label = createLabel(container,text);
    GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
    gridData.horizontalSpan = hspan;
    label.setLayoutData(gridData);
    return label;
  }
  
  /**
   * horizontalSpanを指定してラベルを作成
   * @param container コンテナ
   * @param horizontalSpan 横連結数 
   * @return ラベル
   */
  protected Label createLabelHSpan(Composite container, int hspan) {
    return createLabelHSpan(container, "", hspan);
  }

	/**
	 * @param container
	 * @param browse
	 * @return
	 */
	protected Button createButton(Composite container, String text, SelectionListener adapter) {
		Button button = new Button(container, SWT.PUSH);
		button.setText(text);
		button.addSelectionListener(adapter);
		return button;
	}

	/**
	 * @param jdbcConfig2
	 */
	protected void insertOrUpdateJdbcConfig(JdbcConfig jdbcConfig2) {
		JdbcConfig[] configs = (JdbcConfig[]) DBSysManager.findBy(JdbcConfig.class, 
				" driverClass='" + jdbcConfig2.getDriverClass() + "' "+ 
				" AND url='" + jdbcConfig2.getUrl() + "' "+ 
				" AND user='" + jdbcConfig2.getUser() + "' "+ 
				" AND password='" + jdbcConfig2.getPassword() + "' "
		);
		
		if (configs.length == 0) {
			// 未登録なので追加
			DBSysManager.insert(jdbcConfig2);
		}
	}

	/**
	 * @param container
	 * @param cols 
	 * @param wids 
	 * @return
	 */
	protected Table createTable(Composite container, String[] cols, int[] wids) {
		return PBControlUtil.createSimpleTable(container, cols, wids);
	}

	public boolean canFlipToNextPage() {
		return this.canNextPage;
	}
}
