require 'prb/dbiu'
require 'optparse'

class DBIPool
  def self.check_options(argv, opt={})

    user = opt[:user] || ENV['USER']
    db = opt[:db] || 'DBI:Pg:prb'
    num_conn = opt[:nconn] || 5
    password = opt[:password]

    parser = OptionParser.new do |q|
      q.on('-u=USER', '--user=USER', 'username', String) { |user| }
      q.on('-d=DBNAME', '--db=DBNAME', 'dbname', String) { |db| }
      q.on('-p=PASS', '--password=PASS', 'password', String) { |password| }
      q.on('-n=NUM_CONN', '--num_conn=NUM_CONN', 'number of connections', Integer) { |num_conn| }
    end

    parser.parse!(argv)

    return num_conn, db, user, password
  end
end
