# test_01.rb: test for suikyo.rb
# $Id: test_01.rb,v 1.1 2003/06/02 17:36:25 komatsu Exp $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#
$LOAD_PATH.push(File::dirname($0) + "/..")

require 'suikyo/suikyo'
require 'codetest'
extend(CodeTest)
$KCODE = 'e'

# Beginning of Test
suikyo = Suikyo.new
suikyo.table.loadfile("romaji-kana")

### $BIaDL$K%m!<%^;z$r$R$i$,$J$KJQ49$9$k(B.
codetest("suikyo.convert(\"suikyou\")", __LINE__) {
  a = suikyo.convert("suikyou")
  suikyo.convert("suikyou") == "$B$9$$$-$g$&(B".toeuc
}

### $B8lHx$,3NDj$7$F$$$J$$>l9g$O(B, $B<h$j$&$k8uJd$rG[Ns$GJV$9(B.
codetest("suikyo.expand(\"suiky\")", __LINE__) {
  (hiragana, hiragana_array) = suikyo.expand("suiky")
  hiragana == "$B$9$$(Bky".toeuc and
    hiragana_array == ["$B$9$$$-$c(B".toeuc, "$B$9$$$-$g(B".toeuc, "$B$9$$$-$'(B".toeuc,
                       "$B$9$$$-$#(B".toeuc, "$B$9$$$-$e(B".toeuc]
}

### SuikyoTable $B%/%i%9(B
codetest("SuikyoTable Class", __LINE__) {
  table1 = SuikyoTable.new
  table1.loadfile("romaji-kana")
  suikyo1 = Suikyo.new(table1)
  suikyo1.convert("SuIKyoU") == "S$B$&(BIK$B$h(BU".toeuc
}

### SuikyoTable2 $B%/%i%9(B
codetest("SuikyoTable2 Class", __LINE__) {
  table2 = SuikyoTable2.new
  table2.loadfile("romaji-kana")
  suikyo2 = Suikyo.new(table2)
  suikyo2.convert("SuIKyoU") == "$B$9$$$-$g$&(B".toeuc
}

