;; $Id: prime-style.el,v 1.7 2004/03/19 17:56:09 komatsu Exp $

(defcustom prime-style nil "PRIME $B$NF~NO%9%?%$%k(B
'default, 'kana, 'tcode, 'capital-only, 'komatsu $B$+$iA*Br2DG=(B.
'default: $B%G%U%)%k%H$NF~NO%9%?%$%k(B
'kana:    $B$+$JF~NOMQ%9%?%$%k(B
'tcode:   T-Code$BF~NOMQ%9%?%$%k(B
'capital-only: $BBgJ8;z$N$_$,F|K\8lF~NO3+;O%-!<(B
'komatsu: $B>.>>(B (PRIME $B$N:n<T(B) $B$NF~NO%9%?%$%k(B")

(defvar prime-style-alist
  '(("default"      . prime-style-default)
    ("capital-only" . prime-style-capital-only)
    ("kana"         . prime-style-kana)
    ("tcode"        . prime-style-tcode)
    ("komatsu"      . prime-style-komatsu)))

(defcustom prime-style-kutouten-direct-p t "$B6gFIE@$rB(3NDj$9$k$+$I$&$+(B")
(defcustom prime-style-kutouten-autochange-p nil "$B<+F0E*$K6gFIE@$rJQ99$9$k(B")
(defcustom prime-style-kutouten '("$B!#(B" . "$B!"(B") "$B6gE@(B($B!#(B)$B$HFIE@(B($B!"(B)$B$N%Z%"(B")
(defvar prime-style-kutouten-local nil "$B%P%C%U%!%m!<%+%k$N6gFIE@$N%Z%"(B")
(make-variable-buffer-local 'prime-style-kutouten-local)

(defcustom prime-style-preedit-mask-pending-p nil
  "$BL$3NDj$N%W%j%(%G%#%C%HJ8;z$r(B * $B$G1#$9$+$I$&$+(B (T-Code $BMQ(B)")

(defcustom prime-style-dictionary-command 'lookup-el
  "prime-input-lookup-word $B%3%^%s%I$G;HMQ$9$k<-=q%3%^%s%I$N<oN`(B
lookup-el, ebview $B$^$?$O(B nil $B$,;XDj2DG=$G$9!#(B")

(defcustom prime-style-display-candidates 'compact
  "$BC18l8uJd$NI=<(J}K!(B (compact or all / default is compact)")

(defun prime-style-init (&optional style)
  (setq style (or (and style (symbol-name style))
		  (and prime-style (symbol-name prime-style))
		  (prime-server-get-env "typing_method")))
  (setq style-function (cdr (assoc style prime-style-alist)))
  (and (functionp style-function)
       (apply style-function nil)))

(defun prime-style-default ()
  "$B%G%U%)%k%H$NF~NO%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten-direct-p t)
  (setq prime-style-kutouten '("$B!#(B" . "$B!"(B"))
  (setq prime-direct-key-alist '((?] "$B!W(B") (?[ "$B!V(B")))
  (setq prime-fix-by-capital-p t)
  (setq prime-enum-mode t)
  (setq prime-style-preedit-mask-pending-p nil)
  )

(defun prime-style-kana ()
  "$B$+$JF~NOMQ%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten-direct-p nil)
  (setq prime-direct-key-alist '())
  (setq prime-fix-by-capital-p nil)
  (setq prime-enum-mode nil)
  (setq prime-style-preedit-mask-pending-p nil)
  )

(defun prime-style-tcode ()
  "T-Code$BF~NOMQ%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten-direct-p nil)
  (setq prime-direct-key-alist '())
  (setq prime-fix-by-capital-p nil)
  (setq prime-enum-mode nil)
  (setq prime-style-preedit-mask-pending-p t)
  )

(defun prime-style-capital-only ()
  "$BBgJ8;z$N$_$rF|K\8lF~NO3+;O%-!<$H$9$k(B.
by $BJ?2,$5$s(B <hira@ics.saitama-u.ac.jp>"
  (interactive)
  (setq prime-style-preedit-mask-pending-p nil)
  (let ((symbols "0123456789!@#$%^&*()_=+\\|[{]};:'\"`,.<>~/?")
	(alphabets "abcdefghijklmnopqrstuvwxyz-"))
    (mapcar '(lambda (c)
	       (define-key prime-fund-mode-map (string c) nil))
	    (concat alphabets symbols))
    (setq prime-direct-key-alist
	  (mapcar (lambda (c) (list c (string c)))
		  symbols))
    ))

(defun prime-style-komatsu ()
  "$B>.>>(B (PRIME $B$N:n<T(B) $B$NF~NO%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten '("." . ", "))
  (setq prime-style-kutouten-autochange-p t)
  (setq prime-direct-key-alist
	(append 
	 (mapcar (lambda (c) (list c (string c)))
		 "!@#$%^&*(_=+\\|{;:'\"`.<~")
	 '((?[ "$B!V(B") (?] "$B!W(B") (?? "? ") (?> "> ") (?\) ") ") (?\} "} "))))
  (setq prime-language-always-hiragana nil)
  (setq prime-style-preedit-mask-pending-p nil)
  )

;;;; $B6uGr(B ==========================================

;;;; FIXME: The following Mell codes are not defined on mell-1.0.0
;;;; FIXME: Hiroyuki Komatsu <komatsu@taiyaki.org> (2004-03-19)
(defun mell-require (feature &optional filename noerror)
  (or (featurep feature)
      (if noerror
          (condition-case nil
              (require feature filename)
            (file-error nil)
            )
        (require feature filename)
        )))

(mell-require 'overlay nil t)

(defcustom mell-sign-blink-time 0.5
  "A highlighting time for mell-sign-<region>-blink.")

(defun mell-sign-region-highlight (start end &optional buffer face)
  (save-excursion
    (or buffer (setq buffer (current-buffer)))
    (prog1
        (setq overlay (make-overlay start end buffer nil t))
      (overlay-put overlay 'face (or face 'highlight))
      (overlay-put overlay 'evaporate t)
      )))

(defun mell-sign-region-highlight-off (overlay)
  (delete-overlay overlay)
  )

(defun mell-sign-region-blink (start end &optional buffer face)
  (condition-case nil
      (let ((overlay (mell-sign-region-highlight start end buffer face)))
        (unwind-protect
            (sit-for mell-sign-blink-time)
          (mell-sign-region-highlight-off overlay))
        t)
    (quit nil)
    ))

;; --

(defcustom prime-style-space '(" " . "$B!!(B")
  "Pair of space and alternative space characters.
car space is spposed to be used by Space key and cdr is by Alt-Space keys.")

(defvar prime-style-space-local nil)
(make-variable-buffer-local 'prime-style-space-local)

(defun prime-style-space-set (space &optional alt-space)
  (interactive "s$B%9%Z!<%9%-!<$K$h$k6uGr$rF~NO$7$F$/$@$5$$(B: ")
  (or alt-space
      (setq alt-space (if (equal space " ") "$B!!(B" " ")))
  (setq prime-style-space-local (cons space alt-space))
  )

(defun prime-style-space-insert (&optional alternative-p)
  (let ((space (if alternative-p
		   (or (cdr prime-style-space-local)
		       (cdr prime-style-space))
		 (or (car prime-style-space-local)
		     (car prime-style-space))
		 )))
    (insert space)
    (or (equal space " ")
	(mell-sign-region-blink (point) (1- (point))))
    ))

;;;; $B6gFIE@(B ========================================

(defun mell-match-score-region (regexp-list start end &optional buffer)
  (and buffer (set-buffer buffer))
  (sort
   (mapcar '(lambda (symbol)
	      (let ((symbol-output (if (consp symbol) (car symbol) symbol))
		    (symbol-regexp (if (consp symbol) (cdr symbol) symbol)))
		(cons symbol-output
		      (mell-match-count-region symbol-regexp start end))))
	   regexp-list)
   '(lambda (val1 val2)
      (> (cdr val1) (cdr val2)))
   ))

(defun mell-match-score-buffer (regexp-list &optional buffer)
  (and buffer (set-buffer buffer))
  (mell-match-score-region regexp-list (point-min) (point-max)))

;; mell $B9T$-(B?
(defvar prime-style-kuten-list  '("$B!#(B" "$B!%(B" ("."  . "\\cj\\. \\|\\cj\\.$")))
(defvar prime-style-touten-list '("$B!"(B" "$B!$(B" (", " . "\\cj\\, \\|\\cj\\,$")))

;; mell $B9T$-(B?
(defun prime-style-kutouten-guess ()
  (cons
   (car (car (mell-match-score-region prime-style-kuten-list
				      (max (point-min) (- (point) 1000))
				      (min (point-max) (+ (point) 1000))
				      )))
   (car (car (mell-match-score-region prime-style-touten-list
				      (max (point-min) (- (point) 1000))
				      (min (point-max) (+ (point) 1000))
				      )))
   ))

(defun prime-style-kutouten-set (kuten touten)
  (interactive "s$B6gE@(B ($B!#$J$I(B): \ns$BFIE@(B ($B!"$J$I(B): ")
  (setq prime-style-kutouten-local (cons kuten touten))
  )

(defun prime-style-kutouten-set-automatically ()
  (interactive)
  (if (null prime-style-kutouten-local)
      (let ((kutouten (prime-style-kutouten-guess)))
	(prime-style-kutouten-set (car kutouten) (cdr kutouten))
	)))

(provide 'prime-style)
