/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import jp.eclipse.plugin.proptranslator.ExciteTranslator;
import jp.eclipse.plugin.proptranslator.InfoseekTranslator;
import jp.eclipse.plugin.proptranslator.PropTranslatorPlugin;
import jp.eclipse.plugin.proptranslator.Translator;
import jp.eclipse.plugin.proptranslator.action.Messages;
import jp.eclipse.plugin.proptranslator.preferencePage.WordRegistModel;
import jp.eclipse.plugin.proptranslator.util.PreferenceUtils;
import jp.eclipse.plugin.proptranslator.util.StringUtils;
import jp.eclipse.plugin.proptranslator.wizard.FileModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class Translate {
    public static int countTask(FileModel model) {
        int task = 0;
        BufferedReader br = null;
        try {
            try {
                String fileName = String.valueOf(model.getAbsoluteCurrentDir()) + model.getFileName();
                br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
                while (br.readLine() != null) {
                    ++task;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return task;
    }

    public static void run(FileModel model, IProgressMonitor monitor) {
        String fileName = String.valueOf(model.getAbsoluteCurrentDir()) + model.getFileName();
        String translatedFileName = String.valueOf(model.getAbsoluteCurrentDir()) + model.getTranslatedFileName();
        IPreferenceStore store = PropTranslatorPlugin.getDefault().getPreferenceStore();
        String site = store.getString(PropTranslatorPlugin.PREF_TRANSLATE_SITE);
        List<WordRegistModel> models = PreferenceUtils.getRegistWordModels(store);
        Translator translator = null;
        translator = site.equals("Infoseek") ? new InfoseekTranslator() : new ExciteTranslator();
        monitor.subTask(String.valueOf(model.getRelativeCurrentDir()) + model.getFileName() + Messages.getString("Translate.0"));
        BufferedReader br = null;
        BufferedReader br2 = null;
        BufferedWriter bw = null;
        try {
            try {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "ISO-8859-1"));
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(translatedFileName), "ISO-8859-1"));
                boolean commentLine = false;
                while ((line = br.readLine()) != null) {
                    String comment = "";
                    String key = "";
                    String value = "";
                    String translatedValue = "";
                    if ("".equals(line.trim())) {
                        bw.newLine();
                        continue;
                    }
                    commentLine = line.trim().startsWith("#");
                    if (commentLine) {
                        StringBuffer sbComment = new StringBuffer();
                        StringBuffer sbValue = new StringBuffer();
                        int i = 0;
                        while (i < line.length()) {
                            char c = line.charAt(i);
                            if (c == '#') {
                                sbComment.append(c);
                            } else {
                                sbValue.append(c);
                            }
                            ++i;
                        }
                        comment = sbComment.toString();
                        value = sbValue.toString();
                    } else {
                        String[] props = line.split("=");
                        if (props.length != 2) {
                            bw.newLine();
                            continue;
                        }
                        key = props[0];
                        value = props[1];
                    }
                    String valueStr = StringUtils.unicodeEsc2Unicode(value);
                    if (value.length() > 0) {
                        int i = 0;
                        while (i < models.size()) {
                            WordRegistModel registModel = models.get(i);
                            boolean flg = registModel.isFlg();
                            String word = registModel.getWord();
                            String translatedWord = registModel.getTranslatedWord();
                            if (flg && valueStr.indexOf(word) > -1) {
                                valueStr = valueStr.replace(word, translatedWord);
                            }
                            ++i;
                        }
                        String urlStr = translator.getUrl(valueStr);
                        br2 = new BufferedReader(new InputStreamReader(new URL(urlStr).openStream()));
                        String line2 = null;
                        while ((line2 = br2.readLine()) != null) {
                            if (!line2.startsWith(translator.getResultTag())) continue;
                            translatedValue = StringUtils.replaceStr(StringUtils.getTagText(line2));
                        }
                    }
                    if (commentLine) {
                        bw.write(String.valueOf(comment) + translatedValue);
                    } else {
                        bw.write(String.valueOf(key) + "=" + translatedValue);
                    }
                    bw.newLine();
                    monitor.worked(1);
                }
                bw.flush();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                br.close();
                br2.close();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

