/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.preferencePage;

import java.util.List;
import jp.eclipse.plugin.proptranslator.PropTranslatorPlugin;
import jp.eclipse.plugin.proptranslator.preferencePage.WordRegistDialog;
import jp.eclipse.plugin.proptranslator.preferencePage.WordRegistLabelProvider;
import jp.eclipse.plugin.proptranslator.preferencePage.WordRegistModel;
import jp.eclipse.plugin.proptranslator.util.PreferenceUtils;
import jp.eclipse.plugin.proptranslator.xstream.XStreamSerializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WordRegistPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer viewer;
    private List<WordRegistModel> wordRegistModels;
    private Button add;
    private Button edit;
    private Button remove;
    private Button up;
    private Button down;

    public WordRegistPreferencePage() {
    }

    public WordRegistPreferencePage(String title) {
        super(title);
    }

    public WordRegistPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite viewComposite = new Composite(composite, 0);
        viewComposite.setLayout((Layout)new GridLayout(1, false));
        viewComposite.setLayoutData((Object)new GridData(1808));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)viewComposite, (int)68352);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText("");
        column = new TableColumn(table, 0);
        column.setText("\u5358\u8a9e");
        column = new TableColumn(table, 0);
        column.setText("\u7ffb\u8a33\u5f8c");
        String[] properties = new String[]{"", "", "text"};
        this.viewer.setColumnProperties(properties);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = new TextCellEditor((Composite)table);
        CellEditor[] editors = cellEditorArray;
        this.viewer.setCellEditors(editors);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WordRegistLabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WordRegistModel model = (WordRegistModel)event.getElement();
                WordRegistPreferencePage.this.setCheckBox(model);
            }
        });
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent evt) {
                IStructuredSelection sel;
                if (evt.button == 1 && !(sel = (IStructuredSelection)WordRegistPreferencePage.this.viewer.getSelection()).isEmpty()) {
                    WordRegistPreferencePage.this.edit(((IStructuredSelection)WordRegistPreferencePage.this.viewer.getSelection()).getFirstElement());
                    WordRegistPreferencePage.this.viewer.refresh();
                }
            }
        });
        IPreferenceStore store = PropTranslatorPlugin.getDefault().getPreferenceStore();
        this.wordRegistModels = PreferenceUtils.getRegistWordModels(store);
        this.viewer.setInput(this.wordRegistModels);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WordRegistPreferencePage.this.updateButtons();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WordRegistPreferencePage.this.updateButtons();
            }
        });
        for (WordRegistModel model : this.wordRegistModels) {
            this.viewer.setChecked((Object)model, model.isFlg());
        }
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        this.createButtonPart(composite);
        this.updateButtons();
        return this.viewer.getControl();
    }

    private void createButtonPart(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData();
        gd.verticalSpan = 5;
        gd.verticalAlignment = 16;
        buttonComposite.setLayoutData((Object)gd);
        this.add = new Button(buttonComposite, 8);
        this.add.setText("\u8ffd\u52a0(&A)");
        this.add.setLayoutData((Object)new GridData(768));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordRegistPreferencePage.this.add();
            }
        });
        this.edit = new Button(buttonComposite, 8);
        this.edit.setText("\u7de8\u96c6(&E)");
        this.edit.setLayoutData((Object)new GridData(768));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordRegistPreferencePage.this.edit(((IStructuredSelection)WordRegistPreferencePage.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.remove = new Button(buttonComposite, 8);
        this.remove.setText("\u524a\u9664(&R)");
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordRegistPreferencePage.this.remove(((IStructuredSelection)WordRegistPreferencePage.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.up = new Button(buttonComposite, 8);
        this.up.setText("\u4e0a\u3078(&U)");
        this.up.setLayoutData((Object)new GridData(768));
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordRegistPreferencePage.this.up(((IStructuredSelection)WordRegistPreferencePage.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.down = new Button(buttonComposite, 8);
        this.down.setText("\u4e0b\u3078(&D)");
        this.down.setLayoutData((Object)new GridData(768));
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordRegistPreferencePage.this.down(((IStructuredSelection)WordRegistPreferencePage.this.viewer.getSelection()).getFirstElement());
            }
        });
    }

    private void add() {
        WordRegistDialog dialog = new WordRegistDialog(this.getShell(), this.wordRegistModels, null);
        if (dialog.open() == 0) {
            this.viewer.refresh();
        }
    }

    private void edit(Object obj) {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        WordRegistDialog dialog = new WordRegistDialog(this.getShell(), this.wordRegistModels, sel.getFirstElement());
        if (dialog.open() == 0) {
            this.viewer.refresh();
        }
    }

    private void up(Object obj) {
        int index = this.wordRegistModels.indexOf(obj);
        if (index > 0) {
            this.wordRegistModels.remove(index);
            this.wordRegistModels.add(index - 1, (WordRegistModel)obj);
        }
        this.viewer.refresh();
        this.updateButtons();
    }

    private void down(Object obj) {
        int index = this.wordRegistModels.indexOf(obj);
        if (index < this.wordRegistModels.size() - 1) {
            this.wordRegistModels.remove(index);
            this.wordRegistModels.add(index + 1, (WordRegistModel)obj);
        }
        this.viewer.refresh();
        this.updateButtons();
    }

    private void remove(Object obj) {
        this.wordRegistModels.remove(obj);
        this.viewer.refresh();
    }

    private void updateButtons() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        this.remove.setEnabled(!sel.isEmpty());
        this.edit.setEnabled(!sel.isEmpty());
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        if (!sel.isEmpty()) {
            Object obj = sel.getFirstElement();
            int index = this.wordRegistModels.indexOf(obj);
            this.up.setEnabled(index > 0);
            this.down.setEnabled(index < this.wordRegistModels.size() - 1);
        }
    }

    private void setCheckBox(WordRegistModel model) {
        if (model.isFlg()) {
            model.setFlg(false);
        } else {
            model.setFlg(true);
        }
    }

    public boolean performOk() {
        IPreferenceStore store = PropTranslatorPlugin.getDefault().getPreferenceStore();
        store.setValue(PropTranslatorPlugin.PREF_WORD_REGIST, XStreamSerializer.serialize(this.wordRegistModels, ((Object)((Object)this)).getClass().getClassLoader()));
        return true;
    }

    protected void performDefaults() {
        this.wordRegistModels.clear();
        this.viewer.refresh();
    }

    public void init(IWorkbench workbench) {
    }
}

