/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jp.eclipse.plugin.proptranslator.ExciteTranslator;
import jp.eclipse.plugin.proptranslator.InfoseekTranslator;
import jp.eclipse.plugin.proptranslator.PropTranslatorPlugin;
import jp.eclipse.plugin.proptranslator.Translator;
import jp.eclipse.plugin.proptranslator.action.Translate;
import jp.eclipse.plugin.proptranslator.util.PreferenceUtils;
import jp.eclipse.plugin.proptranslator.wizard.FileModel;
import jp.eclipse.plugin.proptranslator.wizard.FileSelectWizardPage1;
import jp.eclipse.plugin.proptranslator.wizard.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private FileSelectWizardPage1 page1;
    private static ArrayList<IFile> files;

    public FileSelectWizard() {
        this.setWindowTitle(Messages.getString("FileSelectWizard.0"));
    }

    public void addPages() {
        List<IFile> files = FileSelectWizard.getFiles(this.selection);
        this.page1 = new FileSelectWizardPage1(files);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        final List lists = this.page1.getFileBeans();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    FileModel model;
                    IPreferenceStore store = PropTranslatorPlugin.getDefault().getPreferenceStore();
                    String storeSite = store.getString(PropTranslatorPlugin.PREF_TRANSLATE_SITE);
                    Translator translator = null;
                    translator = storeSite.equals("Infoseek") ? new InfoseekTranslator() : new ExciteTranslator();
                    int task = 0;
                    int i = 0;
                    while (i < lists.size()) {
                        model = (FileModel)lists.get(i);
                        if (model.getCheckFlg()) {
                            task += Translate.countTask(model);
                        }
                        ++i;
                    }
                    monitor.beginTask(String.valueOf(translator.getSiteName()) + Messages.getString("FileSelectWizard.1"), task);
                    i = 0;
                    while (i < lists.size()) {
                        model = (FileModel)lists.get(i);
                        if (model.getCheckFlg()) {
                            Translate.run(model, monitor);
                            try {
                                ((IFile)files.get(i)).getParent().refreshLocal(2, null);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        MessageDialog.openInformation((Shell)shell, (String)"PropTranslation", (String)Messages.getString("FileSelectWizard.3"));
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public static List<IFile> getFiles(IStructuredSelection selection) {
        files = new ArrayList();
        if (selection != null && !selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection;
            for (Object obj : ss) {
                if (obj instanceof IProject) {
                    try {
                        files.addAll((ArrayList)PreferenceUtils.getPropertyFiles((IProject)obj));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(obj instanceof IFile)) continue;
                files.add((IFile)obj);
            }
        }
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < files.size()) {
            IFile file = files.get(i);
            if (!list.contains(file)) {
                list.add(file);
            }
            ++i;
        }
        return list;
    }
}

