#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<time.h>

#include	<sys/ioctl.h>
#include	"pt1_ioctl.h"

char	*bsdev[2] = {
	"/dev/pt1video1",
	"/dev/pt1video0"
};
char	*isdb_t_dev[2] = {
	"/dev/pt1video2",
	"/dev/pt1video3"
};

char	buffer[64*1024];
// 151chBSī
// 161chBS-i
// 171chBSѥ
// 211chBS11ǥ
// 222chTwellV
// 141chBSƥ
// 181chBSե
// 101chNHK1(BS1)
// 102chNHK2(BS2)
// 103chNHKϥӥ(BShi)

int		main(int argc, char **argv)
{
	int		fd ;
	int		fd2 ;
	int		rc ;
	int		lp ;
	int		channel ;
	int		recsec ;
	time_t	start_time ;
	time_t	cur_time ;

	if(argc < 4){
		printf("Usage %s: channel recsec destfile\n", argv[0]);
		return 1;
	}
	channel = atoi(argv[1]);
	if(channel > 100){
		for(lp = 0 ; lp < 2 ; lp++){
			fd = open(bsdev[lp], O_RDONLY);
			if(fd >= 0){
				break ;
			}
		}
		if(fd < 0){
			printf("Device Open Error\n");
			return 1;
		}
	}else{
		for(lp = 0 ; lp < 2 ; lp++){
			fd = open(isdb_t_dev[lp], O_RDONLY);
			if(fd >= 0){
				break ;
			}
		}
		if(fd < 0){
			printf("Device Open Error\n");
			return 1;
		}
	}
	recsec = atoi(argv[2]);
	fd2 = open(argv[3], (O_RDWR | O_CREAT | O_TRUNC), 0666);
	if(fd2 < 0){
		printf("Output File Open Error(%s)\n", argv[3]);
		return 0;
	}

	if(ioctl(fd, SET_CHANNEL, channel) < 0){
		printf("Tuner Select Error\n");
		return 0 ;
	}
	if(ioctl(fd, START_REC, 0) < 0){
		printf("Tuner Start Error\n");
		return 0 ;
	}

	time(&start_time);
	while(1){
		rc = read(fd, buffer, sizeof(buffer));
		write(fd2, buffer, rc);
		time(&cur_time);
		if((cur_time - start_time) >= recsec){
			ioctl(fd, STOP_REC, 0);
			close(fd);
			close(fd2);
			break ;
		}
	}
}
