/*
 * Decompiled with CFR 0.152.
 */
package pxv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;

class CSVParser {
    private static final char Quote = '\"';
    private static final char Comma = ',';
    private static final char Escape = '\\';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int EOF = -1;

    CSVParser() {
    }

    public static void parse(Reader in, Handler callback) throws IOException {
        PushbackReader cin = new PushbackReader(new BufferedReader(in));
        ArrayList<String> holder = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        State stat = State.Default;
        int c = 0;
        while ((c = cin.read()) != -1) {
            block0 : switch (stat) {
                case Default: {
                    switch (c) {
                        case 34: {
                            stat = State.Quoted;
                            break block0;
                        }
                        case 44: {
                            holder.add(buffer.toString());
                            buffer = new StringBuffer();
                            break block0;
                        }
                        case 13: {
                            stat = State.CR;
                            break block0;
                        }
                        case 10: {
                            callback.update(holder.toArray(new String[0]));
                            stat = State.Default;
                            holder.clear();
                            break block0;
                        }
                    }
                    buffer.append((char)c);
                    break;
                }
                case Quoted: {
                    if (c == 34) {
                        stat = State.Default;
                        break;
                    }
                    if (c == 92) {
                        stat = State.Escaped;
                        break;
                    }
                    buffer.append((char)c);
                    break;
                }
                case Escaped: {
                    buffer.append('\\');
                    buffer.append((char)c);
                    stat = State.Quoted;
                    break;
                }
                case CR: {
                    if (c == 10) {
                        stat = State.LF;
                        break;
                    }
                    stat = State.Default;
                    callback.update(holder.toArray(new String[0]));
                    cin.unread(c);
                }
            }
        }
    }

    public static interface Handler {
        public void update(String[] var1);
    }

    private static enum State {
        Default,
        Quoted,
        Escaped,
        CR,
        LF;

    }
}

