/*
 * Decompiled with CFR 0.152.
 */
package pxv;

import java.io.IOException;
import java.net.URL;
import pxv.PixivAPI;
import pxv.User;

public class Image {
    private final PixivAPI api;
    private final int id;
    private final int authorId;
    private final String ext;
    private final String title;
    private final String server;
    private final String authorName;
    private final URL thumbURL;
    private final URL mobileURL;
    private final String date;
    private final String tags;
    private final String tool;
    private final int feedback;
    private final int point;
    private final int views;
    private final String comment;
    private final URL url;
    private final URL imageURL;

    Image(PixivAPI api, String[] data) throws IOException {
        assert (data.length > 17);
        this.api = api;
        this.id = Integer.parseInt(data[0]);
        this.authorId = Integer.parseInt(data[1]);
        this.ext = data[2];
        this.title = data[3];
        this.server = data[4];
        this.authorName = data[5];
        this.thumbURL = new URL(data[6]);
        this.mobileURL = new URL(data[9]);
        this.date = data[12];
        this.tags = data[13];
        this.tool = data[14];
        this.feedback = Integer.parseInt(data[15]);
        this.point = Integer.parseInt(data[16]);
        this.views = Integer.parseInt(data[17]);
        this.comment = data[18];
        this.url = new URL(String.format("http://www.pixiv.net/member_illust.php?mode=medium&illust_id=%s", this.id));
        String rawMobileURL = this.mobileURL.toString();
        this.imageURL = new URL(String.valueOf(rawMobileURL.substring(0, rawMobileURL.lastIndexOf("/mobile/") + 1)) + this.id + "." + this.ext);
    }

    public int getId() {
        return this.id;
    }

    public int getAuthorId() {
        return this.authorId;
    }

    public String getExt() {
        return this.ext;
    }

    public String getTitle() {
        return this.title;
    }

    public String getServer() {
        return this.server;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public URL getThumbURL() {
        return this.thumbURL;
    }

    public URL getMobileURL() {
        return this.mobileURL;
    }

    public String getDate() {
        return this.date;
    }

    public String getTags() {
        return this.tags;
    }

    public String getTool() {
        return this.tool;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public int getPoint() {
        return this.point;
    }

    public int getViews() {
        return this.views;
    }

    public String getComment() {
        return this.comment;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public User getAuthor() {
        return this.api.findUser(this.getAuthorId(), this.getAuthorName());
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getName());
        ret.append("[id: ");
        ret.append(this.getId());
        ret.append(", title: ");
        ret.append(this.getTitle());
        ret.append(", author name: ");
        ret.append(this.getAuthorName());
        ret.append(", data: ");
        ret.append(this.getDate());
        ret.append("]");
        return ret.toString();
    }

    public int hashCode() {
        return Integer.valueOf(this.id).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Image) {
            Image that = (Image)obj;
            return this.getId() == that.getId();
        }
        return super.equals(obj);
    }
}

