/*
 * Decompiled with CFR 0.152.
 */
package pxv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pxv.CSVParser;
import pxv.Image;
import pxv.User;

public class PixivAPI {
    private final URL base = new URL("http://iphone.pxv.jp/iphone/");
    private String session = "0";
    private static final String BaseURL = "http://iphone.pxv.jp/iphone/";
    private static final String SessionID = "PHPSESSID";
    private static final String DummyParameter = "dummy=0";
    private static final String Daily = "mode=day";
    private static final String Weekly = "mode=week";
    private static final String Monthly = "mode=month";
    private static final String IDParamTemplate = "id=%d";
    private static final String UTF8 = "UTF-8";
    private static final String Zero = "0";

    public boolean login(String id, String password) {
        try {
            URL url = new URL(this.base, String.format("login.php?mode=login&pixiv_id=%s&pass=%s&skip=0", id, password));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.connect();
            if (con.getResponseCode() == 200) {
                URL res = con.getURL();
                this.session = this.parseParameters(res.getQuery()).get(SessionID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.logined();
    }

    public boolean logined() {
        return this.session != Zero;
    }

    public boolean status() {
        try {
            URL url = new URL(this.base, "maintenance.php?software-version=1.0");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            return con.getResponseCode() == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String profile() {
        StringBuffer ret = new StringBuffer();
        try {
            URL url = new URL(this.base, String.format("profile.php?dummy=0&%s=%s", SessionID, this.session));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            if (con.getResponseCode() == 200) {
                String buf;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((buf = in.readLine()) != null) {
                    ret.append(buf);
                    ret.append("\n");
                }
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret.toString();
    }

    public int getNewImageSize() {
        return this.getSize(Type.new_illust, DummyParameter);
    }

    public List<Image> getNewImages(int page) {
        return this.getImages(Type.new_illust, DummyParameter, page);
    }

    public int getMyPixivNewImageSize() {
        return this.getSize(Type.mypixiv_new_illust, DummyParameter);
    }

    public List<Image> getMyPixivNewImages(int page) {
        return this.getImages(Type.mypixiv_new_illust, DummyParameter, page);
    }

    public int getBookmarkedUserNewImageSize() {
        return this.getSize(Type.bookmark_user_new_illust, DummyParameter);
    }

    public List<Image> getBookmarkedUserNewImages(int page) {
        return this.getImages(Type.bookmark_user_new_illust, DummyParameter, page);
    }

    public int getDailyRankingImageSize() {
        return this.getSize(Type.ranking, Daily);
    }

    public List<Image> getDailyRankingImages(int page) {
        return this.getImages(Type.ranking, Daily, page);
    }

    public int getWeeklyRankingImageSize() {
        return this.getSize(Type.ranking, Weekly);
    }

    public List<Image> getWeeklyRankingImages(int page) {
        return this.getImages(Type.ranking, Weekly, page);
    }

    public int getMonthlyRankingImageSize() {
        return this.getSize(Type.ranking, Monthly);
    }

    public List<Image> getMonthlyRankingImages(int page) {
        return this.getImages(Type.ranking, Monthly, page);
    }

    public List<Image> findImagesByTag(String keyword, int size) throws IOException {
        String param = String.format("s_mode=s_tag&word=%s", URLEncoder.encode(keyword, UTF8));
        return this.findImages(param, size);
    }

    public List<Image> findImagesByTitle(String keyword, int size) throws IOException {
        String param = String.format("s_mode=s_tc&word=%s", URLEncoder.encode(keyword, UTF8));
        return this.findImages(param, size);
    }

    public List<User> findUsers(String name, int size) throws IOException {
        List<User> sub;
        ArrayList<User> ret = new ArrayList<User>();
        String param = String.format("nick=%s", URLEncoder.encode(name, UTF8));
        int i = 0;
        while ((sub = this.getUsers(Type.search, param, i)).size() != 0) {
            ret.addAll(sub);
            ++i;
        }
        return ret;
    }

    public User findUser(final int id, String name) {
        final ArrayList ret = new ArrayList();
        try {
            int i = 0;
            while (ret.size() == 0 && i < 100) {
                URL url = new URL(this.base, String.format("%s.php?nick=%s&%s=%s&p=%d", new Object[]{Type.search_user, URLEncoder.encode(name, UTF8), SessionID, this.session, i}));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.connect();
                if (con.getResponseCode() == 200) {
                    InputStreamReader in = new InputStreamReader(con.getInputStream());
                    CSVParser.parse(in, new CSVParser.Handler(){

                        @Override
                        public void update(String[] data) {
                            try {
                                User u = new User(PixivAPI.this, data);
                                if (u.getId() == id) {
                                    ret.add(u);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    ((Reader)in).close();
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ret.size() != 0) {
            return (User)ret.get(0);
        }
        return null;
    }

    public int getImageSize(int userId) {
        return this.getSizeById(Type.member_illust, userId);
    }

    public List<Image> getImages(int userId, int page) {
        return this.getImagesByUserId(Type.member_illust, userId, page);
    }

    public int getMyPixivSize(int usrId) {
        return this.getSizeById(Type.mypixiv_all, usrId);
    }

    public List<User> getMyPixivUsers(int usrId, int page) {
        return this.getUsersById(Type.mypixiv_all, usrId, page);
    }

    public int getBookmarkedUserSize(int id) {
        return this.getSizeById(Type.bookmark_user_all, id);
    }

    public List<User> getBookmarkedUsers(int id, int page) {
        return this.getUsersById(Type.bookmark_user_all, id, page);
    }

    public int getBookmarkSize(int id) {
        return this.getSizeById(Type.bookmark, id);
    }

    public List<Image> getBookmarks(int id, int page) {
        return this.getImagesByUserId(Type.bookmark, id, page);
    }

    private Map<String, String> parseParameters(String params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Pattern param = Pattern.compile("(\\w+)=(\\w+)");
        Matcher m = param.matcher(params);
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            ret.put(key, value);
        }
        return ret;
    }

    private int getSize(Type type, String param) {
        int ret = -1;
        try {
            URL url = new URL(this.base, String.format("%s.php?%s&%s=%s&c_mode=count", new Object[]{type, param, SessionID, this.session}));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            if (con.getResponseCode() == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String buf = in.readLine();
                if (buf != null) {
                    ret = Integer.parseInt(buf);
                }
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private int getSizeById(Type type, int id) {
        return this.getSize(type, String.format(IDParamTemplate, id));
    }

    private List<Image> getImages(Type type, String param, int page) {
        final ArrayList<Image> ret = new ArrayList<Image>();
        try {
            URL url = new URL(this.base, String.format("%s.php?%s&%s=%s&p=%d", new Object[]{type, param, SessionID, this.session, page}));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            if (con.getResponseCode() == 200) {
                InputStreamReader in = new InputStreamReader(con.getInputStream());
                CSVParser.parse(in, new CSVParser.Handler(){

                    @Override
                    public void update(String[] data) {
                        try {
                            Image image = new Image(PixivAPI.this, data);
                            if (!ret.contains(image)) {
                                ret.add(image);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                ((Reader)in).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private List<Image> getImagesByUserId(Type type, int id, int page) {
        return this.getImages(type, String.format(IDParamTemplate, id), page);
    }

    private List<Image> findImages(String param, int size) throws IOException {
        ArrayList<Image> ret = new ArrayList<Image>();
        int i = 0;
        while (ret.size() < size) {
            List<Image> sub = this.getImages(Type.search, param, i);
            if (sub.size() == 0) break;
            ret.addAll(sub);
            ++i;
        }
        return ret;
    }

    private List<User> getUsers(Type type, String param, int page) {
        final ArrayList<User> ret = new ArrayList<User>();
        try {
            URL url = new URL(this.base, String.format("%s.php?%s&%s=%s&p=%d", new Object[]{type, param, SessionID, this.session, page}));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            if (con.getResponseCode() == 200) {
                InputStreamReader in = new InputStreamReader(con.getInputStream());
                CSVParser.parse(in, new CSVParser.Handler(){

                    @Override
                    public void update(String[] data) {
                        try {
                            ret.add(new User(PixivAPI.this, data));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                ((Reader)in).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private List<User> getUsersById(Type type, int id, int page) {
        return this.getUsers(type, String.format(IDParamTemplate, id), page);
    }

    public static void main(String[] args) throws IOException {
        PixivAPI api = new PixivAPI();
        System.out.println("Status: " + api.status());
        System.out.println("= new images on the 1st page");
        for (Image i : api.getNewImages(0)) {
            System.out.println(String.format("%s by %s (%s)", i.getTitle(), i.getAuthorName(), i.getImageURL()));
            User author = i.getAuthor();
            if (author == null) continue;
            for (User user : author.getBookmarkedUsers(0)) {
                System.out.println(">> " + user);
            }
        }
        System.out.println("= find images by tag");
        for (Image i : api.findImagesByTag(args[2], 10)) {
            System.out.println(String.format("%s by %s (%s)", i.getTitle(), i.getAuthorName(), i.getImageURL()));
        }
        if (api.login(args[0], args[1])) {
            System.out.println("Profile: " + api.profile());
            System.out.println("My pixiv new images: " + api.getMyPixivNewImageSize());
        }
    }

    private static enum Type {
        new_illust,
        mypixiv_new_illust,
        bookmark_user_new_illust,
        ranking,
        search,
        search_user,
        bookmark,
        bookmark_user_all,
        mypixiv_all,
        member_illust;

    }
}

